/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.mythica.compat.terrablender;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import medi.makiba.mythica.mixin.terrablender.SurfaceRuleManagerAccessor;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import terrablender.api.SurfaceRuleManager;
import terrablender.worldgen.surface.NamespacedSurfaceRuleSource;

public class MythicaSurfaceRuleData {
    private static final SurfaceRules.RuleSource AIR;
    private static final SurfaceRules.RuleSource BEDROCK;
    private static final SurfaceRules.RuleSource WHITE_TERRACOTTA;
    private static final SurfaceRules.RuleSource ORANGE_TERRACOTTA;
    private static final SurfaceRules.RuleSource TERRACOTTA;
    private static final SurfaceRules.RuleSource RED_SAND;
    private static final SurfaceRules.RuleSource RED_SANDSTONE;
    private static final SurfaceRules.RuleSource STONE;
    private static final SurfaceRules.RuleSource DEEPSLATE;
    private static final SurfaceRules.RuleSource DIRT;
    private static final SurfaceRules.RuleSource PODZOL;
    private static final SurfaceRules.RuleSource COARSE_DIRT;
    private static final SurfaceRules.RuleSource MYCELIUM;
    private static final SurfaceRules.RuleSource GRASS_BLOCK;
    private static final SurfaceRules.RuleSource CALCITE;
    private static final SurfaceRules.RuleSource GRAVEL;
    private static final SurfaceRules.RuleSource SAND;
    private static final SurfaceRules.RuleSource SANDSTONE;
    private static final SurfaceRules.RuleSource PACKED_ICE;
    private static final SurfaceRules.RuleSource SNOW_BLOCK;
    private static final SurfaceRules.RuleSource MUD;
    private static final SurfaceRules.RuleSource POWDER_SNOW;
    private static final SurfaceRules.RuleSource ICE;
    private static final SurfaceRules.RuleSource WATER;
    private static final ResourceKey<Biome> MYTHICA_BEACH;
    private static final ResourceKey<Biome> MYTHICA_DEEP_FROZEN_OCEAN;
    private static final ResourceKey<Biome> MYTHICA_DEEP_LUKEWARM_OCEAN;
    private static final ResourceKey<Biome> MYTHICA_DRIPSTONE_CAVES;
    private static final ResourceKey<Biome> MYTHICA_FROZEN_OCEAN;
    private static final ResourceKey<Biome> MYTHICA_LUKEWARM_OCEAN;
    private static final ResourceKey<Biome> MYTHICA_SNOWY_BEACH;
    private static final ResourceKey<Biome> MYTHICA_STONY_SHORE;
    private static final ResourceKey<Biome> MYTHICA_WARM_OCEAN;
    private static final ResourceKey<Biome> MYTHICA_DESERT;
    private static final ResourceKey<Biome> MYTHICA_STONY_PEAKS;
    private static final ResourceKey<Biome> MYTHICA_WINDSWEPT_HILLS;
    private static final ResourceKey<Biome> MYTHICA_FROZEN_PEAKS;
    private static final ResourceKey<Biome> MYTHICA_JAGGED_PEAKS;
    private static final ResourceKey<Biome> MYTHICA_GROVE;
    private static final ResourceKey<Biome> MYTHICA_WINDSWEPT_GRAVELLY_HILLS;
    private static final ResourceKey<Biome> MYTHICA_MANGROVE_SWAMP;
    private static final ResourceKey<Biome> MYTHICA_SNOWY_SLOPES;
    private static final ResourceKey<Biome> MYTHICA_OLD_GROWTH_PINE_TAIGA;
    private static final ResourceKey<Biome> MYTHICA_OLD_GROWTH_SPRUCE_TAIGA;
    private static final ResourceKey<Biome> MYTHICA_ICE_SPIKES;
    private static final ResourceKey<Biome> MYTHICA_MUSHROOM_FIELDS;
    private static final ResourceKey<Biome> MYTHICA_WOODED_BADLANDS;
    private static final ResourceKey<Biome> MYTHICA_BADLANDS;
    private static final ResourceKey<Biome> MYTHICA_ERODED_BADLANDS;
    private static final ResourceKey<Biome> MYTHICA_SWAMP;
    private static final ResourceKey<Biome> MYTHICA_WINDSWEPT_SAVANNA;

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }

    public static SurfaceRules.RuleSource mythica() {
        SurfaceRules.ConditionSource isBlockAboveY97WithVariationAbove = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)97), (int)2);
        SurfaceRules.ConditionSource isBlockAboveY256 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)256), (int)0);
        SurfaceRules.ConditionSource isSurfaceAbove63WithVariationBelow = SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)-1);
        SurfaceRules.ConditionSource isSurfaceAboveY74WithVariationAbove = SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)74), (int)1);
        SurfaceRules.ConditionSource isBlockAboveY60 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)60), (int)0);
        SurfaceRules.ConditionSource isBlockAboveY62 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0);
        SurfaceRules.ConditionSource isBlockAboveY63 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)0);
        SurfaceRules.ConditionSource isInOrAboveShallowWater = SurfaceRules.waterBlockCheck((int)-1, (int)0);
        SurfaceRules.ConditionSource isAboveWater = SurfaceRules.waterBlockCheck((int)0, (int)0);
        SurfaceRules.ConditionSource isInOrAboveDeepWaterWithVariationBelow = SurfaceRules.waterStartCheck((int)-6, (int)-1);
        SurfaceRules.ConditionSource isHole = SurfaceRules.hole();
        SurfaceRules.ConditionSource isFrozenOcean = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, MYTHICA_FROZEN_OCEAN, MYTHICA_DEEP_FROZEN_OCEAN});
        SurfaceRules.ConditionSource isSteep = SurfaceRules.steep();
        SurfaceRules.RuleSource surfaceGrassOrDirtIfSubmerged = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)GRASS_BLOCK), DIRT});
        SurfaceRules.RuleSource sandOrSandstoneCeiling = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)SANDSTONE), SAND});
        SurfaceRules.RuleSource gravelOrStoneCeiling = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)STONE), GRAVEL});
        SurfaceRules.ConditionSource isSandyShoreOrOcean = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WARM_OCEAN, Biomes.BEACH, Biomes.SNOWY_BEACH, MYTHICA_WARM_OCEAN, MYTHICA_BEACH, MYTHICA_SNOWY_BEACH});
        SurfaceRules.ConditionSource isDesert = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.DESERT, MYTHICA_DESERT});
        SurfaceRules.RuleSource onAndUnderFloorSurfaceRules = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.STONY_PEAKS, MYTHICA_STONY_PEAKS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.CALCITE, (double)-0.0125, (double)0.0125), (SurfaceRules.RuleSource)CALCITE), STONE})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.STONY_SHORE, MYTHICA_STONY_SHORE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.GRAVEL, (double)-0.05, (double)0.05), (SurfaceRules.RuleSource)gravelOrStoneCeiling), STONE})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WINDSWEPT_HILLS, MYTHICA_WINDSWEPT_HILLS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)MythicaSurfaceRuleData.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)STONE)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSandyShoreOrOcean, (SurfaceRules.RuleSource)sandOrSandstoneCeiling), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isDesert, (SurfaceRules.RuleSource)sandOrSandstoneCeiling), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.DRIPSTONE_CAVES, MYTHICA_DRIPSTONE_CAVES}), (SurfaceRules.RuleSource)STONE)});
        SurfaceRules.RuleSource powderedSnowSmallPatches = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.POWDER_SNOW, (double)0.45, (double)0.58), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)POWDER_SNOW));
        SurfaceRules.RuleSource powderedSnowLargePatches = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.POWDER_SNOW, (double)0.35, (double)0.6), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)POWDER_SNOW));
        SurfaceRules.RuleSource underFloorSurfaceRules = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.FROZEN_PEAKS, MYTHICA_FROZEN_PEAKS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSteep, (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.PACKED_ICE, (double)-0.5, (double)0.2), (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.ICE, (double)-0.0625, (double)0.025), (SurfaceRules.RuleSource)ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)SNOW_BLOCK)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.SNOWY_SLOPES, MYTHICA_SNOWY_SLOPES}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSteep, (SurfaceRules.RuleSource)STONE), powderedSnowSmallPatches, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)SNOW_BLOCK)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.JAGGED_PEAKS, MYTHICA_JAGGED_PEAKS}), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.GROVE, MYTHICA_GROVE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{powderedSnowSmallPatches, DIRT})), onAndUnderFloorSurfaceRules, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WINDSWEPT_SAVANNA}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)MythicaSurfaceRuleData.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)STONE)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WINDSWEPT_GRAVELLY_HILLS, MYTHICA_WINDSWEPT_GRAVELLY_HILLS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)MythicaSurfaceRuleData.surfaceNoiseAbove(2.0), (SurfaceRules.RuleSource)gravelOrStoneCeiling), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)MythicaSurfaceRuleData.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)MythicaSurfaceRuleData.surfaceNoiseAbove(-1.0), (SurfaceRules.RuleSource)DIRT), gravelOrStoneCeiling})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.MANGROVE_SWAMP, MYTHICA_MANGROVE_SWAMP}), (SurfaceRules.RuleSource)MUD), DIRT});
        SurfaceRules.RuleSource shallowFloorSurfaceRules = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.FROZEN_PEAKS, MYTHICA_FROZEN_PEAKS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSteep, (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.PACKED_ICE, (double)0.0, (double)0.2), (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.ICE, (double)0.0, (double)0.025), (SurfaceRules.RuleSource)ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)SNOW_BLOCK)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.SNOWY_SLOPES, MYTHICA_SNOWY_SLOPES}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSteep, (SurfaceRules.RuleSource)STONE), powderedSnowLargePatches, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)SNOW_BLOCK)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.JAGGED_PEAKS, MYTHICA_JAGGED_PEAKS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSteep, (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)SNOW_BLOCK)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.GROVE, MYTHICA_GROVE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{powderedSnowLargePatches, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)SNOW_BLOCK)})), onAndUnderFloorSurfaceRules, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WINDSWEPT_SAVANNA, MYTHICA_WINDSWEPT_SAVANNA}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)MythicaSurfaceRuleData.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)MythicaSurfaceRuleData.surfaceNoiseAbove(-0.5), (SurfaceRules.RuleSource)COARSE_DIRT)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WINDSWEPT_GRAVELLY_HILLS, MYTHICA_WINDSWEPT_GRAVELLY_HILLS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)MythicaSurfaceRuleData.surfaceNoiseAbove(2.0), (SurfaceRules.RuleSource)gravelOrStoneCeiling), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)MythicaSurfaceRuleData.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)MythicaSurfaceRuleData.surfaceNoiseAbove(-1.0), (SurfaceRules.RuleSource)surfaceGrassOrDirtIfSubmerged), gravelOrStoneCeiling})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, MYTHICA_OLD_GROWTH_PINE_TAIGA, MYTHICA_OLD_GROWTH_SPRUCE_TAIGA}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)MythicaSurfaceRuleData.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)MythicaSurfaceRuleData.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)PODZOL)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.ICE_SPIKES, MYTHICA_ICE_SPIKES}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)SNOW_BLOCK)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.MANGROVE_SWAMP, MYTHICA_MANGROVE_SWAMP}), (SurfaceRules.RuleSource)MUD), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.MUSHROOM_FIELDS, MYTHICA_MUSHROOM_FIELDS}), (SurfaceRules.RuleSource)MYCELIUM), surfaceGrassOrDirtIfSubmerged});
        SurfaceRules.ConditionSource isSuitableSurfaceNoiseLower = SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-0.909, (double)-0.5454);
        SurfaceRules.ConditionSource isSuitableSurfaceNoiseMid = SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-0.1818, (double)0.1818);
        SurfaceRules.ConditionSource isSuitableSurfaceNoiseUpper = SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)0.5454, (double)0.909);
        SurfaceRules.RuleSource surfaceRules = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WOODED_BADLANDS, MYTHICA_WOODED_BADLANDS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isBlockAboveY97WithVariationAbove, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSuitableSurfaceNoiseLower, (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSuitableSurfaceNoiseMid, (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSuitableSurfaceNoiseUpper, (SurfaceRules.RuleSource)COARSE_DIRT), surfaceGrassOrDirtIfSubmerged}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.SWAMP, MYTHICA_SWAMP}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isBlockAboveY62, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)isBlockAboveY63), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER)))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.MANGROVE_SWAMP, MYTHICA_MANGROVE_SWAMP}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isBlockAboveY60, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)isBlockAboveY63), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER))))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.WOODED_BADLANDS, MYTHICA_BADLANDS, MYTHICA_ERODED_BADLANDS, MYTHICA_WOODED_BADLANDS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isBlockAboveY256, (SurfaceRules.RuleSource)ORANGE_TERRACOTTA), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSurfaceAboveY74WithVariationAbove, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSuitableSurfaceNoiseLower, (SurfaceRules.RuleSource)TERRACOTTA), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSuitableSurfaceNoiseMid, (SurfaceRules.RuleSource)TERRACOTTA), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSuitableSurfaceNoiseUpper, (SurfaceRules.RuleSource)TERRACOTTA), SurfaceRules.bandlands()})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isInOrAboveShallowWater, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)RED_SANDSTONE), RED_SAND})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)isHole), (SurfaceRules.RuleSource)ORANGE_TERRACOTTA), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isInOrAboveDeepWaterWithVariationBelow, (SurfaceRules.RuleSource)WHITE_TERRACOTTA), gravelOrStoneCeiling})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSurfaceAbove63WithVariationBelow, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isBlockAboveY63, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)isSurfaceAboveY74WithVariationAbove), (SurfaceRules.RuleSource)ORANGE_TERRACOTTA)), SurfaceRules.bandlands()})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isInOrAboveDeepWaterWithVariationBelow, (SurfaceRules.RuleSource)WHITE_TERRACOTTA))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isInOrAboveShallowWater, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isFrozenOcean, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isHole, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)AIR), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.temperature(), (SurfaceRules.RuleSource)ICE), WATER}))), shallowFloorSurfaceRules}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isInOrAboveDeepWaterWithVariationBelow, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isFrozenOcean, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isHole, (SurfaceRules.RuleSource)WATER))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)underFloorSurfaceRules), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSandyShoreOrOcean, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.DEEP_UNDER_FLOOR, (SurfaceRules.RuleSource)SANDSTONE)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isDesert, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.VERY_DEEP_UNDER_FLOOR, (SurfaceRules.RuleSource)SANDSTONE))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, MYTHICA_FROZEN_PEAKS, MYTHICA_JAGGED_PEAKS}), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, MYTHICA_WARM_OCEAN, MYTHICA_LUKEWARM_OCEAN, MYTHICA_DEEP_LUKEWARM_OCEAN}), (SurfaceRules.RuleSource)sandOrSandstoneCeiling), gravelOrStoneCeiling}))});
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)SurfaceRuleManager.getDefaultSurfaceRuleAdditionsForStage((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (SurfaceRuleManager.RuleStage)SurfaceRuleManager.RuleStage.BEFORE_BEDROCK));
        builder.add((Object)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        List afterBedrockRules = SurfaceRuleManager.getDefaultSurfaceRuleAdditionsForStage((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (SurfaceRuleManager.RuleStage)SurfaceRuleManager.RuleStage.AFTER_BEDROCK);
        if (!afterBedrockRules.isEmpty()) {
            ImmutableList.Builder newSurfaceRules = ImmutableList.builder();
            newSurfaceRules.addAll((Iterable)afterBedrockRules);
            newSurfaceRules.add((Object)surfaceRules);
            surfaceRules = SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])newSurfaceRules.build().toArray(SurfaceRules.RuleSource[]::new)));
        }
        SurfaceRules.RuleSource surfaceRulesWithPreliminarySurfaceCheck = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)surfaceRules);
        builder.add((Object)surfaceRulesWithPreliminarySurfaceCheck);
        builder.add((Object)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"deepslate", (VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)8)), (SurfaceRules.RuleSource)DEEPSLATE));
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(double value) {
        return SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)(value / 8.25), (double)Double.MAX_VALUE);
    }

    public static SurfaceRules.RuleSource getMythicaNamespacedRules(SurfaceRuleManager.RuleCategory category, SurfaceRules.RuleSource fallback) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"mythica", (Object)SurfaceRuleManager.getDefaultSurfaceRules((SurfaceRuleManager.RuleCategory)category));
        builder.putAll(SurfaceRuleManagerAccessor.getSurfaceRules().get(category));
        return new NamespacedSurfaceRuleSource(fallback, (Map)builder.build());
    }

    static {
        MYTHICA_BEACH = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"beach"));
        MYTHICA_DEEP_FROZEN_OCEAN = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"deep_frozen_ocean"));
        MYTHICA_DEEP_LUKEWARM_OCEAN = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"deep_lukewarm_ocean"));
        MYTHICA_DRIPSTONE_CAVES = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"dripstone_caves"));
        MYTHICA_FROZEN_OCEAN = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"frozen_ocean"));
        MYTHICA_LUKEWARM_OCEAN = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"lukewarm_ocean"));
        MYTHICA_SNOWY_BEACH = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"snowy_beach"));
        MYTHICA_STONY_SHORE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"stony_shore"));
        MYTHICA_WARM_OCEAN = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"warm_ocean"));
        MYTHICA_DESERT = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"desert"));
        MYTHICA_STONY_PEAKS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"stony_peaks"));
        MYTHICA_WINDSWEPT_HILLS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"windswept_hills"));
        MYTHICA_FROZEN_PEAKS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"frozen_peaks"));
        MYTHICA_JAGGED_PEAKS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"jagged_peaks"));
        MYTHICA_GROVE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"grove"));
        MYTHICA_WINDSWEPT_GRAVELLY_HILLS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"windswept_gravelly_hills"));
        MYTHICA_MANGROVE_SWAMP = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"mangrove_swamp"));
        MYTHICA_SNOWY_SLOPES = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"snowy_slopes"));
        MYTHICA_OLD_GROWTH_PINE_TAIGA = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"old_growth_pine_taiga"));
        MYTHICA_OLD_GROWTH_SPRUCE_TAIGA = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"old_growth_spruce_taiga"));
        MYTHICA_ICE_SPIKES = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"ice_spikes"));
        MYTHICA_MUSHROOM_FIELDS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"mushroom_fields"));
        MYTHICA_WOODED_BADLANDS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"wooded_badlands"));
        MYTHICA_BADLANDS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"badlands"));
        MYTHICA_ERODED_BADLANDS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"eroded_badlands"));
        MYTHICA_SWAMP = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"swamp"));
        MYTHICA_WINDSWEPT_SAVANNA = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"windswept_savanna"));
        AIR = MythicaSurfaceRuleData.makeStateRule(Blocks.AIR);
        BEDROCK = MythicaSurfaceRuleData.makeStateRule(Blocks.BEDROCK);
        WHITE_TERRACOTTA = MythicaSurfaceRuleData.makeStateRule(Blocks.WHITE_TERRACOTTA);
        ORANGE_TERRACOTTA = MythicaSurfaceRuleData.makeStateRule(Blocks.ORANGE_TERRACOTTA);
        TERRACOTTA = MythicaSurfaceRuleData.makeStateRule(Blocks.TERRACOTTA);
        RED_SAND = MythicaSurfaceRuleData.makeStateRule(Blocks.RED_SAND);
        RED_SANDSTONE = MythicaSurfaceRuleData.makeStateRule(Blocks.RED_SANDSTONE);
        STONE = MythicaSurfaceRuleData.makeStateRule(Blocks.STONE);
        DEEPSLATE = MythicaSurfaceRuleData.makeStateRule(Blocks.DEEPSLATE);
        DIRT = MythicaSurfaceRuleData.makeStateRule(Blocks.DIRT);
        PODZOL = MythicaSurfaceRuleData.makeStateRule(Blocks.PODZOL);
        COARSE_DIRT = MythicaSurfaceRuleData.makeStateRule(Blocks.COARSE_DIRT);
        MYCELIUM = MythicaSurfaceRuleData.makeStateRule(Blocks.MYCELIUM);
        GRASS_BLOCK = MythicaSurfaceRuleData.makeStateRule(Blocks.GRASS_BLOCK);
        CALCITE = MythicaSurfaceRuleData.makeStateRule(Blocks.CALCITE);
        GRAVEL = MythicaSurfaceRuleData.makeStateRule(Blocks.GRAVEL);
        SAND = MythicaSurfaceRuleData.makeStateRule(Blocks.SAND);
        SANDSTONE = MythicaSurfaceRuleData.makeStateRule(Blocks.SANDSTONE);
        PACKED_ICE = MythicaSurfaceRuleData.makeStateRule(Blocks.PACKED_ICE);
        SNOW_BLOCK = MythicaSurfaceRuleData.makeStateRule(Blocks.SNOW_BLOCK);
        MUD = MythicaSurfaceRuleData.makeStateRule(Blocks.MUD);
        POWDER_SNOW = MythicaSurfaceRuleData.makeStateRule(Blocks.POWDER_SNOW);
        ICE = MythicaSurfaceRuleData.makeStateRule(Blocks.ICE);
        WATER = MythicaSurfaceRuleData.makeStateRule(Blocks.WATER);
    }
}

