/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.mythica.mixin.terrablender;

import java.util.List;
import medi.makiba.mythica.MythicaConfig;
import medi.makiba.mythica.compat.terrablender.CopiedRegion;
import medi.makiba.mythica.compat.terrablender.DefaultMythicaRegion;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.worldgen.DefaultOverworldRegion;

@Mixin(value={Regions.class}, remap=false)
public abstract class RegionsMixin {
    @Inject(at={@At(value="HEAD")}, method={"register(Lnet/minecraft/resources/ResourceLocation;Lterrablender/api/Region;)V"}, cancellable=true)
    private static void copyOverworldRegionToMythica(ResourceLocation name, Region region, CallbackInfo ci) {
        MythicaConfig.ModdedBiomeCopyModes copyMode = (MythicaConfig.ModdedBiomeCopyModes)((Object)MythicaConfig.MODDED_BIOME_COPY_MODE.get());
        if (region.getType() == RegionType.OVERWORLD && !(region instanceof DefaultOverworldRegion) && copyMode != MythicaConfig.ModdedBiomeCopyModes.NO_COPY && !((List)MythicaConfig.MOD_BLACKLIST.get()).contains(name.getNamespace())) {
            CopiedRegion copyRegion = new CopiedRegion(region, name, region.getWeight());
            Regions.register((Region)copyRegion);
            if (copyMode == MythicaConfig.ModdedBiomeCopyModes.COPY_REMOVE) {
                ci.cancel();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"register(Lnet/minecraft/resources/ResourceLocation;ILterrablender/api/Region;)V"}, cancellable=true)
    private static void copyOverworldRegionToMythicaWithIndex(ResourceLocation name, int index, Region region, CallbackInfo ci) {
        MythicaConfig.ModdedBiomeCopyModes copyMode = (MythicaConfig.ModdedBiomeCopyModes)((Object)MythicaConfig.MODDED_BIOME_COPY_MODE.get());
        if (region.getType() == RegionType.OVERWORLD && copyMode != MythicaConfig.ModdedBiomeCopyModes.NO_COPY && !((List)MythicaConfig.MOD_BLACKLIST.get()).contains(name.getNamespace())) {
            CopiedRegion copyRegion = new CopiedRegion(region, name, region.getWeight());
            Regions.register((Region)copyRegion);
            if (copyMode == MythicaConfig.ModdedBiomeCopyModes.COPY_REMOVE) {
                ci.cancel();
            }
        }
    }

    static {
        Regions.register((Region)new DefaultMythicaRegion((Integer)MythicaConfig.VANILLA_REGION_WEIGHT.get()));
    }
}

