/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.mythica.mixin;

import java.util.List;
import java.util.Set;
import medi.makiba.mythica.Mythica;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    private static final String TERRABLENDER_ID = "terrablender";
    private String ownPackage;
    private boolean terraBlenderInstalled;

    public void onLoad(String mixinPackage) {
        this.ownPackage = mixinPackage;
        this.terraBlenderInstalled = MixinPlugin.isModLoaded(TERRABLENDER_ID);
        if (this.terraBlenderInstalled) {
            Mythica.LOGGER.info("Terrablender detected, enabling compatibility mixins.");
        }
    }

    private static Boolean isModLoaded(String modid) {
        return ModList.get() != null ? ModList.get().isLoaded(modid) : LoadingModList.get().getModFileById(modid) != null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String mixinShortName = mixinClassName.substring(this.ownPackage.length() + 1);
        if (mixinShortName.startsWith(TERRABLENDER_ID)) {
            return this.terraBlenderInstalled;
        }
        return true;
    }

    public String getRefMapperConfig() {
        return null;
    }

    public List<String> getMixins() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

