/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.mythica.event;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import medi.makiba.mythica.Client.Particle.MythicaPortalParticle;
import medi.makiba.mythica.block.portal.MythicaPortalVisuals;
import medi.makiba.mythica.registry.MythicaBlocks;
import medi.makiba.mythica.registry.MythicaItems;
import medi.makiba.mythica.registry.MythicaParticleTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

@EventBusSubscriber(modid="mythica", value={Dist.CLIENT})
public class ModClientEvents {
    @SubscribeEvent
    private static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)MythicaParticleTypes.MYTHICA_PORTAL.get(), MythicaPortalParticle.Provider::new);
    }

    @SubscribeEvent
    private static void mythicaPortalFOV(ComputeFovModifierEvent event) {
        if (MythicaPortalVisuals.getPortalAnimTime() > 0.0f) {
            event.setNewFovModifier(event.getFovModifier() - MythicaPortalVisuals.getPortalAnimTime());
        }
    }

    @SubscribeEvent
    private static void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)"mythica_portal_overlay"), (guiGraphics, deltaTracker) -> {
            Minecraft minecraft = Minecraft.getInstance();
            Window window = minecraft.getWindow();
            LocalPlayer player = minecraft.player;
            if (player != null) {
                ModClientEvents.renderPortalOverlay(guiGraphics, minecraft, window, deltaTracker.getGameTimeDeltaPartialTick(true));
            }
        });
    }

    private static void renderPortalOverlay(GuiGraphics graphics, Minecraft minecraft, Window window, float partialTicks) {
        float alpha = Mth.lerp((float)partialTicks, (float)MythicaPortalVisuals.getPrevPortalAnimTime(), (float)MythicaPortalVisuals.getPortalAnimTime());
        if (alpha > 0.0f) {
            if (alpha < 1.0f) {
                alpha *= alpha;
                alpha *= alpha;
                alpha = alpha * 0.8f + 0.2f;
            }
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
            TextureAtlasSprite textureatlassprite = minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(((Block)MythicaBlocks.MYTHICA_PORTAL.get()).defaultBlockState());
            graphics.blit(0, 0, -90, window.getGuiScaledWidth(), window.getGuiScaledHeight(), textureatlassprite);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    private static void addItemToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept((ItemLike)MythicaItems.MYTHIC_DUST.get());
        }
    }
}

