/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.mythica.compat.terrablender;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import medi.makiba.mythica.Mythica;
import medi.makiba.mythica.MythicaConfig;
import medi.makiba.mythica.compat.terrablender.MythicaRegionType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.Region;

public class CopiedRegion
extends Region {
    Region originalRegion;

    public CopiedRegion(Region originalRegion, ResourceLocation location, int weight) {
        super(ResourceLocation.fromNamespaceAndPath((String)"mythica", (String)(location.getNamespace() + "_" + location.getPath())), MythicaRegionType.MYTHICA, weight);
        this.originalRegion = originalRegion;
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        Consumer<Pair> mapperFilter = pair -> {
            Climate.ParameterPoint point = (Climate.ParameterPoint)pair.getFirst();
            ResourceKey biomeKey = (ResourceKey)pair.getSecond();
            if (((List)MythicaConfig.BIOME_BLACKLIST.get()).contains(biomeKey.location().toString())) {
                Mythica.LOGGER.debug("Filtered out Biome {} from being copied to Mythica", (Object)biomeKey.location());
                biomeKey = Region.DEFERRED_PLACEHOLDER;
            }
            mapper.accept(Pair.of((Object)point, (Object)biomeKey));
        };
        this.originalRegion.addBiomes(registry, mapperFilter);
    }
}

