/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.mythica.mixin.terrablender;

import java.util.List;
import java.util.Map;
import medi.makiba.mythica.MythicaConfig;
import medi.makiba.mythica.compat.terrablender.MythicaRuleCategory;
import medi.makiba.mythica.compat.terrablender.MythicaSurfaceRuleData;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import terrablender.api.SurfaceRuleManager;

@Mixin(value={SurfaceRuleManager.class}, remap=false)
public class SurfaceRuleManagerMixin {
    @Shadow
    private static Map<SurfaceRuleManager.RuleCategory, SurfaceRules.RuleSource> defaultSurfaceRules;
    @Shadow
    private static Map<SurfaceRuleManager.RuleCategory, Map<String, SurfaceRules.RuleSource>> surfaceRules;

    @Inject(method={"getDefaultSurfaceRules"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getDefaultSurfaceRules(SurfaceRuleManager.RuleCategory category, CallbackInfoReturnable<SurfaceRules.RuleSource> cir) {
        if (defaultSurfaceRules.containsKey(category)) {
            cir.setReturnValue((Object)defaultSurfaceRules.get(category));
        } else if (category == MythicaRuleCategory.MYTHICA) {
            cir.setReturnValue((Object)MythicaSurfaceRuleData.mythica());
        }
    }

    @Inject(method={"addSurfaceRules"}, at={@At(value="TAIL")})
    private static void addSurfaceRulesToMythica(SurfaceRuleManager.RuleCategory category, String namespace, SurfaceRules.RuleSource rules, CallbackInfo ci) {
        if (category != SurfaceRuleManager.RuleCategory.OVERWORLD || ((List)MythicaConfig.MOD_BLACKLIST.get()).contains(namespace)) {
            return;
        }
        surfaceRules.get(MythicaRuleCategory.MYTHICA).put(namespace, rules);
    }

    @Inject(method={"removeSurfaceRules"}, at={@At(value="TAIL")})
    private static void removeSurfaceRulesToMythica(SurfaceRuleManager.RuleCategory category, String namespace, CallbackInfo ci) {
        if (category != SurfaceRuleManager.RuleCategory.OVERWORLD || ((List)MythicaConfig.MOD_BLACKLIST.get()).contains(namespace)) {
            return;
        }
        surfaceRules.get(MythicaRuleCategory.MYTHICA).remove(namespace);
    }
}

