/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.nio.file.Path;
import java.time.Duration;
import org.slf4j.Logger;
import org.texboobcat.downAuth.api.DownAuthProvider;
import org.texboobcat.downAuth.config.ConfigLoader;
import org.texboobcat.downAuth.config.PluginConfig;
import org.texboobcat.downAuth.events.MojangServiceStatusChangeEvent;
import org.texboobcat.downAuth.geo.HttpGeoService;
import org.texboobcat.downAuth.listener.AuthEventListener;
import org.texboobcat.downAuth.monitor.MojangServiceMonitor;
import org.texboobcat.downAuth.pin.PinService;
import org.texboobcat.downAuth.security.SecurityPolicy;
import org.texboobcat.downAuth.security.SecurityValidator;
import org.texboobcat.downAuth.session.SessionCache;
import org.texboobcat.downAuth.session.SessionCacheImpl;
import org.texboobcat.downAuth.session.storage.JsonSessionStorage;
import org.texboobcat.downAuth.util.AuditLogger;
import org.texboobcat.downAuth.util.MessageUtil;
import org.texboobcat.downAuth.web.AuthApi;

@Plugin(id="downauth", name="DownAuth", version="1.0-SNAPSHOT")
public class DownAuth {
    @Inject
    private Logger logger;
    @Inject
    private ProxyServer proxy;
    @Inject
    @DataDirectory
    private Path dataDirectory;
    private PluginConfig config;
    private SessionCache sessionCache;
    private SecurityValidator securityValidator;
    private SecurityPolicy securityPolicy;
    private MojangServiceMonitor serviceMonitor;
    private ScheduledTask healthTask;
    private AuthApi api;
    private boolean lastAdvertisedAvailable;
    private AuditLogger auditLogger;
    private PinService pinService;

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        try {
            this.config = ConfigLoader.loadOrCreate(this.dataDirectory);
        }
        catch (Exception e) {
            this.logger.error("Failed to load config.yml", (Throwable)e);
            this.config = new PluginConfig();
        }
        try {
            JsonSessionStorage storage = new JsonSessionStorage(this.logger, this.dataDirectory);
            this.sessionCache = new SessionCacheImpl(storage);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize session storage", e);
        }
        this.securityPolicy = new SecurityPolicy(this.config);
        this.securityValidator = new SecurityValidator();
        this.serviceMonitor = new MojangServiceMonitor(this.logger, this.config.monitoring.failureThreshold, this.config.authentication.mojangTimeout);
        this.serviceMonitor.runHealthCheck();
        this.lastAdvertisedAvailable = this.serviceMonitor.isAvailable();
        int interval = Math.max(5, this.config.monitoring.healthCheckIntervalSeconds);
        this.healthTask = this.proxy.getScheduler().buildTask((Object)this, () -> {
            boolean before = this.lastAdvertisedAvailable;
            this.serviceMonitor.runHealthCheck();
            boolean now = this.serviceMonitor.isAvailable();
            if (now != before) {
                this.lastAdvertisedAvailable = now;
                this.proxy.getEventManager().fire((Object)new MojangServiceStatusChangeEvent(now, System.currentTimeMillis()));
                this.logger.info("Mojang service availability changed: {}", (Object)(now ? "UP" : "DOWN"));
            }
        }).repeat(Duration.ofSeconds(interval)).schedule();
        if (this.config.sessionCache.cleanupOnStartup) {
            long maxAgeMillis = (long)this.config.sessionCache.maxSessionAgeHours * 3600000L;
            this.sessionCache.cleanExpiredSessions(maxAgeMillis);
        }
        this.api = new AuthApi(this.sessionCache, this.serviceMonitor);
        DownAuthProvider.register(this.api);
        this.auditLogger = this.config.monitoring.enableAuditLog ? new AuditLogger(this.dataDirectory.resolve("audit.log")) : null;
        HttpGeoService geo = new HttpGeoService(this.logger, this.config.monitoring.geoLookupTimeoutMillis, this.config.monitoring.geoProviderUrl, this.config.monitoring.geoCacheTtlSeconds);
        this.pinService = new PinService(this.logger, this.proxy, this.sessionCache, this.config, this.auditLogger, this);
        this.proxy.getEventManager().register((Object)this, (Object)new AuthEventListener(this.logger, this.proxy, this.config, this.sessionCache, this.securityValidator, this.securityPolicy, this.serviceMonitor, this.api, this.auditLogger, geo, this.pinService));
        CommandManager cm = this.proxy.getCommandManager();
        CommandMeta pinMeta = cm.metaBuilder("pin").build();
        cm.register(pinMeta, (Command)((SimpleCommand)invocation -> {
            if (!(invocation.source() instanceof Player)) {
                return;
            }
            Player player = (Player)invocation.source();
            String[] args = (String[])invocation.arguments();
            if (this.pinService.isPending(player.getUniqueId())) {
                if (args.length < 1) {
                    player.sendMessage(MessageUtil.colorize(this.config.messages.pinPrompt.replace("%timeout%", String.valueOf(Math.max(5, this.config.security.pinTimeoutSeconds)))));
                    return;
                }
                boolean ok = this.pinService.tryVerify(player.getUniqueId(), args[0]);
                player.sendMessage(MessageUtil.colorize(ok ? this.config.messages.pinSuccess : this.config.messages.pinFailure));
                if (ok) return;
            }
            if (args.length >= 1) {
                boolean ok = this.pinService.setPin(player, args[0]);
                player.sendMessage(MessageUtil.colorize(ok ? "&aPIN set." : "&cInvalid PIN."));
                return;
            } else {
                player.sendMessage(MessageUtil.colorize("&eUsage: /pin <code>"));
            }
        }));
        CommandMeta setPinMeta = cm.metaBuilder("setpin").build();
        cm.register(setPinMeta, (Command)((SimpleCommand)invocation -> {
            if (!(invocation.source() instanceof Player)) {
                return;
            }
            Player player = (Player)invocation.source();
            String[] args = (String[])invocation.arguments();
            if (args.length < 1) {
                player.sendMessage(MessageUtil.colorize("&eUsage: /setpin <code>"));
                return;
            }
            boolean ok = this.pinService.setPin(player, args[0]);
            player.sendMessage(MessageUtil.colorize(ok ? "&aPIN set." : "&cInvalid PIN."));
        }));
        CommandMeta resetPinMeta = cm.metaBuilder("resetpin").build();
        cm.register(resetPinMeta, (Command)((SimpleCommand)invocation -> {
            if (!(invocation.source() instanceof Player)) {
                return;
            }
            Player player = (Player)invocation.source();
            if (!this.serviceMonitor.shouldAttemptMojangAuth()) {
                player.sendMessage(MessageUtil.colorize(this.config.messages.pinResetOnlyOnline));
                return;
            }
            boolean ok = this.pinService.clearPin(player);
            player.sendMessage(MessageUtil.colorize(ok ? this.config.messages.pinResetSuccess : "&cNo PIN to clear."));
        }));
        this.logger.info("DownAuth initialized. Fallback enabled: {}", (Object)this.config.authentication.enableFallback);
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        if (this.healthTask != null) {
            try {
                this.healthTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

