/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.texboobcat.downAuth.config.PluginConfig;
import org.yaml.snakeyaml.Yaml;

public final class ConfigLoader {
    private ConfigLoader() {
    }

    public static PluginConfig loadOrCreate(Path dataDir) throws IOException {
        Path configPath;
        if (!Files.exists(dataDir, new LinkOption[0])) {
            Files.createDirectories(dataDir, new FileAttribute[0]);
        }
        if (!Files.exists(configPath = dataDir.resolve("config.yml"), new LinkOption[0])) {
            ConfigLoader.writeDefaultConfig(configPath);
        }
        return ConfigLoader.load(configPath);
    }

    public static PluginConfig load(Path path) throws IOException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            Object o = yaml.load(in);
            Map root = o instanceof Map ? (Map)o : new HashMap();
            PluginConfig pluginConfig = ConfigLoader.fromMap(root);
            return pluginConfig;
        }
    }

    private static void writeDefaultConfig(Path path) throws IOException {
        String defaultYaml = "# Authentication Fallback Plugin Configuration\nsession-cache:\n  # How long cached sessions remain valid (hours)\n  max-session-age: 72\n  # Storage backend: JSON, SQLITE, MYSQL, REDIS\n  storage-type: \"JSON\"\n  # Require IP match for cached session validation\n  strict-ip-check: true\n  # Allow IP changes if same network range\n  allow-ip-range-match: true\n  # Range prefixes used when allow-ip-range-match is true\n  ipv4-range-prefix: 24\n  ipv6-range-prefix: 64\n  # Clean expired sessions on startup\n  cleanup-on-startup: true\n  # Database settings (for SQLITE/MYSQL/REDIS)\n  database:\n    host: \"localhost\"\n    port: 3306\n    database: \"minecraft_sessions\"\n    username: \"minecraft\"\n    password: \"secure_password\"\nsecurity:\n  min-login-history: 3\n  max-failed-attempts: 10\n  failure-ban-duration: 30\n  require-recent-activity: true\n  recent-activity-days: 30\n  alert-on-fallback: true\n  enable-geo-checks: true\n  alert-on-geo-change: true\n  deny-on-geo-change: false\n  require-pin-on-fallback: false\n  pin-timeout-seconds: 60\n  pin-min-length: 6\n  max-failed-attempts-per-subnet: 30\n  max-failed-attempts-per-asn: 100\n  blocked-asns: []\n  require-mojang-auth: []\nmonitoring:\n  health-check-interval: 30\n  failure-threshold: 3\n  enable-statistics: true\n  enable-metrics: true\n  enable-audit-log: true\n  geo-lookup-timeout: 2000\n  geo-provider-url: \"https://ipwho.is/{ip}?fields=ip,country_code,connection\"\n  geo-cache-ttl: 300\nmessages:\n  fallback-auth-active: \"&eAuthentication servers are down. Using cached session.\"\n  fallback-auth-failed: \"&cCannot authenticate: No cached session found.\"\n  session-expired: \"&cYour session has expired. Please try again when auth servers are online.\"\n  mojang-down-notice: \"&7Mojang authentication servers appear to be down.\"\n  pin-prompt: \"&ePlease verify your identity: use &6/pin <code>&e within &6%timeout%s\"\n  pin-success: \"&aVerification successful.\"\n  pin-failure: \"&cIncorrect PIN.\"\n  geo-denied: \"&cConnection denied due to location or network change. Please try again later.\"\n";
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);
             BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));){
            w.write(defaultYaml);
        }
    }

    private static PluginConfig fromMap(Map<String, Object> root) {
        List<Object> forced;
        PluginConfig cfg = new PluginConfig();
        Map<String, Object> auth = ConfigLoader.child(root, "authentication");
        cfg.authentication.enableFallback = ConfigLoader.getBool(auth, "enable-fallback", cfg.authentication.enableFallback);
        cfg.authentication.mojangTimeout = ConfigLoader.getInt(auth, "mojang-timeout", cfg.authentication.mojangTimeout);
        cfg.authentication.mojangRetries = ConfigLoader.getInt(auth, "mojang-retries", cfg.authentication.mojangRetries);
        cfg.authentication.retryDelay = ConfigLoader.getInt(auth, "retry-delay", cfg.authentication.retryDelay);
        Map<String, Object> sc = ConfigLoader.child(root, "session-cache");
        cfg.sessionCache.maxSessionAgeHours = ConfigLoader.getInt(sc, "max-session-age", cfg.sessionCache.maxSessionAgeHours);
        cfg.sessionCache.storageType = ConfigLoader.getString(sc, "storage-type", cfg.sessionCache.storageType);
        cfg.sessionCache.strictIpCheck = ConfigLoader.getBool(sc, "strict-ip-check", cfg.sessionCache.strictIpCheck);
        cfg.sessionCache.allowIpRangeMatch = ConfigLoader.getBool(sc, "allow-ip-range-match", cfg.sessionCache.allowIpRangeMatch);
        cfg.sessionCache.cleanupOnStartup = ConfigLoader.getBool(sc, "cleanup-on-startup", cfg.sessionCache.cleanupOnStartup);
        cfg.sessionCache.ipv4RangePrefix = ConfigLoader.getInt(sc, "ipv4-range-prefix", cfg.sessionCache.ipv4RangePrefix);
        cfg.sessionCache.ipv6RangePrefix = ConfigLoader.getInt(sc, "ipv6-range-prefix", cfg.sessionCache.ipv6RangePrefix);
        Map<String, Object> db = ConfigLoader.child(sc, "database");
        cfg.sessionCache.database.host = ConfigLoader.getString(db, "host", cfg.sessionCache.database.host);
        cfg.sessionCache.database.port = ConfigLoader.getInt(db, "port", cfg.sessionCache.database.port);
        cfg.sessionCache.database.database = ConfigLoader.getString(db, "database", cfg.sessionCache.database.database);
        cfg.sessionCache.database.username = ConfigLoader.getString(db, "username", cfg.sessionCache.database.username);
        cfg.sessionCache.database.password = ConfigLoader.getString(db, "password", cfg.sessionCache.database.password);
        Map<String, Object> sec = ConfigLoader.child(root, "security");
        cfg.security.minLoginHistory = ConfigLoader.getInt(sec, "min-login-history", cfg.security.minLoginHistory);
        cfg.security.maxFailedAttempts = ConfigLoader.getInt(sec, "max-failed-attempts", cfg.security.maxFailedAttempts);
        cfg.security.failureBanDurationMinutes = ConfigLoader.getInt(sec, "failure-ban-duration", cfg.security.failureBanDurationMinutes);
        cfg.security.requireRecentActivity = ConfigLoader.getBool(sec, "require-recent-activity", cfg.security.requireRecentActivity);
        cfg.security.recentActivityDays = ConfigLoader.getInt(sec, "recent-activity-days", cfg.security.recentActivityDays);
        cfg.security.alertOnFallback = ConfigLoader.getBool(sec, "alert-on-fallback", cfg.security.alertOnFallback);
        cfg.security.enableGeoChecks = ConfigLoader.getBool(sec, "enable-geo-checks", cfg.security.enableGeoChecks);
        cfg.security.alertOnGeoChange = ConfigLoader.getBool(sec, "alert-on-geo-change", cfg.security.alertOnGeoChange);
        cfg.security.denyOnGeoChange = ConfigLoader.getBool(sec, "deny-on-geo-change", cfg.security.denyOnGeoChange);
        cfg.security.requirePinOnFallback = ConfigLoader.getBool(sec, "require-pin-on-fallback", cfg.security.requirePinOnFallback);
        cfg.security.pinTimeoutSeconds = ConfigLoader.getInt(sec, "pin-timeout-seconds", cfg.security.pinTimeoutSeconds);
        cfg.security.pinMinLength = ConfigLoader.getInt(sec, "pin-min-length", cfg.security.pinMinLength);
        cfg.security.maxFailedAttemptsPerSubnet = ConfigLoader.getInt(sec, "max-failed-attempts-per-subnet", cfg.security.maxFailedAttemptsPerSubnet);
        cfg.security.maxFailedAttemptsPerAsn = ConfigLoader.getInt(sec, "max-failed-attempts-per-asn", cfg.security.maxFailedAttemptsPerAsn);
        List<Object> basn = ConfigLoader.getList(sec, "blocked-asns");
        if (basn != null) {
            cfg.security.blockedAsns.clear();
            for (Object object : basn) {
                if (object == null) continue;
                try {
                    cfg.security.blockedAsns.add(Integer.parseInt(object.toString()));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if ((forced = ConfigLoader.getList(sec, "require-mojang-auth")) != null) {
            cfg.security.requireMojangAuth.clear();
            for (Object o : forced) {
                if (o == null) continue;
                cfg.security.requireMojangAuth.add(Objects.toString(o));
            }
        }
        Map<String, Object> map = ConfigLoader.child(root, "monitoring");
        cfg.monitoring.healthCheckIntervalSeconds = ConfigLoader.getInt(map, "health-check-interval", cfg.monitoring.healthCheckIntervalSeconds);
        cfg.monitoring.failureThreshold = ConfigLoader.getInt(map, "failure-threshold", cfg.monitoring.failureThreshold);
        cfg.monitoring.enableStatistics = ConfigLoader.getBool(map, "enable-statistics", cfg.monitoring.enableStatistics);
        cfg.monitoring.enableMetrics = ConfigLoader.getBool(map, "enable-metrics", cfg.monitoring.enableMetrics);
        cfg.monitoring.enableAuditLog = ConfigLoader.getBool(map, "enable-audit-log", cfg.monitoring.enableAuditLog);
        cfg.monitoring.geoLookupTimeoutMillis = ConfigLoader.getInt(map, "geo-lookup-timeout", cfg.monitoring.geoLookupTimeoutMillis);
        cfg.monitoring.geoProviderUrl = ConfigLoader.getString(map, "geo-provider-url", cfg.monitoring.geoProviderUrl);
        cfg.monitoring.geoCacheTtlSeconds = ConfigLoader.getInt(map, "geo-cache-ttl", cfg.monitoring.geoCacheTtlSeconds);
        Map<String, Object> msg = ConfigLoader.child(root, "messages");
        cfg.messages.fallbackAuthActive = ConfigLoader.getString(msg, "fallback-auth-active", cfg.messages.fallbackAuthActive);
        cfg.messages.fallbackAuthFailed = ConfigLoader.getString(msg, "fallback-auth-failed", cfg.messages.fallbackAuthFailed);
        cfg.messages.sessionExpired = ConfigLoader.getString(msg, "session-expired", cfg.messages.sessionExpired);
        cfg.messages.mojangDownNotice = ConfigLoader.getString(msg, "mojang-down-notice", cfg.messages.mojangDownNotice);
        cfg.messages.pinPrompt = ConfigLoader.getString(msg, "pin-prompt", cfg.messages.pinPrompt);
        cfg.messages.pinSuccess = ConfigLoader.getString(msg, "pin-success", cfg.messages.pinSuccess);
        cfg.messages.pinFailure = ConfigLoader.getString(msg, "pin-failure", cfg.messages.pinFailure);
        cfg.messages.geoDenied = ConfigLoader.getString(msg, "geo-denied", cfg.messages.geoDenied);
        return cfg;
    }

    private static Map<String, Object> child(Map<String, Object> root, String key) {
        Object o = root.get(key);
        if (o instanceof Map) {
            return (Map)o;
        }
        return new HashMap<String, Object>();
    }

    private static boolean getBool(Map<String, Object> map, String key, boolean def) {
        Object v = map.get(key);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            return Boolean.parseBoolean((String)v);
        }
        if (v instanceof Number) {
            return ((Number)v).intValue() != 0;
        }
        return def;
    }

    private static int getInt(Map<String, Object> map, String key, int def) {
        Object v = map.get(key);
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        if (v instanceof String) {
            try {
                return Integer.parseInt((String)v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    private static String getString(Map<String, Object> map, String key, String def) {
        Object v = map.get(key);
        return v == null ? def : v.toString();
    }

    private static List<Object> getList(Map<String, Object> map, String key) {
        Object v = map.get(key);
        if (v instanceof List) {
            return (List)v;
        }
        return null;
    }
}

