/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.config;

import java.util.ArrayList;
import java.util.List;

public class PluginConfig {
    public AuthenticationConfig authentication = new AuthenticationConfig();
    public SessionCacheConfig sessionCache = new SessionCacheConfig();
    public SecurityConfig security = new SecurityConfig();
    public MonitoringConfig monitoring = new MonitoringConfig();
    public MessagesConfig messages = new MessagesConfig();

    public static class AuthenticationConfig {
        public boolean enableFallback = true;
        public int mojangTimeout = 5000;
        public int mojangRetries = 2;
        public int retryDelay = 1000;
    }

    public static class SessionCacheConfig {
        public int maxSessionAgeHours = 72;
        public String storageType = "JSON";
        public boolean strictIpCheck = true;
        public boolean allowIpRangeMatch = true;
        public boolean cleanupOnStartup = true;
        public int ipv4RangePrefix = 24;
        public int ipv6RangePrefix = 64;
        public DatabaseConfig database = new DatabaseConfig();
    }

    public static class SecurityConfig {
        public int minLoginHistory = 3;
        public int maxFailedAttempts = 10;
        public int failureBanDurationMinutes = 30;
        public boolean requireRecentActivity = true;
        public int recentActivityDays = 30;
        public boolean alertOnFallback = true;
        public List<String> requireMojangAuth = new ArrayList<String>();
        public boolean enableGeoChecks = true;
        public boolean alertOnGeoChange = true;
        public boolean denyOnGeoChange = false;
        public boolean requirePinOnFallback = false;
        public int pinTimeoutSeconds = 60;
        public int pinMinLength = 6;
        public List<Integer> blockedAsns = new ArrayList<Integer>();
        public int maxFailedAttemptsPerSubnet = 30;
        public int maxFailedAttemptsPerAsn = 100;
    }

    public static class MonitoringConfig {
        public int healthCheckIntervalSeconds = 30;
        public int failureThreshold = 3;
        public boolean enableStatistics = true;
        public boolean enableMetrics = true;
        public boolean enableAuditLog = true;
        public int geoLookupTimeoutMillis = 2000;
        public String geoProviderUrl = "https://ipwho.is/{ip}?fields=ip,country_code,connection";
        public int geoCacheTtlSeconds = 300;
    }

    public static class MessagesConfig {
        public String fallbackAuthActive = "Authentication servers are down. Using cached session.";
        public String fallbackAuthFailed = "Cannot authenticate: No cached session found.";
        public String sessionExpired = "Your session has expired. Please try again when auth servers are online.";
        public String mojangDownNotice = "Mojang authentication servers appear to be down.";
        public String pinPrompt = "&ePlease verify your identity: use &6/pin <code>&e within &6%timeout%s";
        public String pinSuccess = "&aVerification successful.";
        public String pinFailure = "&cIncorrect PIN.";
        public String geoDenied = "&cConnection denied due to location or network change. Please try again later.";
        public String pinRequiredNotice = "&ePins are required during auth outages. Set your PIN with &6/setpin <code>&e.";
        public String pinResetOnlyOnline = "&cYou can only reset your PIN when auth servers are online.";
        public String pinResetSuccess = "&aYour PIN has been cleared.";
    }

    public static class DatabaseConfig {
        public String host = "localhost";
        public int port = 3306;
        public String database = "minecraft_sessions";
        public String username = "minecraft";
        public String password = "secure_password";
    }
}

