/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.geo;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.texboobcat.downAuth.geo.GeoInfo;
import org.texboobcat.downAuth.geo.GeoService;

public class HttpGeoService
implements GeoService {
    private final Logger logger;
    private final HttpClient client;
    private final int timeoutMillis;
    private final String providerUrlTemplate;
    private final long ttlMillis;
    private final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();

    public HttpGeoService(Logger logger, int timeoutMillis, String providerUrlTemplate, int ttlSeconds) {
        this.logger = logger;
        this.timeoutMillis = timeoutMillis;
        this.providerUrlTemplate = providerUrlTemplate != null ? providerUrlTemplate : "https://ipwho.is/{ip}?fields=ip,country_code,connection";
        this.ttlMillis = (long)Math.max(0, ttlSeconds) * 1000L;
        this.client = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(timeoutMillis)).build();
    }

    @Override
    public GeoInfo lookup(String ip) {
        block11: {
            if (ip == null || ip.isEmpty()) {
                return null;
            }
            long now = System.currentTimeMillis();
            CacheEntry ce = this.cache.get(ip);
            if (ce != null && now < ce.expiry) {
                return ce.info;
            }
            try {
                String url = this.providerUrlTemplate.replace("{ip}", ip);
                URI uri = URI.create(url);
                HttpRequest req = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofMillis(this.timeoutMillis)).GET().build();
                HttpResponse<String> resp = this.client.send(req, HttpResponse.BodyHandlers.ofString());
                if (resp.statusCode() < 200 || resp.statusCode() >= 300) break block11;
                JsonObject obj = JsonParser.parseString((String)resp.body()).getAsJsonObject();
                JsonElement successEl = obj.get("success");
                if (successEl != null && successEl.isJsonPrimitive() && !successEl.getAsBoolean()) {
                    return null;
                }
                String country = obj.has("country_code") && !obj.get("country_code").isJsonNull() ? obj.get("country_code").getAsString() : null;
                Integer asn = null;
                String asName = null;
                if (obj.has("connection") && obj.get("connection").isJsonObject()) {
                    JsonObject con = obj.getAsJsonObject("connection");
                    if (con.has("asn") && !con.get("asn").isJsonNull()) {
                        try {
                            asn = con.get("asn").getAsInt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (con.has("org") && !con.get("org").isJsonNull()) {
                        asName = con.get("org").getAsString();
                    }
                }
                GeoInfo info = new GeoInfo(ip, country, asn, asName);
                if (this.ttlMillis > 0L) {
                    this.cache.put(ip, new CacheEntry(info, now + this.ttlMillis));
                }
                return info;
            }
            catch (Exception e) {
                if (this.logger == null) break block11;
                this.logger.debug("Geo lookup failed for {}: {}", (Object)ip, (Object)e.toString());
            }
        }
        return null;
    }

    private static class CacheEntry {
        final GeoInfo info;
        final long expiry;

        CacheEntry(GeoInfo info, long expiry) {
            this.info = info;
            this.expiry = expiry;
        }
    }
}

