/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.listener;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.util.GameProfile;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import org.texboobcat.downAuth.config.PluginConfig;
import org.texboobcat.downAuth.events.FallbackAuthUsedEvent;
import org.texboobcat.downAuth.geo.GeoInfo;
import org.texboobcat.downAuth.geo.GeoService;
import org.texboobcat.downAuth.model.CachedSession;
import org.texboobcat.downAuth.monitor.MojangServiceMonitor;
import org.texboobcat.downAuth.pin.PinService;
import org.texboobcat.downAuth.security.SecurityCheckResult;
import org.texboobcat.downAuth.security.SecurityPolicy;
import org.texboobcat.downAuth.security.SecurityValidator;
import org.texboobcat.downAuth.session.SessionCache;
import org.texboobcat.downAuth.util.AuditLogger;
import org.texboobcat.downAuth.util.MessageUtil;
import org.texboobcat.downAuth.web.AuthApi;

public class AuthEventListener {
    private final Logger logger;
    private final ProxyServer proxy;
    private final PluginConfig config;
    private final SessionCache sessionCache;
    private final SecurityValidator securityValidator;
    private final SecurityPolicy securityPolicy;
    private final MojangServiceMonitor serviceMonitor;
    private final AuthApi api;
    private final AuditLogger audit;
    private final GeoService geo;
    private final PinService pinService;
    private final ConcurrentMap<InboundConnection, CachedSession> fallbackConnections = new ConcurrentHashMap<InboundConnection, CachedSession>();

    public AuthEventListener(Logger logger, ProxyServer proxy, PluginConfig config, SessionCache sessionCache, SecurityValidator securityValidator, SecurityPolicy securityPolicy, MojangServiceMonitor serviceMonitor, AuthApi api, AuditLogger audit, GeoService geo, PinService pinService) {
        this.logger = logger;
        this.proxy = proxy;
        this.config = config;
        this.sessionCache = sessionCache;
        this.securityValidator = securityValidator;
        this.securityPolicy = securityPolicy;
        this.serviceMonitor = serviceMonitor;
        this.api = api;
        this.audit = audit;
        this.geo = geo;
        this.pinService = pinService;
    }

    @Subscribe
    public void onPreLogin(PreLoginEvent event) {
        GeoInfo info;
        CachedSession session;
        Object gi;
        InboundConnection conn = event.getConnection();
        String username = event.getUsername();
        UUID providedUuid = event.getUniqueId();
        String ip = AuthEventListener.getIp(conn);
        String subnetKey = this.securityValidator.subnetKey(ip, this.securityPolicy);
        Integer asnForRate = null;
        if (this.geo != null && (gi = this.geo.lookup(ip)) != null) {
            asnForRate = ((GeoInfo)gi).getAsnNumber();
        }
        if (this.securityValidator.isRateLimitedExtended(ip, providedUuid, this.securityPolicy, subnetKey, asnForRate)) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)MessageUtil.colorize("&cRate limited. Try later.")));
            return;
        }
        if (this.serviceMonitor.shouldAttemptMojangAuth()) {
            return;
        }
        if (!this.config.authentication.enableFallback) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)MessageUtil.colorize("&cAuth servers down and fallback disabled.")));
            return;
        }
        if (providedUuid != null) {
            for (String forced : this.config.security.requireMojangAuth) {
                try {
                    if (!UUID.fromString(forced).equals(providedUuid)) continue;
                    event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)MessageUtil.colorize("&cAuthentication servers down. Staff account requires online authentication.")));
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        CachedSession cachedSession = session = providedUuid != null ? this.sessionCache.getSession(providedUuid) : this.sessionCache.getSessionByUsername(username);
        if (session == null) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)MessageUtil.colorize(this.config.messages.fallbackAuthFailed)));
            this.securityValidator.recordFailed(ip, providedUuid);
            return;
        }
        SecurityCheckResult check = this.securityValidator.validateCachedSession(session, ip, this.securityPolicy);
        if (!check.isValid()) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)MessageUtil.colorize(this.config.messages.sessionExpired)));
            this.securityValidator.recordFailedExtended(ip, providedUuid, subnetKey, asnForRate);
            return;
        }
        if (this.config.security.enableGeoChecks && this.geo != null && !this.config.security.blockedAsns.isEmpty() && (info = this.geo.lookup(ip)) != null && info.getAsnNumber() != null && this.config.security.blockedAsns.contains(info.getAsnNumber())) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)MessageUtil.colorize("&cConnection denied (network policy).")));
            this.securityValidator.recordFailedExtended(ip, providedUuid, subnetKey, info.getAsnNumber());
            return;
        }
        event.setResult(PreLoginEvent.PreLoginComponentResult.forceOfflineMode());
        this.fallbackConnections.put(conn, session);
        this.api.markUsingFallback(session.getPlayerUuid(), true);
        if (this.audit != null) {
            this.audit.log("PRELOGIN FALLBACK username=" + username + " uuid=" + session.getPlayerUuid() + " ip=" + ip);
        }
        this.logger.info("Fallback auth for {} ({}) due to Mojang unavailability.", (Object)username, (Object)ip);
    }

    @Subscribe
    public void onGameProfileRequest(GameProfileRequestEvent event) {
        if (event.isOnlineMode()) {
            return;
        }
        CachedSession session = (CachedSession)this.fallbackConnections.get(event.getConnection());
        if (session == null) {
            return;
        }
        event.setGameProfile(session.toGameProfile());
    }

    @Subscribe
    public void onPostLogin(PostLoginEvent event) {
        CachedSession fallback;
        boolean usedFallback;
        GeoInfo info;
        Player player = event.getPlayer();
        String ip = AuthEventListener.getIp((InboundConnection)player);
        UUID uuid = player.getUniqueId();
        String username = player.getUsername();
        ArrayList<GameProfile.Property> props = new ArrayList<GameProfile.Property>(player.getGameProfileProperties());
        CachedSession base = this.sessionCache.getSession(uuid);
        if (base == null) {
            base = new CachedSession(uuid, username);
        }
        base.setPropertiesFromGameProfile(props);
        boolean geoChanged = false;
        String prevCountry = base.getCountryCode();
        Integer prevAsn = base.getAsnNumber();
        if (this.config.security.enableGeoChecks && this.geo != null && (info = this.geo.lookup(ip)) != null) {
            String nowCountry = info.getCountryCode();
            Integer nowAsn = info.getAsnNumber();
            if (nowCountry != null && prevCountry != null && !nowCountry.equalsIgnoreCase(prevCountry)) {
                geoChanged = true;
            }
            if (nowAsn != null && prevAsn != null && !nowAsn.equals(prevAsn)) {
                geoChanged = true;
            }
            base.setCountryCode(nowCountry);
            base.setAsnNumber(nowAsn);
            base.setAsName(info.getAsName());
        }
        this.sessionCache.updateSession(uuid, username, ip, base);
        if (this.audit != null) {
            this.audit.log("POSTLOGIN CACHE_UPDATE username=" + username + " uuid=" + uuid + " ip=" + ip);
        }
        this.securityValidator.recordSuccess(ip, uuid);
        if (this.securityPolicy.isRequirePinOnFallback() && (base.getPinHash() == null || base.getPinHash().isEmpty())) {
            player.sendMessage(MessageUtil.colorize(this.config.messages.pinRequiredNotice));
        }
        if (geoChanged) {
            if (this.audit != null) {
                this.audit.log("GEO_CHANGE username=" + username + " uuid=" + uuid + " ip=" + ip + " fromCountry=" + prevCountry + " toCountry=" + base.getCountryCode() + " fromASN=" + prevAsn + " toASN=" + base.getAsnNumber());
            }
            if (this.securityPolicy.isDenyOnGeoChange() && this.api.isUsingFallbackAuth(uuid)) {
                player.disconnect(MessageUtil.colorize(this.config.messages.geoDenied));
                this.api.markUsingFallback(uuid, false);
                return;
            }
            if (this.config.security.alertOnGeoChange) {
                String fromCountry = prevCountry;
                Integer fromAsn = prevAsn;
                String toCountry = base.getCountryCode();
                Integer toAsn = base.getAsnNumber();
                String name = username;
                Component msg = MessageUtil.colorize("&eDownAuth: Geo/ASN change for &6" + name + "&e (" + (fromCountry == null ? "?" : fromCountry) + "->" + (toCountry == null ? "?" : toCountry) + ", ASN " + (Serializable)(fromAsn == null ? "?" : fromAsn) + "->" + (Serializable)(toAsn == null ? "?" : toAsn) + ")");
                this.proxy.getAllPlayers().stream().filter(p -> p.hasPermission("downauth.alert")).forEach(p -> p.sendMessage(msg));
            }
        }
        if ((usedFallback = this.api.isUsingFallbackAuth(uuid)) && this.config.security.alertOnFallback) {
            this.fallbackConnections.entrySet().removeIf(e -> e.getValue() != null && uuid.equals(((CachedSession)e.getValue()).getPlayerUuid()));
            fallback = this.sessionCache.getSession(uuid);
            this.proxy.getEventManager().fire((Object)new FallbackAuthUsedEvent(uuid, username, ip, fallback));
            this.api.notifyFallbackUsed(uuid, username);
            if (this.audit != null) {
                this.audit.log("FALLBACK_USED username=" + username + " uuid=" + uuid + " ip=" + ip);
            }
            this.proxy.getAllPlayers().stream().filter(p -> p.hasPermission("downauth.alert")).forEach(p -> p.sendMessage(MessageUtil.colorize(this.config.messages.fallbackAuthActive)));
        }
        if (usedFallback && this.securityPolicy.isRequirePinOnFallback()) {
            fallback = this.sessionCache.getSession(uuid);
            if (fallback == null || fallback.getPinHash() == null) {
                player.disconnect(MessageUtil.colorize(this.config.messages.pinFailure));
                this.api.markUsingFallback(uuid, false);
                return;
            }
            if (this.pinService != null) {
                this.pinService.requireVerification(player, fallback);
            }
        }
        this.api.markUsingFallback(uuid, false);
    }

    private static String getIp(InboundConnection conn) {
        if (conn == null || conn.getRemoteAddress() == null) {
            return "";
        }
        if (conn.getRemoteAddress() instanceof InetSocketAddress) {
            InetSocketAddress isa = conn.getRemoteAddress();
            return isa.getAddress() != null ? isa.getAddress().getHostAddress() : isa.getHostString();
        }
        return conn.getRemoteAddress().toString();
    }
}

