/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.model;

import com.velocitypowered.api.util.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.texboobcat.downAuth.model.ProfileProperty;

public class CachedSession {
    private UUID playerUuid;
    private String username;
    private String lastKnownIp;
    private long firstAuthTimestamp;
    private long lastAuthTimestamp;
    private long lastSeenTimestamp;
    private int successfulLogins;
    private List<ProfileProperty> properties = new ArrayList<ProfileProperty>();
    private String countryCode;
    private Integer asnNumber;
    private String asName;
    private String pinHash;

    public CachedSession() {
    }

    public CachedSession(UUID playerUuid, String username) {
        long now;
        this.playerUuid = playerUuid;
        this.username = username;
        this.firstAuthTimestamp = now = System.currentTimeMillis();
        this.lastAuthTimestamp = now;
        this.lastSeenTimestamp = now;
    }

    public boolean isValid(long maxAgeMillis) {
        long cutoff = System.currentTimeMillis() - maxAgeMillis;
        return this.lastAuthTimestamp >= cutoff;
    }

    public boolean matchesIp(String ip, boolean strictIpCheck, boolean allowRangeMatch) {
        if (!strictIpCheck) {
            return true;
        }
        if (Objects.equals(this.lastKnownIp, ip)) {
            return true;
        }
        if (allowRangeMatch) {
            return this.isSame24(this.lastKnownIp, ip);
        }
        return false;
    }

    public boolean matchesUsername(String username) {
        return this.username != null && this.username.equalsIgnoreCase(username);
    }

    private boolean isSame24(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        String[] p1 = a.split("\\.");
        String[] p2 = b.split("\\.");
        if (p1.length < 3 || p2.length < 3) {
            return false;
        }
        return p1[0].equals(p2[0]) && p1[1].equals(p2[1]) && p1[2].equals(p2[2]);
    }

    public GameProfile toGameProfile() {
        ArrayList<GameProfile.Property> props = new ArrayList<GameProfile.Property>();
        for (ProfileProperty p : this.properties) {
            props.add(new GameProfile.Property(p.getName(), p.getValue(), p.getSignature()));
        }
        return new GameProfile(this.playerUuid, this.username, props);
    }

    public void incrementSuccessfulLogins() {
        ++this.successfulLogins;
    }

    public void setPropertiesFromGameProfile(List<GameProfile.Property> props) {
        ArrayList<ProfileProperty> list = new ArrayList<ProfileProperty>();
        if (props != null) {
            for (GameProfile.Property p : props) {
                list.add(new ProfileProperty(p.getName(), p.getValue(), p.getSignature()));
            }
        }
        this.properties = list;
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public void setPlayerUuid(UUID playerUuid) {
        this.playerUuid = playerUuid;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getLastKnownIp() {
        return this.lastKnownIp;
    }

    public void setLastKnownIp(String lastKnownIp) {
        this.lastKnownIp = lastKnownIp;
    }

    public long getFirstAuthTimestamp() {
        return this.firstAuthTimestamp;
    }

    public void setFirstAuthTimestamp(long firstAuthTimestamp) {
        this.firstAuthTimestamp = firstAuthTimestamp;
    }

    public long getLastAuthTimestamp() {
        return this.lastAuthTimestamp;
    }

    public void setLastAuthTimestamp(long lastAuthTimestamp) {
        this.lastAuthTimestamp = lastAuthTimestamp;
    }

    public long getLastSeenTimestamp() {
        return this.lastSeenTimestamp;
    }

    public void setLastSeenTimestamp(long lastSeenTimestamp) {
        this.lastSeenTimestamp = lastSeenTimestamp;
    }

    public int getSuccessfulLogins() {
        return this.successfulLogins;
    }

    public void setSuccessfulLogins(int successfulLogins) {
        this.successfulLogins = successfulLogins;
    }

    public List<ProfileProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<ProfileProperty> properties) {
        this.properties = properties;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Integer getAsnNumber() {
        return this.asnNumber;
    }

    public void setAsnNumber(Integer asnNumber) {
        this.asnNumber = asnNumber;
    }

    public String getAsName() {
        return this.asName;
    }

    public void setAsName(String asName) {
        this.asName = asName;
    }

    public String getPinHash() {
        return this.pinHash;
    }

    public void setPinHash(String pinHash) {
        this.pinHash = pinHash;
    }
}

