/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.monitor;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class MojangServiceMonitor {
    private final Logger logger;
    private final HttpClient httpClient;
    private final AtomicBoolean available = new AtomicBoolean(true);
    private final AtomicInteger consecutiveFailures = new AtomicInteger(0);
    private volatile long lastSuccessfulCheck = 0L;
    private final int failureThreshold;
    private final int timeoutMillis;

    public MojangServiceMonitor(Logger logger, int failureThreshold, int timeoutMillis) {
        this.logger = logger;
        this.failureThreshold = failureThreshold;
        this.timeoutMillis = timeoutMillis;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(timeoutMillis)).build();
    }

    public boolean isAvailable() {
        return this.available.get();
    }

    public boolean shouldAttemptMojangAuth() {
        return this.isAvailable();
    }

    public void recordAuthAttempt(boolean success) {
        if (success) {
            this.consecutiveFailures.set(0);
            if (!this.available.getAndSet(true)) {
                this.logger.info("Mojang auth marked available after successful attempt.");
            }
        } else {
            int fails = this.consecutiveFailures.incrementAndGet();
            if (fails >= this.failureThreshold && this.available.getAndSet(false)) {
                this.logger.warn("Mojang auth marked DOWN after {} consecutive failures.", (Object)fails);
            }
        }
    }

    public void runHealthCheck() {
        try {
            boolean ok;
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://sessionserver.mojang.com/")).timeout(Duration.ofMillis(this.timeoutMillis)).GET().build();
            HttpResponse<Void> response = this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
            int code = response.statusCode();
            boolean bl = ok = code >= 200 && code < 500;
            if (ok) {
                this.lastSuccessfulCheck = System.currentTimeMillis();
                this.recordAuthAttempt(true);
            } else {
                this.recordAuthAttempt(false);
            }
        }
        catch (Exception e) {
            this.recordAuthAttempt(false);
        }
    }

    public long getLastSuccessfulCheck() {
        return this.lastSuccessfulCheck;
    }
}

