/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.pin;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.texboobcat.downAuth.config.PluginConfig;
import org.texboobcat.downAuth.model.CachedSession;
import org.texboobcat.downAuth.session.SessionCache;
import org.texboobcat.downAuth.util.AuditLogger;
import org.texboobcat.downAuth.util.MessageUtil;
import org.texboobcat.downAuth.util.SecurityUtils;

public class PinService {
    private final Logger logger;
    private final ProxyServer proxy;
    private final SessionCache sessions;
    private final PluginConfig config;
    private final AuditLogger audit;
    private final Object pluginOwner;
    private final Map<UUID, Long> pendingUntil = new ConcurrentHashMap<UUID, Long>();

    public PinService(Logger logger, ProxyServer proxy, SessionCache sessions, PluginConfig config, AuditLogger audit, Object pluginOwner) {
        this.logger = logger;
        this.proxy = proxy;
        this.sessions = sessions;
        this.config = config;
        this.audit = audit;
        this.pluginOwner = pluginOwner;
    }

    public boolean isPending(UUID uuid) {
        Long until = this.pendingUntil.get(uuid);
        return until != null && until > System.currentTimeMillis();
    }

    public void requireVerification(Player player, CachedSession session) {
        int timeout = Math.max(5, this.config.security.pinTimeoutSeconds);
        long until = System.currentTimeMillis() + (long)timeout * 1000L;
        this.pendingUntil.put(player.getUniqueId(), until);
        String msg = this.config.messages.pinPrompt.replace("%timeout%", String.valueOf(timeout));
        player.sendMessage(MessageUtil.colorize(msg));
        if (this.audit != null) {
            this.audit.log("PIN_REQUIRED username=" + player.getUsername() + " uuid=" + player.getUniqueId());
        }
        this.proxy.getScheduler().buildTask(this.pluginOwner, () -> {
            if (this.isPending(player.getUniqueId())) {
                player.disconnect(MessageUtil.colorize(this.config.messages.pinFailure));
                this.pendingUntil.remove(player.getUniqueId());
                if (this.audit != null) {
                    this.audit.log("PIN_TIMEOUT username=" + player.getUsername() + " uuid=" + player.getUniqueId());
                }
            }
        }).delay(Duration.ofSeconds(timeout)).schedule();
    }

    public boolean tryVerify(UUID uuid, String code) {
        if (!this.isPending(uuid)) {
            return false;
        }
        CachedSession s = this.sessions.getSession(uuid);
        if (s == null || s.getPinHash() == null) {
            return false;
        }
        String hash = SecurityUtils.sha256Hex(code);
        if (!hash.equals(s.getPinHash())) {
            return false;
        }
        this.pendingUntil.remove(uuid);
        return true;
    }

    public boolean setPin(Player player, String code) {
        if (code == null || code.length() < this.config.security.pinMinLength) {
            return false;
        }
        CachedSession s = this.sessions.getSession(player.getUniqueId());
        if (s == null) {
            s = new CachedSession(player.getUniqueId(), player.getUsername());
        }
        s.setPinHash(SecurityUtils.sha256Hex(code));
        this.sessions.updateSession(player.getUniqueId(), player.getUsername(), player.getRemoteAddress().getAddress().getHostAddress(), s);
        if (this.audit != null) {
            this.audit.log("PIN_SET username=" + player.getUsername() + " uuid=" + player.getUniqueId());
        }
        return true;
    }

    public boolean clearPin(Player player) {
        CachedSession s = this.sessions.getSession(player.getUniqueId());
        if (s == null) {
            return false;
        }
        s.setPinHash(null);
        this.sessions.updateSession(player.getUniqueId(), player.getUsername(), player.getRemoteAddress().getAddress().getHostAddress(), s);
        if (this.audit != null) {
            this.audit.log("PIN_CLEARED username=" + player.getUsername() + " uuid=" + player.getUniqueId());
        }
        return true;
    }
}

