/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.security;

import java.net.Inet4Address;
import java.net.InetAddress;
import org.texboobcat.downAuth.security.SecurityPolicy;

public class IpValidator {
    public boolean validateIp(String cachedIp, String currentIp, SecurityPolicy policy) {
        if (!policy.isStrictIpCheck()) {
            return true;
        }
        if (cachedIp == null || currentIp == null) {
            return false;
        }
        if (cachedIp.equals(currentIp)) {
            return true;
        }
        if (!policy.isAllowIpRangeMatch()) {
            return false;
        }
        try {
            InetAddress a = InetAddress.getByName(cachedIp);
            InetAddress b = InetAddress.getByName(currentIp);
            if (a.getClass() != b.getClass()) {
                return false;
            }
            int prefix = a instanceof Inet4Address ? policy.getIpv4RangePrefix() : policy.getIpv6RangePrefix();
            return this.samePrefix(a.getAddress(), b.getAddress(), prefix);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean samePrefix(byte[] a, byte[] b, int prefixBits) {
        if (a.length != b.length) {
            return false;
        }
        if (prefixBits <= 0) {
            return true;
        }
        int fullBytes = prefixBits / 8;
        int remBits = prefixBits % 8;
        for (int i = 0; i < fullBytes; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        if (remBits == 0) {
            return true;
        }
        int ai = a[fullBytes] & 0xFF;
        int mask = -1 << 8 - remBits;
        int bi = b[fullBytes] & 0xFF;
        return (ai & mask) == (bi & mask);
    }
}

