/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.security;

import java.util.List;
import org.texboobcat.downAuth.config.PluginConfig;

public class SecurityPolicy {
    private final int minLoginHistory;
    private final int maxFailedAttempts;
    private final int failureBanDurationMinutes;
    private final boolean requireRecentActivity;
    private final int recentActivityDays;
    private final boolean alertOnFallback;
    private final boolean strictIpCheck;
    private final boolean allowIpRangeMatch;
    private final int maxSessionAgeHours;
    private final int ipv4RangePrefix;
    private final int ipv6RangePrefix;
    private final boolean denyOnGeoChange;
    private final boolean requirePinOnFallback;
    private final int pinTimeoutSeconds;
    private final int maxFailedAttemptsPerSubnet;
    private final int maxFailedAttemptsPerAsn;
    private final List<Integer> blockedAsns;

    public SecurityPolicy(PluginConfig cfg) {
        this.minLoginHistory = cfg.security.minLoginHistory;
        this.maxFailedAttempts = cfg.security.maxFailedAttempts;
        this.failureBanDurationMinutes = cfg.security.failureBanDurationMinutes;
        this.requireRecentActivity = cfg.security.requireRecentActivity;
        this.recentActivityDays = cfg.security.recentActivityDays;
        this.alertOnFallback = cfg.security.alertOnFallback;
        this.strictIpCheck = cfg.sessionCache.strictIpCheck;
        this.allowIpRangeMatch = cfg.sessionCache.allowIpRangeMatch;
        this.maxSessionAgeHours = cfg.sessionCache.maxSessionAgeHours;
        this.ipv4RangePrefix = cfg.sessionCache.ipv4RangePrefix;
        this.ipv6RangePrefix = cfg.sessionCache.ipv6RangePrefix;
        this.denyOnGeoChange = cfg.security.denyOnGeoChange;
        this.requirePinOnFallback = cfg.security.requirePinOnFallback;
        this.pinTimeoutSeconds = cfg.security.pinTimeoutSeconds;
        this.maxFailedAttemptsPerSubnet = cfg.security.maxFailedAttemptsPerSubnet;
        this.maxFailedAttemptsPerAsn = cfg.security.maxFailedAttemptsPerAsn;
        this.blockedAsns = cfg.security.blockedAsns;
    }

    public int getMinLoginHistory() {
        return this.minLoginHistory;
    }

    public int getMaxFailedAttempts() {
        return this.maxFailedAttempts;
    }

    public int getFailureBanDurationMinutes() {
        return this.failureBanDurationMinutes;
    }

    public boolean isRequireRecentActivity() {
        return this.requireRecentActivity;
    }

    public int getRecentActivityDays() {
        return this.recentActivityDays;
    }

    public boolean isAlertOnFallback() {
        return this.alertOnFallback;
    }

    public boolean isStrictIpCheck() {
        return this.strictIpCheck;
    }

    public boolean isAllowIpRangeMatch() {
        return this.allowIpRangeMatch;
    }

    public int getMaxSessionAgeHours() {
        return this.maxSessionAgeHours;
    }

    public int getIpv4RangePrefix() {
        return this.ipv4RangePrefix;
    }

    public int getIpv6RangePrefix() {
        return this.ipv6RangePrefix;
    }

    public boolean isDenyOnGeoChange() {
        return this.denyOnGeoChange;
    }

    public boolean isRequirePinOnFallback() {
        return this.requirePinOnFallback;
    }

    public int getPinTimeoutSeconds() {
        return this.pinTimeoutSeconds;
    }

    public int getMaxFailedAttemptsPerSubnet() {
        return this.maxFailedAttemptsPerSubnet;
    }

    public int getMaxFailedAttemptsPerAsn() {
        return this.maxFailedAttemptsPerAsn;
    }

    public List<Integer> getBlockedAsns() {
        return this.blockedAsns;
    }
}

