/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.security;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.texboobcat.downAuth.model.CachedSession;
import org.texboobcat.downAuth.security.IpValidator;
import org.texboobcat.downAuth.security.SecurityCheckResult;
import org.texboobcat.downAuth.security.SecurityPolicy;

public class SecurityValidator {
    private final IpValidator ipValidator = new IpValidator();
    private final Map<String, Counter> ipCounters = new ConcurrentHashMap<String, Counter>();
    private final Map<UUID, Counter> uuidCounters = new ConcurrentHashMap<UUID, Counter>();
    private final Map<String, Counter> subnetCounters = new ConcurrentHashMap<String, Counter>();
    private final Map<Integer, Counter> asnCounters = new ConcurrentHashMap<Integer, Counter>();

    public SecurityCheckResult validateCachedSession(CachedSession session, String connectingIp, SecurityPolicy policy) {
        long maxAgeMillis;
        if (session == null) {
            return SecurityCheckResult.fail("No cached session");
        }
        long configuredHours = policy.getMaxSessionAgeHours();
        long l = maxAgeMillis = policy.getRecentActivityDays() > 0 ? Math.min(SecurityValidator.hoursToMillis((int)configuredHours), SecurityValidator.daysToMillis(policy.getRecentActivityDays())) : SecurityValidator.hoursToMillis((int)configuredHours);
        if (!session.isValid(maxAgeMillis)) {
            return SecurityCheckResult.fail("Session expired");
        }
        if (session.getSuccessfulLogins() < policy.getMinLoginHistory()) {
            return SecurityCheckResult.fail("Insufficient login history");
        }
        if (!this.ipValidator.validateIp(session.getLastKnownIp(), connectingIp, policy)) {
            return SecurityCheckResult.fail("IP mismatch");
        }
        return SecurityCheckResult.ok();
    }

    public boolean isSuspiciousLogin(CachedSession session, String ip) {
        return session != null && session.getLastKnownIp() != null && !session.getLastKnownIp().equals(ip);
    }

    public boolean isRateLimited(String ip, UUID uuid, SecurityPolicy policy) {
        Counter idC;
        long now = System.currentTimeMillis();
        long window = 3600000L;
        int max = policy.getMaxFailedAttempts();
        Counter ipC = this.ipCounters.computeIfAbsent(ip, k -> new Counter());
        if (now - ipC.windowStart > window) {
            ipC.windowStart = now;
            ipC.attempts = 0;
        }
        if (ipC.attempts >= max) {
            return true;
        }
        Counter counter = idC = uuid != null ? this.uuidCounters.computeIfAbsent(uuid, k -> new Counter()) : null;
        if (idC != null) {
            if (now - idC.windowStart > window) {
                idC.windowStart = now;
                idC.attempts = 0;
            }
            if (idC.attempts >= max) {
                return true;
            }
        }
        return false;
    }

    public boolean isRateLimitedExtended(String ip, UUID uuid, SecurityPolicy policy, String subnetKey, Integer asn) {
        Counter c;
        if (this.isRateLimited(ip, uuid, policy)) {
            return true;
        }
        long now = System.currentTimeMillis();
        long window = 3600000L;
        if (subnetKey != null) {
            c = this.subnetCounters.computeIfAbsent(subnetKey, k -> new Counter());
            if (now - c.windowStart > window) {
                c.windowStart = now;
                c.attempts = 0;
            }
            if (c.attempts >= policy.getMaxFailedAttemptsPerSubnet()) {
                return true;
            }
        }
        if (asn != null) {
            c = this.asnCounters.computeIfAbsent(asn, k -> new Counter());
            if (now - c.windowStart > window) {
                c.windowStart = now;
                c.attempts = 0;
            }
            if (c.attempts >= policy.getMaxFailedAttemptsPerAsn()) {
                return true;
            }
        }
        return false;
    }

    public void recordFailed(String ip, UUID uuid) {
        Counter idC;
        Counter ipC = this.ipCounters.computeIfAbsent(ip, k -> new Counter());
        ++ipC.attempts;
        Counter counter = idC = uuid != null ? this.uuidCounters.computeIfAbsent(uuid, k -> new Counter()) : null;
        if (idC != null) {
            ++idC.attempts;
        }
    }

    public void recordFailedExtended(String ip, UUID uuid, String subnetKey, Integer asn) {
        Counter c;
        this.recordFailed(ip, uuid);
        if (subnetKey != null) {
            c = this.subnetCounters.computeIfAbsent(subnetKey, k -> new Counter());
            ++c.attempts;
        }
        if (asn != null) {
            c = this.asnCounters.computeIfAbsent(asn, k -> new Counter());
            ++c.attempts;
        }
    }

    public void recordSuccess(String ip, UUID uuid) {
        Counter idC;
        Counter ipC = this.ipCounters.get(ip);
        if (ipC != null) {
            ipC.attempts = 0;
        }
        if (uuid != null && (idC = this.uuidCounters.get(uuid)) != null) {
            idC.attempts = 0;
        }
    }

    private static long hoursToMillis(int h) {
        return (long)h * 3600000L;
    }

    private static long daysToMillis(int d) {
        return (long)d * 86400000L;
    }

    public String subnetKey(String ip, SecurityPolicy policy) {
        try {
            InetAddress addr = InetAddress.getByName(ip);
            int prefix = addr instanceof Inet4Address ? policy.getIpv4RangePrefix() : policy.getIpv6RangePrefix();
            byte[] a = addr.getAddress();
            int full = prefix / 8;
            int rem = prefix % 8;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < full; ++i) {
                sb.append(a[i] & 0xFF).append('.');
            }
            if (rem > 0 && full < a.length) {
                int mask = -1 << 8 - rem;
                int v = a[full] & 0xFF & mask;
                sb.append(v);
            }
            sb.append('/').append(prefix);
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class Counter {
        int attempts;
        long windowStart;

        private Counter() {
        }
    }
}

