/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.session;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.texboobcat.downAuth.model.CachedSession;
import org.texboobcat.downAuth.session.SessionCache;
import org.texboobcat.downAuth.session.storage.SessionStorage;

public class SessionCacheImpl
implements SessionCache {
    private final Map<UUID, CachedSession> byId = new ConcurrentHashMap<UUID, CachedSession>();
    private final Map<String, UUID> byName = new ConcurrentHashMap<String, UUID>();
    private final SessionStorage storage;

    public SessionCacheImpl(SessionStorage storage) {
        this.storage = storage;
    }

    @Override
    public void updateSession(UUID uuid, String username, String ip, CachedSession base) {
        CachedSession s = base != null ? base : this.byId.computeIfAbsent(uuid, k -> new CachedSession(uuid, username));
        s.setUsername(username);
        s.setLastKnownIp(ip);
        s.setLastAuthTimestamp(System.currentTimeMillis());
        if (s.getFirstAuthTimestamp() == 0L) {
            s.setFirstAuthTimestamp(System.currentTimeMillis());
        }
        s.incrementSuccessfulLogins();
        this.byId.put(uuid, s);
        if (username != null) {
            this.byName.put(username.toLowerCase(), uuid);
        }
        CompletableFuture.runAsync(() -> this.storage.save(s));
    }

    @Override
    public void updateSession(UUID uuid, String username, String ip) {
        this.updateSession(uuid, username, ip, this.byId.get(uuid));
    }

    @Override
    public CachedSession getSession(UUID uuid) {
        CachedSession s = this.byId.get(uuid);
        if (s == null && (s = this.storage.load(uuid)) != null) {
            this.byId.put(uuid, s);
            if (s.getUsername() != null) {
                this.byName.putIfAbsent(s.getUsername().toLowerCase(), s.getPlayerUuid());
            }
        }
        return s;
    }

    @Override
    public CachedSession getSessionByUsername(String username) {
        if (username == null) {
            return null;
        }
        UUID id = this.byName.get(username.toLowerCase());
        if (id != null) {
            return this.getSession(id);
        }
        return null;
    }

    @Override
    public void updateLastSeen(UUID uuid, String ip) {
        CachedSession s = this.getSession(uuid);
        if (s != null) {
            s.setLastSeenTimestamp(System.currentTimeMillis());
            s.setLastKnownIp(ip);
            CompletableFuture.runAsync(() -> this.storage.save(s));
        }
    }

    @Override
    public void cleanExpiredSessions(long maxAgeMillis) {
        long cutoff = System.currentTimeMillis() - maxAgeMillis;
        this.byId.entrySet().removeIf(e -> ((CachedSession)e.getValue()).getLastAuthTimestamp() < cutoff);
        this.storage.deleteExpired(cutoff);
    }
}

