/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.session.storage;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.slf4j.Logger;
import org.texboobcat.downAuth.model.CachedSession;
import org.texboobcat.downAuth.session.storage.SessionStorage;
import org.texboobcat.downAuth.util.JsonUtils;

public class JsonSessionStorage
implements SessionStorage {
    private static final Type SESSION_TYPE = new TypeToken<CachedSession>(){}.getType();
    private final Path rootDir;
    private final Logger logger;

    public JsonSessionStorage(Path dataDir) throws IOException {
        this(null, dataDir);
    }

    public JsonSessionStorage(Logger logger, Path dataDir) throws IOException {
        this.logger = logger;
        this.rootDir = dataDir.resolve("sessions");
        if (!Files.exists(this.rootDir, new LinkOption[0])) {
            Files.createDirectories(this.rootDir, new FileAttribute[0]);
        }
    }

    private Path fileOf(UUID uuid) {
        return this.rootDir.resolve(uuid.toString() + ".json");
    }

    @Override
    public synchronized void save(CachedSession session) {
        block8: {
            Path path = this.fileOf(session.getPlayerUuid());
            try (BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                JsonUtils.gson().toJson((Object)session, (Appendable)w);
            }
            catch (IOException e) {
                if (this.logger == null) break block8;
                this.logger.warn("Failed to save session {} to {}", new Object[]{session.getPlayerUuid(), path, e});
            }
        }
    }

    @Override
    public synchronized CachedSession load(UUID uuid) {
        CachedSession cachedSession;
        block10: {
            Path path = this.fileOf(uuid);
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            BufferedReader r = Files.newBufferedReader(path, StandardCharsets.UTF_8);
            try {
                cachedSession = (CachedSession)JsonUtils.gson().fromJson((Reader)r, SESSION_TYPE);
                if (r == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if (this.logger != null) {
                        this.logger.warn("Failed to load session {} from {}", new Object[]{uuid, path, e});
                    }
                    return null;
                }
            }
            r.close();
        }
        return cachedSession;
    }

    @Override
    public synchronized void deleteExpired(long cutoffMillis) {
        block2: {
            try {
                Files.list(this.rootDir).forEach(p -> {
                    block9: {
                        try (BufferedReader r = Files.newBufferedReader(p, StandardCharsets.UTF_8);){
                            CachedSession s = (CachedSession)JsonUtils.gson().fromJson((Reader)r, SESSION_TYPE);
                            if (s != null && s.getLastAuthTimestamp() < cutoffMillis) {
                                Files.deleteIfExists(p);
                            }
                        }
                        catch (Exception e) {
                            if (this.logger == null) break block9;
                            this.logger.warn("Failed during deleteExpired for file {}", p, (Object)e);
                        }
                    }
                });
            }
            catch (IOException e) {
                if (this.logger == null) break block2;
                this.logger.warn("Failed to iterate sessions directory {}", (Object)this.rootDir, (Object)e);
            }
        }
    }
}

