/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class AuditLogger {
    private final Path file;
    private final DateTimeFormatter fmt = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneOffset.UTC);

    public AuditLogger(Path file) {
        this.file = file;
        try {
            if (Files.notExists(file, new LinkOption[0])) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.createFile(file, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void log(String message) {
        String line = String.format("%s %s%n", this.fmt.format(Instant.now()), message);
        try (BufferedWriter w = Files.newBufferedWriter(this.file, StandardCharsets.UTF_8, StandardOpenOption.APPEND);){
            w.write(line);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

