/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class SecurityUtils {
    private static final SecureRandom RNG = new SecureRandom();

    private SecurityUtils() {
    }

    public static String randomHex(int bytes) {
        byte[] b = new byte[bytes];
        RNG.nextBytes(b);
        return SecurityUtils.toHex(b);
    }

    public static String sha256Hex(String s) {
        try {
            MessageDigest d = MessageDigest.getInstance("SHA-256");
            byte[] hash = d.digest(s.getBytes(StandardCharsets.UTF_8));
            return SecurityUtils.toHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String toHex(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (byte value : b) {
            sb.append(String.format("%02x", value));
        }
        return sb.toString();
    }
}

