/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downAuth.web;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.texboobcat.downAuth.api.AuthFallbackAPI;
import org.texboobcat.downAuth.api.AuthenticationListener;
import org.texboobcat.downAuth.model.CachedSession;
import org.texboobcat.downAuth.monitor.MojangServiceMonitor;
import org.texboobcat.downAuth.session.SessionCache;

public class AuthApi
implements AuthFallbackAPI {
    private final SessionCache sessions;
    private final MojangServiceMonitor monitor;
    private final Set<UUID> usingFallback = ConcurrentHashMap.newKeySet();
    private final Set<UUID> requireOnline = ConcurrentHashMap.newKeySet();
    private final Set<AuthenticationListener> listeners = ConcurrentHashMap.newKeySet();

    public AuthApi(SessionCache sessions, MojangServiceMonitor monitor) {
        this.sessions = sessions;
        this.monitor = monitor;
    }

    @Override
    public boolean isUsingFallbackAuth(UUID uuid) {
        return this.usingFallback.contains(uuid);
    }

    @Override
    public Optional<CachedSession> getCachedSession(UUID uuid) {
        return Optional.ofNullable(this.sessions.getSession(uuid));
    }

    @Override
    public void invalidateSession(UUID uuid) {
        CachedSession s = this.sessions.getSession(uuid);
        if (s != null) {
            s.setLastAuthTimestamp(0L);
        }
    }

    @Override
    public boolean areMojangServicesAvailable() {
        return this.monitor.isAvailable();
    }

    @Override
    public void requireMojangAuth(UUID uuid) {
        this.requireOnline.add(uuid);
    }

    @Override
    public void registerAuthListener(AuthenticationListener listener) {
        this.listeners.add(listener);
    }

    public void markUsingFallback(UUID uuid, boolean state) {
        if (state) {
            this.usingFallback.add(uuid);
        } else {
            this.usingFallback.remove(uuid);
        }
    }

    public void notifyFallbackUsed(UUID uuid, String username) {
        for (AuthenticationListener l : this.listeners) {
            l.onFallbackAuthUsed(uuid, username);
        }
    }

    public boolean requiresOnline(UUID uuid) {
        return this.requireOnline.contains(uuid);
    }
}

