---@meta
-- Auto-generated LuaCATS documentation
-- Generated by LuaDocGenerator for LuaCraftBeta

---@class Vector3
---@field x number @The X coordinate
---@field y number @The Y coordinate
---@field z number @The Z coordinate
Vector3 = {}

---@class storage
storage = {}

---@class LuaPlayer
local LuaPlayer = {}

---@class LuaWorld
local LuaWorld = {}

---@class LuaMaterial
local LuaMaterial = {}

---@class LuaItemStack
local LuaItemStack = {}

---@class LuaEntity
local LuaEntity = {}

---@class LuaBlock
local LuaBlock = {}

---Prints a message to the server chat prefixed with [Lua].
---@param message string
function print(message) end

---Yields the coroutine for a number of seconds, then resumes.
---@param seconds number
function wait(seconds) end

---Creates a new 3D vector with x, y, z coordinates.
---@param x number
---@param y number
---@param z number
---@return Vector3 @A new vector object
function Vector3.new(x, y, z) end

---Saves a key-value pair to persistent storage. Tables are encoded as JSON.
---@param key string
---@param value string|table
function storage.applySaveData(key, value) end

---Retrieves previously saved data for the given key.
---@param key string
---@return string|table|nil @The stored value, or nil if not found
function storage.getSavedData(key) end

---@class mc
local mc = {}

---Spawns an entity at a location or at a player's position.
---@param entityName string
---@param positionOrPlayer Vector3|string
---@return table @The spawned LuaEntity table
function mc.summon(entityName, positionOrPlayer) end

---Returns all entities in the given world.
---@param world table
---@return table @Array of LuaEntity tables
function mc.getAllEntities(world) end

---Returns all entities of a given type from a world.
---@param world table
---@param entityType string
---@return table @Array of LuaEntity tables matching the given type
function mc.getEntitiesByType(world, entityType) end

---Gets a player by name if they are online. Returns a LuaPlayer or error table.
---@param name string
---@return table @LuaPlayer or error table
function mc.getPlayer(name) end

---Returns a list of online player names.
---@return string[] @Array of online player names
function mc.getOnlinePlayers() end

---Returns a world by its name.
---@param worldName string
---@return table @LuaWorld table
function mc.getWorld(worldName) end

---Returns a material by its numeric ID.
---@param id integer
---@return table @LuaMaterial table if found, or an error message string
function mc.getMaterial(id) end

---Broadcasts a message to all players on the server.
---@param message string
function mc.broadcast(message) end

---Sends a private message to the specified player.
---@param playerName string
---@param message string
function mc.sendMessage(playerName, message) end

---Returns the name of the player.
---@param self LuaPlayer
---@return string @The player's name
function LuaPlayer.getName(self) end

---Sends a message to the player.
---@param self LuaPlayer
---@param message string
function LuaPlayer.sendMessage(self, message) end

---Returns the direction the player is looking as a Vector3.
---@param self LuaPlayer
---@return Vector3 @Direction vector the player is facing
function LuaPlayer.getLookDirection(self) end

---Teleports the player to the given Vector3 position.
---@param self LuaPlayer
---@param position Vector3
function LuaPlayer.teleport(self, position) end

---Gets the player's current health.
---@param self LuaPlayer
---@return number @Current health value
function LuaPlayer.getHealth(self) end

---Sets the player's health, clamped between 0 and 20.
---@param self LuaPlayer
---@param health number
function LuaPlayer.setHealth(self, health) end

---Checks if the player is an operator.
---@param self LuaPlayer
---@return boolean @True if the player is op
function LuaPlayer.isOp(self) end

---Sets the player's operator status.
---@param self LuaPlayer
---@param value boolean
function LuaPlayer.setOp(self, value) end

---Kicks the player with the given reason.
---@param self LuaPlayer
---@param reason string
function LuaPlayer.kick(self, reason) end

---Gets the item in the player's hand.
---@param self LuaPlayer
---@return string @Item in format 'material:amount' or nil
function LuaPlayer.getItemInHand(self) end

---Sets the item in the player's hand.
---@param self LuaPlayer
---@param material string
---@param amount number
function LuaPlayer.setItemInHand(self, material, amount) end

---Gives the player an item.
---@param self LuaPlayer
---@param material string
---@param amount number
function LuaPlayer.giveItem(self, material, amount) end

---Returns the player's current position as a Vector3.
---@param self LuaPlayer
---@return Vector3 @Player position vector
function LuaPlayer.getLocation(self) end

---Gets the dimension name the player is currently in.
---@param self LuaPlayer
---@return string @Dimension name (overworld, nether, the_end, unknown)
function LuaPlayer.getDimension(self) end

---Gets the LuaWorld object the player is in.
---@param self LuaPlayer
---@return LuaWorld @The world the player is currently in
function LuaPlayer.getWorld(self) end

---Sets the vector's coordinates.
---@param x number
---@param y number
---@param z number
function Vector3.set(x, y, z) end

---Returns a copy of this vector.
---@return Vector3 @Cloned vector
function Vector3.clone() end

---Returns the length (magnitude) of the vector.
---@return number @Length of the vector
function Vector3.length() end

---Normalizes this vector to a unit vector.
---@return Vector3 @Normalized vector
function Vector3.normalize() end

---Returns the name of the world.
---@return string
function LuaWorld.getName() end

---Gets the current time in the world.
---@return number
function LuaWorld.getTime() end

---Sets the current time in the world.
---@param time number
function LuaWorld.setTime(time) end

---Returns whether the world is currently experiencing a storm.
---@return boolean
function LuaWorld.hasStorm() end

---Enables or disables stormy weather in the world.
---@param value boolean
function LuaWorld.setStorm(value) end

---Strikes lightning at the given coordinates.
---@param x number
---@param y number
---@param z number
function LuaWorld.strikeLightning(x, y, z) end

---Creates an explosion at a location. Can accept x, y, z, power or (Vector3, power).
---@param xOrVector number|table
---@param yOrPower number
---@param z number
function LuaWorld.createExplosion(xOrVector, yOrPower, z) end

---Returns the seed used to generate the world.
---@return number
function LuaWorld.getSeed() end

---Returns a list of players in this world.
---@return table @Array of LuaPlayer objects
function LuaWorld.getPlayers() end

---Returns all entities in the world.
---@return table @Array of LuaEntity objects
function LuaWorld.getEntities() end

---Sets a block at a given location to the specified type and optional data.
---@param x number
---@param y number
---@param z number
---@param blockType string
---@param data number?
function LuaWorld.setBlock(x, y, z, blockType, data) end

---Returns the block at the given location.
---@param x number
---@param y number
---@param z number
---@return table @LuaBlock representing the block
function LuaWorld.getBlockAt(x, y, z) end

---Gets the numeric ID of the material.
---@return number @The Bukkit material ID
function LuaMaterial.getId() end

---Returns the maximum stack size for this material.
---@return number
function LuaMaterial.getMaxStackSize() end

---Returns the max durability of the material.
---@return number
function LuaMaterial.getMaxDurability() end

---Gets the lowercase name of the material.
---@return string
function LuaMaterial.getName() end

---Returns true if this material is a placeable block.
---@return boolean
function LuaMaterial.isBlock() end

---Gets the type of the item as a lowercase string.
---@return string @The material type
function LuaItemStack.getType() end

---Sets the item type using a string name.
---@param materialName string
function LuaItemStack.setType(materialName) end

---Returns the number of items in the stack.
---@return number @The stack size
function LuaItemStack.getAmount() end

---Sets the number of items in the stack.
---@param amount number
function LuaItemStack.setAmount(amount) end

---Gets the durability value of the item.
---@return number @The durability value
function LuaItemStack.getDurability() end

---Sets the durability of the item.
---@param durability number
function LuaItemStack.setDurability(durability) end

---Returns data for the item if available (e.g., wool color).
---@return table|string @A table with data or a message if unavailable
function LuaItemStack.getData() end

---Sets data on the item, like color for wool blocks.
---@param data table
function LuaItemStack.setData(data) end

---Returns the entity type as a lowercase name.
---@return string @Entity type name
function LuaEntity.getType() end

---Returns the unique entity ID.
---@return number @Entity ID
function LuaEntity.getId() end

---Returns whether the entity is dead.
---@return boolean @True if dead
function LuaEntity.isDead() end

---Sets the fire ticks duration.
---@param ticks number
function LuaEntity.setFireTicks(ticks) end

---Teleports the entity using a Vector3 table.
---@param position Vector3
function LuaEntity.teleport(position) end

---Returns the entity's current location.
---@return Vector3 @Entity position
function LuaEntity.getLocation() end

---Returns all entities in the chunk this entity is currently in.
---@return table @Array of LuaEntity tables
function LuaEntity.getEntitiesInChunk() end

---Returns whether the entity is empty (e.g. vehicle without passenger).
---@return boolean @True if empty
function LuaEntity.isEmpty() end

---Ejects any passenger from the entity.
---@return boolean @True if something was ejected
function LuaEntity.eject() end

---Removes the entity from the world.
function LuaEntity.remove() end

---Returns the block's position as a Vector3.
---@return Vector3 @Block position vector
function LuaBlock.getPosition() end

---Gets the block's material name.
---@return string @Block material name
function LuaBlock.getType() end

---Gets the block's legacy type ID.
---@return number @Type ID
function LuaBlock.getTypeId() end

---Sets the block type by name.
---@param materialName string
function LuaBlock.setType(materialName) end

---Sets the block type using a numeric ID.
---@param id number
---@return boolean @True if the block type was set successfully
function LuaBlock.setTypeId(id) end

---Sets the block's data byte.
---@param byte number
function LuaBlock.setData(byte) end

---Gets the block's X coordinate.
---@return number @X position
function LuaBlock.getX() end

---Gets the block's Y coordinate.
---@return number @Y position
function LuaBlock.getY() end

---Gets the block's Z coordinate.
---@return number @Z position
function LuaBlock.getZ() end

---Returns whether the block is considered air or empty.
---@return boolean @True if empty
function LuaBlock.isEmpty() end

---Returns whether the block is a liquid.
---@return boolean @True if liquid
function LuaBlock.isLiquid() end

---Gets the block's data byte.
---@return number @Data byte
function LuaBlock.getData() end

---Returns the block's current light level.
---@return number @Light level (0-15)
function LuaBlock.getLightLevel() end

---Gets the relative block in a given direction.
---@param faceName string
---@return LuaBlock @The block relative to this one
function LuaBlock.getRelative(faceName) end

---Checks if a specific face of the block is powered.
---@param faceName string
---@return boolean @True if powered
function LuaBlock.isBlockFacePowered(faceName) end

