/*
 * Decompiled with CFR 0.152.
 */
package org.rkortlandt.getoffmyserver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.rkortlandt.getoffmyserver.TimeRestrictCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOffMyServer
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"timerestrict");
    private static final int KICK_CHECK_INTERVAL_TICKS = 600;
    private int tickCounter = 0;
    public static final Map<DayOfWeek, TimeRange> restrictionSchedule = new EnumMap<DayOfWeek, TimeRange>(DayOfWeek.class);
    public static String kickMessageTemplate = "\u00a7cServer access is restricted on \u00a76%day% \u00a7cbetween \u00a7e%start_time% \u00a7cand \u00a7e%end_time%.";
    public static final List<String> BYPASS_PLAYERS = new ArrayList<String>();
    private static final File BYPASS_PLAYERS_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "timerestrict_bypass.txt");
    private static final File SETTINGS_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "timerestrict_settings.properties");
    static final DateTimeFormatter HHMM_FORMATTER = DateTimeFormatter.ofPattern("HHmm");

    public void onInitialize() {
        GetOffMyServer.loadSettings();
        GetOffMyServer.loadBypassPlayers();
        TimeRestrictCommands.register();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            if (this.isCurrentlyRestricted() && !this.isPlayerExempt(player)) {
                handler.method_52396((class_2561)class_2561.method_43470((String)this.getKickMessage()));
                LOGGER.info("Denied {} from joining during restricted hours (not on bypass list).", (Object)player.method_5477().getString());
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ++this.tickCounter;
            if (this.tickCounter < 600) {
                return;
            }
            this.tickCounter = 0;
            if (this.isCurrentlyRestricted()) {
                String finalKickMessage = this.getKickMessage();
                for (class_3222 player : new ArrayList(server.method_3760().method_14571())) {
                    if (this.isPlayerExempt(player)) continue;
                    player.field_13987.method_52396((class_2561)class_2561.method_43470((String)finalKickMessage));
                    LOGGER.info("Kicking online player {} due to time/day restriction.", (Object)player.method_5477().getString());
                }
            }
        });
    }

    private boolean isPlayerExempt(class_3222 player) {
        return player.method_64475(2) || BYPASS_PLAYERS.contains(player.method_5477().getString());
    }

    private boolean isCurrentlyRestricted() {
        LocalTime endTime;
        LocalTime nowTime = LocalTime.now();
        DayOfWeek nowDay = LocalDate.now().getDayOfWeek();
        TimeRange todayRange = restrictionSchedule.get(nowDay);
        if (todayRange == null) {
            return false;
        }
        LocalTime startTime = todayRange.start();
        return startTime.isBefore(endTime = todayRange.end()) ? nowTime.isAfter(startTime) && nowTime.isBefore(endTime) : nowTime.isAfter(startTime) || nowTime.isBefore(endTime);
    }

    private String getKickMessage() {
        DayOfWeek nowDay = LocalDate.now().getDayOfWeek();
        TimeRange todayRange = restrictionSchedule.get(nowDay);
        if (todayRange == null) {
            return "Server is currently restricted.";
        }
        DateTimeFormatter readableFormat = DateTimeFormatter.ofPattern("HH:mm");
        return kickMessageTemplate.replace("%start_time%", todayRange.start().format(readableFormat)).replace("%end_time%", todayRange.end().format(readableFormat)).replace("%day%", nowDay.toString());
    }

    public static LocalTime parseHHmm(String timeStr) throws DateTimeParseException {
        return LocalTime.parse(timeStr, HHMM_FORMATTER);
    }

    public static void loadSettings() {
        restrictionSchedule.clear();
        Properties props = new Properties();
        if (SETTINGS_FILE.exists()) {
            try (FileInputStream in = new FileInputStream(SETTINGS_FILE);){
                props.load(in);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load settings file.", (Throwable)e);
            }
        }
        kickMessageTemplate = props.getProperty("kick.message", "\u00a7cServer access is restricted on \u00a76%day% \u00a7cbetween \u00a7e%start_time% \u00a7cand \u00a7e%end_time%.");
        for (DayOfWeek day : DayOfWeek.values()) {
            String dayKey = day.toString().toLowerCase() + ".times";
            String timeValue = props.getProperty(dayKey);
            if (timeValue == null || timeValue.equalsIgnoreCase("off")) continue;
            try {
                String[] parts = timeValue.split("-");
                if (parts.length != 2) continue;
                restrictionSchedule.put(day, new TimeRange(GetOffMyServer.parseHHmm(parts[0]), GetOffMyServer.parseHHmm(parts[1])));
            }
            catch (Exception e) {
                LOGGER.error("Invalid time format for {} in settings. Expected HHmm-HHmm", (Object)day);
            }
        }
        if (props.isEmpty()) {
            GetOffMyServer.addDefaultSchedule();
        }
        GetOffMyServer.saveSettings();
    }

    private static void addDefaultSchedule() {
        try {
            TimeRange weekendRange = new TimeRange(GetOffMyServer.parseHHmm("2300"), GetOffMyServer.parseHHmm("0700"));
            restrictionSchedule.put(DayOfWeek.SATURDAY, weekendRange);
            restrictionSchedule.put(DayOfWeek.SUNDAY, weekendRange);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    public static void saveSettings() {
        Properties props = new Properties();
        props.setProperty("kick.message", kickMessageTemplate);
        for (DayOfWeek day : DayOfWeek.values()) {
            String dayKey = day.toString().toLowerCase() + ".times";
            TimeRange range = restrictionSchedule.get(day);
            if (range != null) {
                props.setProperty(dayKey, range.start().format(HHMM_FORMATTER) + "-" + range.end().format(HHMM_FORMATTER));
                continue;
            }
            props.setProperty(dayKey, "off");
        }
        try (FileOutputStream out = new FileOutputStream(SETTINGS_FILE);){
            props.store(out, "TimeRestrict Mod Settings. Use format HHmm-HHmm (e.g. 2300-0700), or 'off'.");
        }
        catch (IOException e) {
            LOGGER.error("Failed to save settings file.", (Throwable)e);
        }
    }

    public static void loadBypassPlayers() {
        BYPASS_PLAYERS.clear();
        if (BYPASS_PLAYERS_FILE.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(BYPASS_PLAYERS_FILE));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    BYPASS_PLAYERS.add(line.trim());
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load bypass players list.", (Throwable)e);
            }
        }
    }

    public static void saveBypassPlayers() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(BYPASS_PLAYERS_FILE));){
            for (String playerName : BYPASS_PLAYERS) {
                writer.write(playerName);
                writer.newLine();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save bypass players list.", (Throwable)e);
        }
    }

    public record TimeRange(LocalTime start, LocalTime end) {
    }
}

