/*
 * Decompiled with CFR 0.152.
 */
package org.rkortlandt.getoffmyserver;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.time.DayOfWeek;
import java.util.Locale;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.rkortlandt.getoffmyserver.GetOffMyServer;

public class TimeRestrictCommands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"timerestrict").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bypass").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).executes(TimeRestrictCommands::addBypassPlayer)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).executes(TimeRestrictCommands::removeBypassPlayer)))).then(class_2170.method_9247((String)"list").executes(TimeRestrictCommands::listBypassPlayers)))).then(class_2170.method_9247((String)"status").executes(TimeRestrictCommands::showStatus))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"day", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"times", (ArgumentType)StringArgumentType.word()).executes(TimeRestrictCommands::setDaySchedule))))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"day", (ArgumentType)StringArgumentType.word()).executes(TimeRestrictCommands::clearDaySchedule)))));
    }

    private static int setDaySchedule(CommandContext<class_2168> context) {
        DayOfWeek day;
        String dayStr = StringArgumentType.getString(context, (String)"day").toUpperCase(Locale.ROOT);
        String timesStr = StringArgumentType.getString(context, (String)"times");
        try {
            day = DayOfWeek.valueOf(dayStr);
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cInvalid day: " + dayStr)), false);
            return 0;
        }
        try {
            String[] parts = timesStr.split("-");
            if (parts.length != 2) {
                throw new IllegalArgumentException();
            }
            GetOffMyServer.TimeRange newRange = new GetOffMyServer.TimeRange(GetOffMyServer.parseHHmm(parts[0]), GetOffMyServer.parseHHmm(parts[1]));
            GetOffMyServer.restrictionSchedule.put(day, newRange);
            GetOffMyServer.saveSettings();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aRestriction for " + String.valueOf(day) + " set to " + timesStr)), true);
            return 1;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cInvalid format. Use Day HHmm-HHmm (e.g., MONDAY 2300-0700)."), false);
            return 0;
        }
    }

    private static int clearDaySchedule(CommandContext<class_2168> context) {
        DayOfWeek day;
        String dayStr = StringArgumentType.getString(context, (String)"day").toUpperCase(Locale.ROOT);
        try {
            day = DayOfWeek.valueOf(dayStr);
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cInvalid day: " + dayStr)), false);
            return 0;
        }
        if (GetOffMyServer.restrictionSchedule.remove(day) != null) {
            GetOffMyServer.saveSettings();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aCleared restrictions for " + String.valueOf(day))), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7eNo restrictions were set for " + String.valueOf(day))), false);
        }
        return 1;
    }

    private static int showStatus(CommandContext<class_2168> context) {
        StringBuilder status = new StringBuilder("\u00a76--- TimeRestrict Schedule ---\n");
        for (DayOfWeek day : DayOfWeek.values()) {
            GetOffMyServer.TimeRange range = GetOffMyServer.restrictionSchedule.get(day);
            Object timeDisplay = "Off";
            if (range != null) {
                timeDisplay = range.start().format(GetOffMyServer.HHMM_FORMATTER) + "-" + range.end().format(GetOffMyServer.HHMM_FORMATTER);
            }
            String dayName = day.toString().substring(0, 1) + day.toString().substring(1).toLowerCase();
            status.append(String.format("\u00a7e%s: \u00a7f%s\n", dayName, timeDisplay));
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)status.toString()), false);
        return 1;
    }

    private static int addBypassPlayer(CommandContext<class_2168> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        if (GetOffMyServer.BYPASS_PLAYERS.contains(playerName)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cPlayer " + playerName + " is already on the bypass list.")), false);
            return 0;
        }
        GetOffMyServer.BYPASS_PLAYERS.add(playerName);
        GetOffMyServer.saveBypassPlayers();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aAdded " + playerName + " to the bypass list.")), true);
        return 1;
    }

    private static int removeBypassPlayer(CommandContext<class_2168> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        if (!GetOffMyServer.BYPASS_PLAYERS.contains(playerName)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cPlayer " + playerName + " is not on the bypass list.")), false);
            return 0;
        }
        GetOffMyServer.BYPASS_PLAYERS.remove(playerName);
        GetOffMyServer.saveBypassPlayers();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aRemoved " + playerName + " from the bypass list.")), true);
        return 1;
    }

    private static int listBypassPlayers(CommandContext<class_2168> context) {
        if (GetOffMyServer.BYPASS_PLAYERS.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76The bypass list is empty."), false);
        } else {
            String playerList = String.join((CharSequence)", ", GetOffMyServer.BYPASS_PLAYERS);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a76Players on bypass list: \u00a7e" + playerList)), false);
        }
        return 1;
    }
}

