/*
 * Decompiled with CFR 0.152.
 */
package com.dselent.bigarraylist;

import java.nio.BufferOverflowException;
import java.util.Arrays;

class SoftMapping<E> {
    private static final int MIN_BUFFER_SIZE = 0;
    private static final int MAX_BUFFER_SIZE = Integer.MAX_VALUE;
    private static final int DEFAULT_BUFFER_SIZE = 10000;
    private static final int DEFAULT_SHIFT_ELEMENT_SIZE = 10000;
    private static final int INFORMATION_PIECES = 3;
    private long[][] shiftBuffer;
    private int currentBufferSize;

    protected SoftMapping() {
        this.shiftBuffer = new long[3][10000];
        this.currentBufferSize = 0;
    }

    protected SoftMapping(int bufferSize) {
        if (bufferSize < 0 || bufferSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Buffer size is " + bufferSize + " but must be >= " + 0 + " and <= " + Integer.MAX_VALUE);
        }
        this.shiftBuffer = new long[3][bufferSize];
        this.currentBufferSize = 0;
    }

    protected int getBufferSize() {
        return this.currentBufferSize;
    }

    protected long getShiftIndex(int bufferIndex) {
        return this.shiftBuffer[0][bufferIndex];
    }

    protected long getLastShiftAmount() {
        long lastShiftAmount = 0L;
        if (this.currentBufferSize > 0) {
            lastShiftAmount = this.shiftBuffer[2][this.currentBufferSize - 1];
        }
        return lastShiftAmount;
    }

    protected long getAdjustedIndex(long adjustedIndex) {
        if (this.currentBufferSize != 0) {
            boolean done = false;
            boolean firstPass = true;
            int previousIndex = -1;
            while (!done) {
                int i;
                int searchIndex = Arrays.binarySearch(this.shiftBuffer[0], 0, this.currentBufferSize, adjustedIndex);
                if (firstPass) {
                    if (searchIndex >= 0) {
                        adjustedIndex += this.shiftBuffer[2][searchIndex];
                        previousIndex = searchIndex;
                    } else if (searchIndex == -1) {
                        if (this.shiftBuffer[0][0] - this.shiftBuffer[1][0] < adjustedIndex) {
                            adjustedIndex += this.shiftBuffer[2][0];
                            previousIndex = 0;
                        } else {
                            done = true;
                        }
                    } else if (this.currentBufferSize > -searchIndex - 1 && this.shiftBuffer[0][-searchIndex - 1] - this.shiftBuffer[2][-searchIndex - 1] < adjustedIndex) {
                        adjustedIndex += this.shiftBuffer[2][-searchIndex - 1];
                        previousIndex = -searchIndex - 1;
                    } else {
                        adjustedIndex += this.shiftBuffer[2][-searchIndex - 2];
                        done = true;
                    }
                    firstPass = false;
                    continue;
                }
                if (searchIndex >= 0) {
                    for (i = previousIndex + 1; i <= searchIndex; ++i) {
                        adjustedIndex += this.shiftBuffer[1][i];
                    }
                    previousIndex = searchIndex;
                    continue;
                }
                for (i = previousIndex + 1; i < -searchIndex - 1; ++i) {
                    adjustedIndex += this.shiftBuffer[1][i];
                }
                if (this.currentBufferSize > -searchIndex - 1 && this.shiftBuffer[0][-searchIndex - 1] - this.shiftBuffer[1][-searchIndex - 1] < adjustedIndex) {
                    adjustedIndex += this.shiftBuffer[1][-searchIndex - 1];
                    previousIndex = -searchIndex - 1;
                    continue;
                }
                done = true;
            }
        }
        return adjustedIndex;
    }

    protected void addShift(long position, long shift) {
        int searchIndex;
        if (shift == 0L) {
            throw new IllegalArgumentException("Shift cannot be zero");
        }
        if (this.currentBufferSize < this.shiftBuffer[0].length) {
            searchIndex = Arrays.binarySearch(this.shiftBuffer[0], 0, this.currentBufferSize, position);
            if (searchIndex >= 0) {
                this.shiftBuffer[1][searchIndex] = this.shiftBuffer[1][searchIndex] + shift;
            } else {
                searchIndex = searchIndex * -1 - 1;
                for (int i = this.currentBufferSize; i > searchIndex; --i) {
                    this.shiftBuffer[0][i] = this.shiftBuffer[0][i - 1];
                    this.shiftBuffer[1][i] = this.shiftBuffer[1][i - 1];
                }
                this.shiftBuffer[0][searchIndex] = position;
                this.shiftBuffer[1][searchIndex] = shift;
                ++this.currentBufferSize;
            }
        } else {
            throw new BufferOverflowException();
        }
        this.updateShifts(searchIndex, this.currentBufferSize);
    }

    private void updateShifts(int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            this.shiftBuffer[2][i] = i == 0 ? this.shiftBuffer[1][i] : this.shiftBuffer[1][i] + this.shiftBuffer[2][i - 1];
        }
    }

    protected long getCurrentShiftAmount(long indexNumber) {
        int searchIndex = Arrays.binarySearch(this.shiftBuffer[0], 0, this.currentBufferSize, indexNumber);
        if (searchIndex == -1) {
            return 0L;
        }
        return this.shiftBuffer[1][searchIndex];
    }

    protected void removeShift(long indexNumber) {
        int searchIndex = Arrays.binarySearch(this.shiftBuffer[0], 0, this.currentBufferSize, indexNumber);
        long shiftAmount = this.shiftBuffer[1][searchIndex];
        for (int i = searchIndex; i < this.currentBufferSize; ++i) {
            this.shiftBuffer[0][i] = this.shiftBuffer[0][i + 1];
            this.shiftBuffer[1][i] = this.shiftBuffer[1][i + 1];
            this.shiftBuffer[2][i] = this.shiftBuffer[2][i + 1] - shiftAmount;
        }
        --this.currentBufferSize;
    }

    protected void removeAllShifts() {
        for (int i = 0; i < this.currentBufferSize; ++i) {
            this.shiftBuffer[0][i] = 0L;
            this.shiftBuffer[1][i] = 0L;
            this.shiftBuffer[2][i] = 0L;
        }
        this.currentBufferSize = 0;
    }

    protected boolean isBufferFull() {
        boolean full = false;
        if (this.currentBufferSize >= this.shiftBuffer[0].length) {
            full = true;
        }
        return full;
    }

    protected boolean isShiftMaxed() {
        boolean maxed = false;
        if (this.currentBufferSize > 0 && this.shiftBuffer[2][this.currentBufferSize - 1] >= 10000L) {
            maxed = true;
        }
        return maxed;
    }
}

