/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.mctcommon;

import com.minecrafttas.mctcommon.ConfigurationRegistry;
import com.minecrafttas.mctcommon.MCTCommon;
import com.minecrafttas.mctcommon.file.AbstractDataFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;

public class Configuration
extends AbstractDataFile {
    private ConfigurationRegistry registry;

    public Configuration(String comment, Path configFile, ConfigurationRegistry registry) {
        super(configFile, "config", comment);
        this.registry = registry;
    }

    @Override
    public void load() {
        if (Files.exists(this.file, new LinkOption[0])) {
            String in = null;
            try {
                in = this.readFile(this.file);
            }
            catch (IOException e) {
                MCTCommon.LOGGER.catching((Throwable)e);
                return;
            }
            if (in.startsWith("<?xml")) {
                MCTCommon.LOGGER.warn("Converting xml config to json");
                this.loadFromXML();
                return;
            }
            this.loadFromJson(this.file);
        }
        if (this.properties == null || !Files.exists(this.file, new LinkOption[0])) {
            this.properties = this.generateDefault();
            this.saveToJson();
        }
    }

    @Override
    public void save() {
        super.saveToJson();
    }

    public Properties generateDefault() {
        Properties newProperties = new Properties();
        this.registry.getConfigRegistry().forEach(configOption -> newProperties.put(configOption.getConfigKey(), configOption.getDefaultValue()));
        return newProperties;
    }

    public String get(ConfigurationRegistry.ConfigOptions configOption) {
        return this.properties.getProperty(configOption.getConfigKey(), configOption.getDefaultValue());
    }

    public int getInt(ConfigurationRegistry.ConfigOptions configOption) {
        return Integer.parseInt(this.get(configOption));
    }

    public boolean getBoolean(ConfigurationRegistry.ConfigOptions configOption) {
        return Boolean.parseBoolean(this.get(configOption));
    }

    public boolean has(ConfigurationRegistry.ConfigOptions configOption) {
        return this.properties.contains(configOption.getConfigKey());
    }

    public void set(ConfigurationRegistry.ConfigOptions configOption, String value) {
        if (this.properties == null) {
            throw new NullPointerException("Config needs to be loaded first, before trying to set a value");
        }
        this.properties.setProperty(configOption.getConfigKey(), value);
        this.save();
    }

    public void set(ConfigurationRegistry.ConfigOptions configOption, int value) {
        String val = Integer.toString(value);
        this.set(configOption, val);
    }

    public void set(ConfigurationRegistry.ConfigOptions configOption, boolean value) {
        String val = Boolean.toString(value);
        this.set(configOption, val);
    }

    public void reset(ConfigurationRegistry.ConfigOptions configOption) {
        this.set(configOption, configOption.getDefaultValue());
    }

    public void delete(ConfigurationRegistry.ConfigOptions configOption) {
        this.properties.remove(configOption);
        this.saveToJson();
    }
}

