/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.mctcommon;

import com.minecrafttas.mctcommon.events.EventClient;
import com.minecrafttas.mctcommon.mixin.AccessorKeyBinding;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1600;
import net.minecraft.class_327;
import net.minecraft.class_347;
import org.apache.commons.lang3.ArrayUtils;

public class KeybindManager
implements EventClient.EventClientGameLoop {
    private final IsKeyDownFunc defaultFunction;
    private Map<KeybindID, Keybind> keybindings;

    public KeybindManager(IsKeyDownFunc defaultFunction) {
        this.defaultFunction = defaultFunction;
        this.keybindings = new HashMap<KeybindID, Keybind>();
    }

    @Override
    public void onRunClientGameLoop(class_1600 mc) {
        for (Keybind keybind : this.keybindings.values()) {
            IsKeyDownFunc keyDown = keybind.isKeyDownFunc != null ? keybind.isKeyDownFunc : this.defaultFunction;
            if (!keyDown.isKeyDown(keybind.vanillaKeyBinding)) continue;
            keybind.onKeyDown.run();
        }
    }

    public void registerKeybinds(class_347 options, Class<? extends KeybindID> keybindIDclass) {
        if (keybindIDclass.isEnum()) {
            this.registerKeybinds(options, keybindIDclass.getEnumConstants());
        }
    }

    public void registerKeybinds(class_347 options, KeybindID ... keybind) {
        for (KeybindID keybindEnum : keybind) {
            this.registerKeybind(options, keybindEnum, keybindEnum.getKeybind());
        }
    }

    public void registerKeybind(class_347 options, KeybindID keybindID, Keybind keybind) {
        this.keybindings.put(keybindID, keybind);
        class_327 keyBinding = keybind.vanillaKeyBinding;
        Map<String, Integer> categoryOrder = AccessorKeyBinding.getCategoryOrder();
        if (!categoryOrder.containsKey(keybind.category)) {
            categoryOrder.put(keybind.category, categoryOrder.size() + 1);
        }
        options.field_945 = (class_327[])ArrayUtils.add((Object[])options.field_945, (Object)keyBinding);
    }

    public Keybind getKeybind(KeybindID id) {
        return this.keybindings.get(id);
    }

    @FunctionalInterface
    public static interface IsKeyDownFunc {
        public boolean isKeyDown(class_327 var1);
    }

    public static class Keybind {
        public final class_327 vanillaKeyBinding;
        private final String category;
        private final Runnable onKeyDown;
        private final IsKeyDownFunc isKeyDownFunc;

        public Keybind(String name, String category, int defaultKey, Runnable onKeyDown) {
            this(name, category, defaultKey, onKeyDown, null);
        }

        public Keybind(String name, String category, int defaultKey, Runnable onKeyDown, IsKeyDownFunc func) {
            this.vanillaKeyBinding = new class_327(name, defaultKey, category);
            this.category = category;
            this.onKeyDown = onKeyDown;
            this.isKeyDownFunc = func;
        }

        public String toString() {
            return this.vanillaKeyBinding.method_6621();
        }
    }

    public static interface KeybindID {
        public Keybind getKeybind();
    }
}

