/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.mctcommon;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_1652;
import net.minecraft.class_1653;
import net.minecraft.class_1654;
import org.apache.commons.io.IOUtils;

public class LanguageManager {
    private static Set<String> modids = new HashSet<String>();
    private static final Splitter SPLITTER = Splitter.on((char)'=').limit(2);
    private static final Pattern PATTERN = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");

    public static void onResourceManagerReload(Map<String, String> original, class_1654 iResourceManager, List<String> languageList) {
        for (String language : languageList) {
            language = language.toLowerCase();
            for (String modid : modids) {
                HashMap<Object, Object> newTranslations = new HashMap();
                if (iResourceManager.method_5892().contains(modid)) {
                    try {
                        newTranslations = LanguageManager.getFromResourcePack(iResourceManager, modid, language);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (newTranslations.isEmpty()) {
                    try {
                        newTranslations = LanguageManager.loadLang(LanguageManager.getFromResources(modid, language, "lang"));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (newTranslations.isEmpty()) {
                    newTranslations = LanguageManager.loadJson(LanguageManager.getFromResources(modid, language, "json"));
                }
                newTranslations.forEach(original::putIfAbsent);
            }
        }
    }

    private static InputStream getFromResources(String resourceDomain, String language, String fileending) {
        return LanguageManager.class.getResourceAsStream(String.format("/assets/%s/lang/%s.%s", resourceDomain, language, fileending));
    }

    private static HashMap<String, String> getFromResourcePack(class_1654 iResourceManager, String resourceDomain, String language) throws IOException {
        String languageFile = String.format("lang/%s.json", language);
        HashMap<String, String> out = new HashMap<String, String>();
        List allResources = iResourceManager.method_5894(new class_1653(resourceDomain, languageFile));
        for (class_1652 iResource : allResources) {
            InputStream inputStream = iResource.method_5888();
            out.putAll(LanguageManager.loadJson(inputStream));
        }
        return out;
    }

    public static void registerMod(String modid) {
        modids.add(modid);
    }

    private static HashMap<String, String> loadJson(InputStream inputStream) {
        if (inputStream == null) {
            return new HashMap<String, String>();
        }
        Gson gson = new Gson();
        HashMap template = new HashMap();
        HashMap out = (HashMap)gson.fromJson((Reader)new InputStreamReader(inputStream), template.getClass());
        out.forEach((key, value) -> {
            value = PATTERN.matcher((CharSequence)value).replaceAll("%$1s");
        });
        return out;
    }

    private static HashMap<String, String> loadLang(InputStream inputStream) throws IOException {
        HashMap<String, String> out = new HashMap<String, String>();
        if (inputStream == null) {
            return out;
        }
        for (String string : IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8)) {
            String[] key_value_pair;
            if (string.isEmpty() || string.charAt(0) == '#' || (key_value_pair = (String[])Iterables.toArray((Iterable)SPLITTER.split((CharSequence)string), String.class)) == null || key_value_pair.length != 2) continue;
            String key = key_value_pair[0];
            String value = PATTERN.matcher(key_value_pair[1]).replaceAll("%$1s");
            out.put(key, value);
        }
        return out;
    }
}

