/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.mctcommon.events;

import com.minecrafttas.mctcommon.events.EventException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;

public class EventListenerRegistry {
    private static final HashMap<Class<?>, ArrayList<EventBase>> EVENTLISTENER_REGISTRY = new HashMap();

    public static void register(EventBase eventListener) {
        if (eventListener == null) {
            throw new NullPointerException("Tried to register a packethandler with value null");
        }
        for (Class<?> type : EventListenerRegistry.searchForInterfaces(eventListener.getClass())) {
            if (!EventBase.class.isAssignableFrom(type)) continue;
            ArrayList<EventBase> registryList = EVENTLISTENER_REGISTRY.putIfAbsent(type, new ArrayList());
            if (registryList == null) {
                registryList = EVENTLISTENER_REGISTRY.get(type);
            }
            registryList.add(eventListener);
        }
    }

    private static Class<?>[] searchForInterfaces(Class<?> clazz) {
        if (clazz == null) {
            return new Class[0];
        }
        Object[] interfaces = clazz.getInterfaces();
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            interfaces = (Class[])ArrayUtils.addAll((Object[])interfaces, (Object[])EventListenerRegistry.searchForInterfaces(superclass));
        }
        return interfaces;
    }

    public static void register(EventBase ... eventListeners) {
        for (EventBase eventListener : eventListeners) {
            EventListenerRegistry.register(eventListener);
        }
    }

    public static void register(List<? extends EventBase> eventListeners) {
        for (EventBase eventBase : eventListeners) {
            EventListenerRegistry.register(eventBase);
        }
    }

    public static void unregister(EventBase eventListener) {
        if (eventListener == null) {
            throw new NullPointerException("Tried to unregister a packethandler with value null");
        }
        for (Class<?> type : EventListenerRegistry.searchForInterfaces(eventListener.getClass())) {
            ArrayList<EventBase> registryList;
            if (!EventBase.class.isAssignableFrom(type) || (registryList = EVENTLISTENER_REGISTRY.get(type)) == null) continue;
            registryList.remove(eventListener);
            if (!registryList.isEmpty()) continue;
            EVENTLISTENER_REGISTRY.remove(type);
        }
    }

    public static void unregister(EventBase ... eventListeners) {
        for (EventBase eventListener : eventListeners) {
            EventListenerRegistry.unregister(eventListener);
        }
    }

    public static void unregister(List<? extends EventBase> eventListeners) {
        for (EventBase eventBase : eventListeners) {
            EventListenerRegistry.unregister(eventBase);
        }
    }

    public static Object fireEvent(Class<? extends EventBase> eventClass) {
        return EventListenerRegistry.fireEvent(eventClass, new Object[0]);
    }

    public static Object fireEvent(Class<? extends EventBase> eventClass, Object ... eventParams) {
        ArrayList<EventBase> listenerList = EVENTLISTENER_REGISTRY.get(eventClass);
        if (listenerList == null) {
            return null;
        }
        EventException toThrow = null;
        Method methodToFind = EventListenerRegistry.getEventMethod(eventClass);
        Object returnValue = null;
        for (EventBase eventListener : listenerList) {
            Method[] methodsInListener;
            for (Method method : methodsInListener = eventListener.getClass().getDeclaredMethods()) {
                if (!EventListenerRegistry.checkName(method, methodToFind.getName())) continue;
                if (!EventListenerRegistry.checkLength(method, eventParams)) {
                    toThrow = new EventException(String.format("Event fired with the wrong number of parameters. Expected: %s, Actual: %s", method.getParameterCount(), eventParams.length), eventClass);
                    continue;
                }
                if (EventListenerRegistry.checkTypes(method, eventParams)) {
                    toThrow = null;
                    method.setAccessible(true);
                    try {
                        Object newReturnValue = method.invoke((Object)eventListener, eventParams);
                        if (newReturnValue == null) continue;
                        returnValue = newReturnValue;
                        continue;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new EventException(eventClass, e.getCause());
                    }
                    catch (IllegalArgumentException e) {
                        throw new EventException(String.format("Event fired with the wrong number of parameters. Expected: %s, Actual: %s", method.getParameterCount(), eventParams.length), eventClass, e);
                    }
                }
                toThrow = new EventException("Event seems to be fired with the wrong parameter types or in the wrong order", eventClass);
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
        return returnValue;
    }

    private static Method getEventMethod(Class<? extends EventBase> eventClass) {
        Method[] test = eventClass.getDeclaredMethods();
        if (test.length != 1) {
            throw new EventException("The event method is not properly defined. Only one method is allowed inside of an event", eventClass);
        }
        return test[0];
    }

    private static boolean checkName(Method method, String name) {
        return method.getName().equals(name);
    }

    private static boolean checkLength(Method method, Object ... parameters) {
        return method.getParameterCount() == parameters.length;
    }

    private static boolean checkTypes(Method method, Object ... parameters) {
        Class[] methodParameterTypes = ClassUtils.primitivesToWrappers((Class[])method.getParameterTypes());
        Class<?>[] eventParameterTypes = EventListenerRegistry.getParameterTypes(parameters);
        for (int i = 0; i < methodParameterTypes.length; ++i) {
            Class paramName = methodParameterTypes[i];
            Class<?> eventName = eventParameterTypes[i];
            if (paramName.equals(eventName) || paramName == null || eventName == null || paramName.isAssignableFrom(eventName)) continue;
            return false;
        }
        return true;
    }

    private static Class<?>[] getParameterTypes(Object ... parameters) {
        Class[] out = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            out[i] = parameters[i] == null ? null : parameters[i].getClass();
        }
        return out;
    }

    public static void clear() {
        EVENTLISTENER_REGISTRY.clear();
    }

    public static interface EventBase {
    }
}

