/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.mctcommon.file;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.minecrafttas.mctcommon.MCTCommon;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public abstract class AbstractDataFile {
    protected final Path file;
    protected final String name;
    protected final String comment;
    protected Properties properties;

    protected AbstractDataFile(Path file, String name, String comment) {
        this.file = file;
        this.name = name;
        this.comment = comment;
        this.properties = new Properties();
    }

    public static void createDirectory(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0]) && !Files.isDirectory(directory, new LinkOption[0])) {
            Files.delete(directory);
        }
        Files.createDirectories(directory, new FileAttribute[0]);
    }

    public void save() {
        this.saveToProperties();
    }

    public void save(Path file) {
        this.saveToProperties(file);
    }

    protected void saveToProperties() {
        this.saveToProperties(this.file);
    }

    protected void saveToProperties(Path file) {
        try {
            AbstractDataFile.createDirectory(file.getParent());
        }
        catch (IOException e) {
            MCTCommon.LOGGER.catching((Throwable)e);
        }
        try {
            OutputStream fos = Files.newOutputStream(file, new OpenOption[0]);
            this.properties.store(fos, this.comment);
            fos.close();
        }
        catch (IOException e) {
            MCTCommon.LOGGER.catching((Throwable)e);
        }
    }

    protected void saveToXML() {
        this.saveToXML(this.file);
    }

    protected void saveToXML(Path file) {
        try {
            AbstractDataFile.createDirectory(file.getParent());
        }
        catch (IOException e) {
            MCTCommon.LOGGER.catching((Throwable)e);
        }
        try {
            OutputStream fos = Files.newOutputStream(file, new OpenOption[0]);
            this.properties.storeToXML(fos, this.comment, "UTF-8");
            fos.close();
        }
        catch (IOException e) {
            MCTCommon.LOGGER.catching((Throwable)e);
        }
    }

    protected void saveToJson() {
        this.saveToJson(this.file);
    }

    protected void saveToJson(Path file) {
        try {
            AbstractDataFile.createDirectory(file.getParent());
        }
        catch (IOException e) {
            MCTCommon.LOGGER.catching((Throwable)e);
        }
        Gson json = new GsonBuilder().registerTypeAdapter(Properties.class, (Object)new PropertiesSerializer()).setPrettyPrinting().create();
        try {
            String element = json.toJson((Object)this.properties);
            element = String.format("// %s\n", this.comment) + element;
            Files.write(file, element.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            MCTCommon.LOGGER.catching((Throwable)e);
        }
    }

    public void load() {
        this.loadFromProperties();
    }

    public void load(Path file) {
        this.loadFromProperties(file);
    }

    protected void loadFromProperties() {
        if (Files.exists(this.file, new LinkOption[0])) {
            this.loadFromProperties(this.file);
        }
    }

    protected void loadFromProperties(Path file) {
        Properties newProp = new Properties();
        try {
            InputStream fis = Files.newInputStream(file, new OpenOption[0]);
            newProp.load(fis);
            fis.close();
        }
        catch (InvalidPropertiesFormatException e) {
            MCTCommon.LOGGER.error("The {} file could not be read", (Object)this.name, (Object)e);
            return;
        }
        catch (FileNotFoundException e) {
            MCTCommon.LOGGER.warn("No {} file found: {}", (Object)this.name, (Object)file);
            return;
        }
        catch (IOException e) {
            MCTCommon.LOGGER.error("An error occured while reading the {} file", (Object)file, (Object)e);
            return;
        }
        this.properties = newProp;
    }

    protected void loadFromXML() {
        if (Files.exists(this.file, new LinkOption[0])) {
            this.loadFromXML(this.file);
        }
    }

    protected void loadFromXML(Path file) {
        Properties newProp = new Properties();
        try {
            InputStream fis = Files.newInputStream(file, new OpenOption[0]);
            newProp.loadFromXML(fis);
            fis.close();
        }
        catch (InvalidPropertiesFormatException e) {
            MCTCommon.LOGGER.error("The {} file could not be read", (Object)this.name, (Object)e);
            return;
        }
        catch (FileNotFoundException e) {
            MCTCommon.LOGGER.warn("No {} file found: {}", (Object)this.name, (Object)file);
            return;
        }
        catch (IOException e) {
            MCTCommon.LOGGER.error("An error occured while reading the {} file", (Object)file, (Object)e);
            return;
        }
        this.properties = newProp;
    }

    protected void loadFromJson() {
        this.loadFromJson(this.file);
    }

    protected void loadFromJson(Path file) {
        String in;
        Gson json = new GsonBuilder().registerTypeAdapter(Properties.class, (Object)new PropertiesDeserializer()).create();
        try {
            in = this.readFile(file);
        }
        catch (IOException e) {
            MCTCommon.LOGGER.catching((Throwable)e);
            return;
        }
        this.properties = (Properties)json.fromJson(in, Properties.class);
    }

    protected String readFile(Path file) throws IOException {
        return new String(Files.readAllBytes(file));
    }

    private class PropertiesSerializer
    implements JsonSerializer<Properties> {
        private PropertiesSerializer() {
        }

        public JsonElement serialize(Properties src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            src.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> obj.addProperty((String)key, (String)val)));
            return obj;
        }
    }

    private class PropertiesDeserializer
    implements JsonDeserializer<Properties> {
        private PropertiesDeserializer() {
        }

        public Properties deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Properties properties = new Properties();
            JsonObject obj = json.getAsJsonObject();
            for (Map.Entry elem : obj.entrySet()) {
                String key = (String)elem.getKey();
                String val = ((JsonElement)elem.getValue()).getAsString();
                properties.put(key, val);
            }
            return properties;
        }
    }
}

