/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.mctcommon.networking;

import com.minecrafttas.mctcommon.networking.SecureList;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.UUID;

public class ByteBufferBuilder {
    private int bufferIndex;
    protected ByteBuffer buffer;
    private PacketID bufferPacketId;
    private ArrayList<String> bufferContent = new ArrayList();

    public ByteBufferBuilder(int id) {
        this.bufferIndex = SecureList.POOL.available();
        this.buffer = SecureList.POOL.lock(this.bufferIndex);
        this.buffer.putInt(id);
    }

    public ByteBufferBuilder(PacketID packet) {
        this(packet.getID());
        this.bufferPacketId = packet;
    }

    public ByteBufferBuilder(ByteBuffer buf) {
        this.bufferIndex = SecureList.POOL.available();
        this.buffer = SecureList.POOL.lock(this.bufferIndex);
        this.buffer.put(buf);
    }

    private ByteBufferBuilder(int bufferIndex, ByteBuffer buffer, PacketID bufferName, ArrayList<String> bufferContent) {
        this.bufferIndex = bufferIndex;
        this.buffer = buffer;
        this.bufferPacketId = bufferName;
        this.bufferContent = new ArrayList<String>(bufferContent);
    }

    public ByteBuffer build() {
        if (this.buffer == null) {
            throw new IllegalStateException("This buffer is already closed");
        }
        return this.buffer;
    }

    public ByteBufferBuilder writeInt(int value) {
        if (this.buffer == null) {
            throw new IllegalStateException("This buffer is already closed");
        }
        this.buffer.putInt(value);
        this.bufferContent.add("int " + value);
        return this;
    }

    public ByteBufferBuilder writeDouble(double value) {
        if (this.buffer == null) {
            throw new IllegalStateException("This buffer is already closed");
        }
        this.buffer.putDouble(value);
        this.bufferContent.add("double " + value);
        return this;
    }

    public ByteBufferBuilder writeFloat(float value) {
        if (this.buffer == null) {
            throw new IllegalStateException("This buffer is already closed");
        }
        this.buffer.putFloat(value);
        this.bufferContent.add("float " + value);
        return this;
    }

    public ByteBufferBuilder writeLong(long value) {
        if (this.buffer == null) {
            throw new IllegalStateException("This buffer is already closed");
        }
        this.buffer.putLong(value);
        this.bufferContent.add("long " + value);
        return this;
    }

    public ByteBufferBuilder writeShort(short value) {
        if (this.buffer == null) {
            throw new IllegalStateException("This buffer is already closed");
        }
        this.buffer.putShort(value);
        this.bufferContent.add("short " + value);
        return this;
    }

    public ByteBufferBuilder writeBoolean(boolean value) {
        if (this.buffer == null) {
            throw new IllegalStateException("This buffer is already closed");
        }
        this.buffer.put((byte)(value ? 1 : 0));
        this.bufferContent.add("boolean " + value);
        return this;
    }

    public ByteBufferBuilder writeString(String value) {
        if (this.buffer == null) {
            throw new IllegalStateException("This buffer is already closed");
        }
        byte[] stringbytes = value.getBytes();
        this.buffer.putInt(stringbytes.length);
        this.buffer.put(stringbytes);
        this.bufferContent.add("String " + value);
        return this;
    }

    public ByteBufferBuilder writeUUID(UUID uuid) {
        if (this.buffer == null) {
            throw new IllegalStateException("This buffer is already closed");
        }
        this.buffer.putLong(uuid.getMostSignificantBits());
        this.buffer.putLong(uuid.getLeastSignificantBits());
        this.bufferContent.add("UUID " + uuid);
        return this;
    }

    public ByteBufferBuilder writeByteArray(byte[] value) {
        this.buffer.putInt(value.length);
        this.buffer.put(value);
        this.bufferContent.add("ByteArray length(" + value.length + ")");
        return this;
    }

    public ByteBufferBuilder writeEnum(Enum<?> state) {
        this.writeShort((short)state.ordinal());
        return this;
    }

    public void close() {
        if (this.buffer != null) {
            SecureList.POOL.unlock(this.bufferIndex);
            this.buffer = null;
        }
    }

    public ByteBufferBuilder clone() throws CloneNotSupportedException {
        int current = this.buffer.position();
        int sid = SecureList.POOL.available();
        ByteBuffer clone = SecureList.POOL.lock(sid);
        this.buffer.limit(current).position(0);
        clone.put(this.buffer);
        this.buffer.position(current);
        return new ByteBufferBuilder(sid, clone, this.bufferPacketId, this.bufferContent);
    }

    public static int readInt(ByteBuffer buf) {
        return buf.getInt();
    }

    public static double readDouble(ByteBuffer buf) {
        return buf.getDouble();
    }

    public static float readFloat(ByteBuffer buf) {
        return buf.getFloat();
    }

    public static long readLong(ByteBuffer buf) {
        return buf.getLong();
    }

    public static short readShort(ByteBuffer buf) {
        return buf.getShort();
    }

    public static boolean readBoolean(ByteBuffer buf) {
        return buf.get() == 1;
    }

    public static UUID readUUID(ByteBuffer buf) {
        return new UUID(buf.getLong(), buf.getLong());
    }

    public static String readString(ByteBuffer buf) {
        byte[] nameBytes = new byte[buf.getInt()];
        buf.get(nameBytes);
        return new String(nameBytes);
    }

    public static byte[] readByteArray(ByteBuffer buf) {
        int length = buf.getInt();
        byte[] array = new byte[length];
        buf.get(array);
        return array;
    }

    public static <T extends Enum<?>> T readEnum(Class<T> clazz, ByteBuffer buf) {
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException("Class is not an enum");
        }
        return (T)((Enum[])clazz.getEnumConstants())[buf.getShort()];
    }

    public PacketID getPacketID() {
        return this.bufferPacketId;
    }

    public String getPacketContent() {
        return String.join((CharSequence)"\n", this.bufferContent);
    }

    public String toString() {
        return this.getPacketID().getName() + this.getPacketContent();
    }
}

