/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.mctcommon.networking;

import com.minecrafttas.mctcommon.MCTCommon;
import com.minecrafttas.mctcommon.events.EventClient;
import com.minecrafttas.mctcommon.events.EventListenerRegistry;
import com.minecrafttas.mctcommon.events.EventServer;
import com.minecrafttas.mctcommon.networking.ByteBufferBuilder;
import com.minecrafttas.mctcommon.networking.PacketHandlerRegistry;
import com.minecrafttas.mctcommon.networking.exception.InvalidPacketException;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;

public class Client {
    private final AsynchronousSocketChannel socket;
    private final PacketID[] packetIDs;
    private final ByteBuffer writeBuffer = ByteBuffer.allocate(20000);
    private final ByteBuffer readBuffer = ByteBuffer.allocate(20000);
    private Future<Integer> future;
    private String username;
    private String ip;
    private int port;
    private Side side;
    private ClientCallback callback;
    private boolean local = false;

    public Client(String host, int port, PacketID[] packetIDs, String name, boolean local) throws Exception {
        MCTCommon.LOGGER.info(MCTCommon.Client, "Connecting server to {}:{}", (Object)host, (Object)port);
        this.socket = AsynchronousSocketChannel.open();
        this.socket.connect(new InetSocketAddress(host, port)).get(2L, TimeUnit.SECONDS);
        this.socket.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
        this.socket.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        this.ip = host;
        this.port = port;
        this.side = Side.CLIENT;
        this.packetIDs = packetIDs;
        this.createHandlers();
        this.callback = client -> EventListenerRegistry.fireEvent(EventClient.EventDisconnectClient.class, client);
        this.local = local;
        MCTCommon.LOGGER.info(MCTCommon.Client, "Connected to server");
        this.username = name;
        this.authenticate(name);
    }

    public Client(AsynchronousSocketChannel socket, PacketID[] packetIDs, ClientCallback callback) {
        this.socket = socket;
        this.callback = callback;
        try {
            this.socket.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            this.socket.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        }
        catch (IOException e) {
            MCTCommon.LOGGER.error(MCTCommon.Server, "Unable to set socket options", (Throwable)e);
        }
        this.packetIDs = packetIDs;
        this.createHandlers();
        this.side = Side.SERVER;
    }

    public void disconnect() {
        if (this.isClosed()) {
            MCTCommon.LOGGER.warn(this.getLoggerMarker(), "Tried to disconnect, but client {} is already closed", (Object)this.getId());
            return;
        }
        try {
            this.send(new ByteBufferBuilder(-2));
        }
        catch (Exception e) {
            MCTCommon.LOGGER.error(this.getLoggerMarker(), "Tried to send disconnect packet, but failed", (Throwable)e);
        }
        try {
            this.close();
        }
        catch (IOException e) {
            MCTCommon.LOGGER.error(this.getLoggerMarker(), "Tried to close socket, but failed", (Throwable)e);
        }
    }

    private void createHandlers() {
        this.readBuffer.limit(4);
        if (this.socket == null || !this.socket.isOpen()) {
            MCTCommon.LOGGER.info(this.getLoggerMarker(), "Connection was closed");
            return;
        }
        this.socket.read(this.readBuffer, null, new CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer result, Object attachment) {
                if (result == -1) {
                    MCTCommon.LOGGER.info(Client.this.getLoggerMarker(), "Stream was closed");
                    return;
                }
                try {
                    Client.this.readBuffer.flip();
                    int lim = Client.this.readBuffer.getInt();
                    Client.this.readBuffer.clear().limit(lim);
                    Client.this.socket.read(Client.this.readBuffer).get();
                    Client.this.readBuffer.position(0);
                    Client.this.handle(Client.this.readBuffer);
                    Client.this.readBuffer.clear().limit(4);
                    Client.this.socket.read(Client.this.readBuffer, null, this);
                }
                catch (Throwable exc) {
                    if (exc instanceof ExecutionException && !Client.this.isClosed()) {
                        MCTCommon.LOGGER.debug(Client.this.getLoggerMarker(), "{} terminated the connection!", (Object)Client.this.getOppositeSide().name());
                        try {
                            Client.this.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    MCTCommon.LOGGER.error(Client.this.getLoggerMarker(), "Unable to read packet!", exc);
                }
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                if (exc instanceof AsynchronousCloseException || exc instanceof IOException) {
                    if (Client.this.isClosed()) {
                        return;
                    }
                    MCTCommon.LOGGER.debug(Client.this.getLoggerMarker(), "{} terminated the connection!", (Object)Client.this.getOppositeSide().name());
                    try {
                        Client.this.close();
                    }
                    catch (IOException e) {
                        MCTCommon.LOGGER.error(Client.this.getLoggerMarker(), "Attempted to close connection but failed", (Throwable)e);
                    }
                } else {
                    if (Client.this.isClosed()) {
                        return;
                    }
                    MCTCommon.LOGGER.error(Client.this.getLoggerMarker(), "Something went wrong, terminating connection!", exc);
                    try {
                        Client.this.close();
                    }
                    catch (IOException e) {
                        MCTCommon.LOGGER.error(Client.this.getLoggerMarker(), "Attempted to close connection but failed", (Throwable)e);
                    }
                }
            }
        });
    }

    public void send(ByteBufferBuilder bufferBuilder) throws Exception {
        if (bufferBuilder.getPacketID() != null && bufferBuilder.getPacketID().shouldTrace()) {
            MCTCommon.LOGGER.trace(this.getLoggerMarker(), "Sending a {} packet to the {} with content:\n{}", (Object)bufferBuilder.getPacketID(), (Object)this.getOppositeSide(), (Object)bufferBuilder.getPacketContent());
        }
        if (this.future != null && !this.future.isDone()) {
            this.future.get();
        }
        ByteBuffer buf = bufferBuilder.build();
        buf.flip();
        this.writeBuffer.clear();
        this.writeBuffer.putInt(buf.limit());
        this.writeBuffer.put(buf);
        this.writeBuffer.flip();
        this.future = this.socket.write(this.writeBuffer);
        bufferBuilder.close();
    }

    private void close() throws IOException {
        if (this.socket == null || !this.socket.isOpen()) {
            MCTCommon.LOGGER.warn(this.getLoggerMarker(), "Tried to close dead socket");
            return;
        }
        this.future = null;
        if (this.callback != null) {
            this.callback.onClose(this);
        }
        this.socket.close();
    }

    private Marker getLoggerMarker() {
        return this.side == Side.CLIENT ? MCTCommon.Client : MCTCommon.Server;
    }

    private Side getOppositeSide() {
        return this.side == Side.CLIENT ? Side.SERVER : Side.CLIENT;
    }

    private void authenticate(String id) throws Exception {
        this.username = id;
        MCTCommon.LOGGER.debug(this.getLoggerMarker(), "Authenticating with UUID {}", (Object)id.toString());
        this.send(new ByteBufferBuilder(-1).writeString(id));
    }

    private void completeAuthentication(ByteBuffer buf) throws Exception {
        if (this.username != null) {
            throw new Exception("The client tried to authenticate while being authenticated already");
        }
        this.username = ByteBufferBuilder.readString(buf);
        MCTCommon.LOGGER.debug(this.getLoggerMarker(), "Completing authentication for user {}", (Object)this.username);
        EventListenerRegistry.fireEvent(EventServer.EventClientCompleteAuthentication.class, this.username);
    }

    private void handle(ByteBuffer buf) {
        int id = buf.getInt();
        try {
            if (id == -1) {
                this.completeAuthentication(buf);
                return;
            }
            if (id == -2) {
                MCTCommon.LOGGER.info(this.getLoggerMarker(), "Disconnected by the {}", (Object)this.getOppositeSide().name());
                this.close();
                return;
            }
            PacketID packet = this.getPacketFromID(id);
            PacketHandlerRegistry.handle(this.side, packet, buf, this.username);
        }
        catch (PacketNotImplementedException | WrongSideException e) {
            MCTCommon.LOGGER.throwing(Level.ERROR, (Throwable)e);
        }
        catch (Exception e) {
            MCTCommon.LOGGER.throwing(Level.ERROR, (Throwable)e);
        }
    }

    public String getId() {
        return this.username;
    }

    private PacketID getPacketFromID(int id) throws InvalidPacketException {
        for (PacketID packet : this.packetIDs) {
            if (packet.getID() != id) continue;
            return packet;
        }
        throw new InvalidPacketException(String.format("Received invalid packet with id %s", id));
    }

    public boolean isClosed() {
        return this.socket == null || !this.socket.isOpen();
    }

    public String getRemote() throws IOException {
        return this.ip + ":" + this.port;
    }

    public boolean isLocal() {
        return this.local;
    }

    public static enum Side {
        CLIENT,
        SERVER;

    }

    @FunctionalInterface
    public static interface ClientCallback {
        public void onClose(Client var1);
    }
}

