/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.mctcommon.networking;

import com.minecrafttas.mctcommon.MCTCommon;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.ClientPacketHandler;
import com.minecrafttas.mctcommon.networking.interfaces.PacketHandlerBase;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class PacketHandlerRegistry {
    private static final List<PacketHandlerBase> REGISTRY = new ArrayList<PacketHandlerBase>();

    public static void register(PacketHandlerBase handler) {
        if (handler == null) {
            throw new NullPointerException("Tried to register a handler with value null");
        }
        if (PacketHandlerRegistry.containsClass(handler)) {
            MCTCommon.LOGGER.warn("Trying to register packet handler {}, but another instance of this class is already registered!", (Object)handler.getClass().getName());
            return;
        }
        if (!REGISTRY.contains(handler)) {
            REGISTRY.add(handler);
        } else {
            MCTCommon.LOGGER.warn("Trying to register packet handler {}, but it is already registered!", (Object)handler.getClass().getName());
        }
    }

    public static void unregister(PacketHandlerBase handler) {
        if (handler == null) {
            throw new NullPointerException("Tried to unregister a handler with value null");
        }
        if (REGISTRY.contains(handler)) {
            REGISTRY.remove(handler);
        } else {
            MCTCommon.LOGGER.warn("Trying to unregister packet handler {}, but it was not registered!", (Object)handler.getClass().getName());
        }
    }

    public static void handle(Client.Side side, PacketID packet, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        if (side != null && side == packet.getSide()) {
            packet.getLambda().onPacket(buf, username);
            return;
        }
        boolean isImplemented = false;
        for (PacketHandlerBase handler : REGISTRY) {
            if (!Arrays.stream(handler.getAcceptedPacketIDs()).anyMatch((Predicate<PacketID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lcom/minecrafttas/mctcommon/networking/interfaces/PacketID;)Z)((PacketID)packet))) continue;
            if (side == Client.Side.CLIENT && handler instanceof ClientPacketHandler) {
                ClientPacketHandler clientHandler = (ClientPacketHandler)handler;
                clientHandler.onClientPacket(packet, buf, username);
                isImplemented = true;
                continue;
            }
            if (side != Client.Side.SERVER || !(handler instanceof ServerPacketHandler)) continue;
            ServerPacketHandler serverHandler = (ServerPacketHandler)handler;
            serverHandler.onServerPacket(packet, buf, username);
            isImplemented = true;
        }
        if (!isImplemented) {
            throw new PacketNotImplementedException(packet, side);
        }
    }

    private static boolean containsClass(PacketHandlerBase handler) {
        for (PacketHandlerBase packethandler : REGISTRY) {
            if (!packethandler.getClass().equals(handler.getClass())) continue;
            return true;
        }
        return false;
    }
}

