/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.mctcommon.networking;

import java.nio.ByteBuffer;

public class SecureList {
    static final int BUFFER_SIZE = 20000;
    static final int BUFFER_COUNT = 100;
    public static SecureList POOL = new SecureList(100, 20000);
    private final ByteBuffer[] buffers;
    private final boolean[] locked;

    public SecureList(int length, int size) {
        this.buffers = new ByteBuffer[length];
        this.locked = new boolean[length];
        for (int i = 0; i < length; ++i) {
            this.buffers[i] = ByteBuffer.allocate(size);
        }
    }

    public int available() {
        for (int i = 0; i < this.locked.length; ++i) {
            if (this.locked[i]) continue;
            return i;
        }
        return -1;
    }

    public ByteBuffer lock(int i) {
        if (this.locked[i]) {
            throw new RuntimeException("Tried to lock already locked buffer");
        }
        this.locked[i] = true;
        return (ByteBuffer)this.buffers[i].clear();
    }

    public void unlock(int index) {
        this.locked[index] = false;
    }
}

