/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.mctcommon.networking;

import com.minecrafttas.mctcommon.MCTCommon;
import com.minecrafttas.mctcommon.events.EventListenerRegistry;
import com.minecrafttas.mctcommon.events.EventServer;
import com.minecrafttas.mctcommon.networking.ByteBufferBuilder;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_988;

public class Server {
    private final AsynchronousServerSocketChannel serverSocket;
    private final List<Client> clients;

    public Server(int port, final PacketID[] packetIDs) throws Exception {
        MCTCommon.LOGGER.info(MCTCommon.Server, "Creating server on port {}", (Object)port);
        this.serverSocket = AsynchronousServerSocketChannel.open();
        this.serverSocket.bind(new InetSocketAddress(port));
        this.clients = new ArrayList<Client>();
        this.serverSocket.accept(null, new CompletionHandler<AsynchronousSocketChannel, Object>(){
            final /* synthetic */ Server this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void completed(AsynchronousSocketChannel clientSocket, Object attachment) {
                Client.ClientCallback callback = client -> {
                    EventListenerRegistry.fireEvent(EventServer.EventDisconnectServer.class, client);
                    this.this$0.clients.remove(client);
                    MCTCommon.LOGGER.debug(MCTCommon.Server, "Disconnecting player from server");
                };
                Client newclient = new Client(clientSocket, packetIDs, callback);
                this.this$0.clients.add(newclient);
                this.this$0.serverSocket.accept(null, this);
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                if (exc instanceof AsynchronousCloseException) {
                    MCTCommon.LOGGER.info(MCTCommon.Server, "Connection to the player was closed!");
                } else {
                    MCTCommon.LOGGER.error(MCTCommon.Server, "Unable to accept client!", exc);
                }
            }
        });
        MCTCommon.LOGGER.info(MCTCommon.Server, "Server created");
    }

    public void sendToAll(ByteBufferBuilder builder) throws Exception {
        for (Client client : this.clients) {
            client.send(builder.clone());
        }
        builder.close();
    }

    public void sendTo(String username, ByteBufferBuilder builder) throws Exception {
        Client client = this.getClient(username);
        if (client != null && !client.isClosed()) {
            client.send(builder);
        } else {
            MCTCommon.LOGGER.warn(MCTCommon.Server, "Buffer with id {} could not be sent to the client {}: The client is closed", (Object)builder.getPacketID(), (Object)username);
            this.removeClient(client);
        }
    }

    public void sendTo(class_988 player, ByteBufferBuilder builder) throws Exception {
        this.sendTo(player.method_2518(), builder);
    }

    public void disconnect(String username) {
        Client client = this.getClient(username);
        client.disconnect();
    }

    public void disconnect(class_988 player) {
        this.disconnect(player.method_2518());
    }

    public void disconnectAll() {
        for (Client client : this.getClients()) {
            client.disconnect();
        }
    }

    public void close() throws IOException {
        if (this.serverSocket == null || !this.serverSocket.isOpen()) {
            MCTCommon.LOGGER.warn(MCTCommon.Server, "Tried to close dead socket on server");
            return;
        }
        this.serverSocket.close();
    }

    public boolean isClosed() {
        return this.serverSocket == null || !this.serverSocket.isOpen();
    }

    private Client getClient(String name) {
        for (Client client : this.clients) {
            if (!client.getId().equals(name)) continue;
            return client;
        }
        return null;
    }

    public List<Client> getClients() {
        return this.clients;
    }

    public AsynchronousServerSocketChannel getAsynchronousSocketChannel() {
        return this.serverSocket;
    }

    private void removeClient(Client client) {
        this.getClients().remove(client);
    }
}

