/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.mctcommon.registry;

import com.minecrafttas.mctcommon.MCTCommon;
import com.minecrafttas.mctcommon.registry.Registerable;
import java.util.Arrays;
import java.util.Map;

public abstract class AbstractRegistry<V extends Registerable> {
    protected final Map<String, V> REGISTRY;
    protected final String name;

    public AbstractRegistry(String name, Map<String, V> map) {
        this.REGISTRY = map;
        this.name = name;
    }

    public void register(V registryObject) {
        if (registryObject == null) {
            throw new NullPointerException("Tried to register an object to " + this.name + " with value null");
        }
        if (this.containsClass(registryObject)) {
            MCTCommon.LOGGER.warn("Trying to register an object in {}, but another instance of this class is already registered: {}", (Object)this.name, (Object)registryObject.getClass().getName());
            return;
        }
        if (this.REGISTRY.containsKey(registryObject.getExtensionName())) {
            MCTCommon.LOGGER.warn("Trying to register the an object in {}, but an extension with the same name is already registered: {}", (Object)registryObject.getExtensionName());
            return;
        }
        this.REGISTRY.put(registryObject.getExtensionName(), registryObject);
    }

    @SafeVarargs
    public final void register(V ... registryObjects) {
        this.register((Iterable<V>)Arrays.asList(registryObjects));
    }

    public final void register(Iterable<V> registryObjects) {
        for (Registerable registryObject : registryObjects) {
            this.register((V)registryObject);
        }
    }

    public void unregister(V registryObject) {
        if (registryObject == null) {
            throw new NullPointerException("Tried to unregister an object from " + this.name + " with value null");
        }
        if (this.REGISTRY.containsKey(registryObject.getExtensionName())) {
            this.REGISTRY.remove(registryObject.getExtensionName());
        } else {
            MCTCommon.LOGGER.warn("Trying to unregister an object from {}, but it was not registered: {}", (Object)this.name, (Object)registryObject.getClass().getName());
        }
    }

    @SafeVarargs
    public final void unregister(V ... registryObjects) {
        this.unregister((Iterable<V>)Arrays.asList(registryObjects));
    }

    public final void unregister(Iterable<V> registryObjects) {
        for (Registerable registryObject : registryObjects) {
            this.unregister((V)registryObject);
        }
    }

    public void clear() {
        this.REGISTRY.clear();
    }

    protected boolean containsClass(V newExtension) {
        return AbstractRegistry.containsClazz(newExtension, this.REGISTRY.values());
    }

    public static <W> boolean containsClazz(W newExtension, Iterable<W> iterable) {
        for (W extension : iterable) {
            if (!extension.getClass().equals(newExtension.getClass())) continue;
            return true;
        }
        return false;
    }
}

