/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod;

import com.minecrafttas.mctcommon.CommandRegistry;
import com.minecrafttas.mctcommon.events.EventListenerRegistry;
import com.minecrafttas.mctcommon.events.EventServer;
import com.minecrafttas.mctcommon.networking.PacketHandlerRegistry;
import com.minecrafttas.mctcommon.networking.Server;
import com.minecrafttas.tasmod.commands.CommandClearInputs;
import com.minecrafttas.tasmod.commands.CommandFileCommand;
import com.minecrafttas.tasmod.commands.CommandFullPlay;
import com.minecrafttas.tasmod.commands.CommandFullRecord;
import com.minecrafttas.tasmod.commands.CommandLoadTAS;
import com.minecrafttas.tasmod.commands.CommandPlay;
import com.minecrafttas.tasmod.commands.CommandPlayUntil;
import com.minecrafttas.tasmod.commands.CommandRecord;
import com.minecrafttas.tasmod.commands.CommandRestartAndPlay;
import com.minecrafttas.tasmod.commands.CommandSaveTAS;
import com.minecrafttas.tasmod.commands.CommandSavestate;
import com.minecrafttas.tasmod.commands.CommandTickrate;
import com.minecrafttas.tasmod.handlers.PlayUntilHandler;
import com.minecrafttas.tasmod.playback.PlaybackControllerServer;
import com.minecrafttas.tasmod.playback.metadata.builtin.StartpositionMetadataExtension;
import com.minecrafttas.tasmod.registries.TASmodAPIRegistry;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.savestates.SavestateHandlerServer;
import com.minecrafttas.tasmod.savestates.handlers.SavestateGuiHandlerServer;
import com.minecrafttas.tasmod.savestates.handlers.SavestateResourcePackHandler;
import com.minecrafttas.tasmod.savestates.storage.builtin.ClientMotionStorage;
import com.minecrafttas.tasmod.tickratechanger.TickrateChangerServer;
import com.minecrafttas.tasmod.ticksync.TickSyncServer;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import com.minecrafttas.tasmod.util.Scheduler;
import com.minecrafttas.tasmod.util.TabCompletionUtils;
import java.io.IOException;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_1007;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TASmod
implements ModInitializer,
EventServer.EventServerInit,
EventServer.EventServerStop {
    public static final Logger LOGGER = LogManager.getLogger((String)"TASmod");
    public static String version = "dev";
    private static MinecraftServer serverInstance;
    public static PlaybackControllerServer playbackControllerServer;
    public static SavestateHandlerServer savestateHandlerServer;
    public static TickrateChangerServer tickratechanger;
    public static TickSyncServer ticksyncServer;
    public static final Scheduler tickSchedulerServer;
    public static final Scheduler gameLoopSchedulerServer;
    public static Server server;
    public static final int networkingport = 8999;
    public static final boolean isDevEnvironment;
    public static final StartpositionMetadataExtension startPositionMetadataExtension;
    public static final TabCompletionUtils tabCompletionUtils;
    public static final CommandFileCommand commandFileCommand;
    public static final PlayUntilHandler playUntil;
    public static ClientMotionStorage motionStorage;

    public void onInitialize() {
        LOGGER.info("Initializing TASmod");
        String modVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("tasmod").get()).getMetadata().getVersion().getFriendlyString();
        if (!"${mod_version}".equals(modVersion)) {
            version = modVersion;
        }
        ticksyncServer = new TickSyncServer();
        LOGGER.info("Testing connection with KillTheRNG");
        tickratechanger = new TickrateChangerServer(LOGGER);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)this);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)ticksyncServer);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)tickratechanger);
        LOGGER.info(LoggerMarkers.Networking, "Registering network handlers");
        PacketHandlerRegistry.register(ticksyncServer);
        PacketHandlerRegistry.register(tickratechanger);
        PacketHandlerRegistry.register(playbackControllerServer);
        PacketHandlerRegistry.register(startPositionMetadataExtension);
        PacketHandlerRegistry.register(tabCompletionUtils);
        PacketHandlerRegistry.register(commandFileCommand);
        PacketHandlerRegistry.register(new SavestateGuiHandlerServer());
        PacketHandlerRegistry.register(motionStorage);
        SavestateResourcePackHandler resourcepackHandler = new SavestateResourcePackHandler();
        PacketHandlerRegistry.register(resourcepackHandler);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)resourcepackHandler);
        PacketHandlerRegistry.register(playUntil);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)playUntil);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)TASmodAPIRegistry.SAVESTATE_STORAGE);
        this.registerSavestateStorage();
    }

    @Override
    public void onServerInit(MinecraftServer server) {
        LOGGER.info("Initializing server");
        serverInstance = server;
        CommandRegistry.registerServerCommand((class_1007)new CommandTickrate(), server);
        CommandRegistry.registerServerCommand((class_1007)new CommandRecord(), server);
        CommandRegistry.registerServerCommand((class_1007)new CommandPlay(), server);
        CommandRegistry.registerServerCommand((class_1007)new CommandSaveTAS(), server);
        CommandRegistry.registerServerCommand((class_1007)new CommandLoadTAS(), server);
        CommandRegistry.registerServerCommand((class_1007)new CommandClearInputs(), server);
        CommandRegistry.registerServerCommand((class_1007)new CommandSavestate(), server);
        CommandRegistry.registerServerCommand((class_1007)new CommandFullRecord(), server);
        CommandRegistry.registerServerCommand((class_1007)new CommandFullPlay(), server);
        CommandRegistry.registerServerCommand((class_1007)new CommandRestartAndPlay(), server);
        CommandRegistry.registerServerCommand((class_1007)new CommandPlayUntil(), server);
        CommandRegistry.registerServerCommand((class_1007)commandFileCommand, server);
        savestateHandlerServer = new SavestateHandlerServer(server, LOGGER);
        PacketHandlerRegistry.register(savestateHandlerServer);
        PacketHandlerRegistry.register(savestateHandlerServer.getPlayerHandler());
        EventListenerRegistry.register((EventListenerRegistry.EventBase)savestateHandlerServer.getSavestateTemporaryHandler());
        if (!server.method_2983()) {
            TASmod.tickratechanger.ticksPerSecond = 0.0f;
            TASmod.tickratechanger.tickrateSaved = 20.0f;
        } else {
            try {
                TASmod.server = new Server(8999, TASmodPackets.values());
            }
            catch (Exception e) {
                LOGGER.error("Unable to launch TASmod server: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void onServerStop(MinecraftServer mcserver) {
        serverInstance = null;
        if (mcserver.method_2983()) {
            try {
                if (server != null) {
                    server.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Unable to close TASmod server: {}", (Throwable)e);
            }
        }
        if (savestateHandlerServer != null) {
            PacketHandlerRegistry.unregister(savestateHandlerServer);
            PacketHandlerRegistry.unregister(savestateHandlerServer.getPlayerHandler());
            EventListenerRegistry.unregister((EventListenerRegistry.EventBase)savestateHandlerServer.getSavestateTemporaryHandler());
            savestateHandlerServer = null;
        }
    }

    private void registerSavestateStorage() {
        TASmodAPIRegistry.SAVESTATE_STORAGE.register(motionStorage);
    }

    public static MinecraftServer getServerInstance() {
        return serverInstance;
    }

    static {
        playbackControllerServer = new PlaybackControllerServer();
        tickSchedulerServer = new Scheduler();
        gameLoopSchedulerServer = new Scheduler();
        isDevEnvironment = FabricLoaderImpl.INSTANCE.isDevelopmentEnvironment();
        startPositionMetadataExtension = new StartpositionMetadataExtension();
        tabCompletionUtils = new TabCompletionUtils();
        commandFileCommand = new CommandFileCommand();
        playUntil = new PlayUntilHandler();
        motionStorage = new ClientMotionStorage();
    }
}

