/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod;

import com.minecrafttas.mctcommon.Configuration;
import com.minecrafttas.mctcommon.ConfigurationRegistry;
import com.minecrafttas.mctcommon.KeybindManager;
import com.minecrafttas.mctcommon.LanguageManager;
import com.minecrafttas.mctcommon.events.EventClient;
import com.minecrafttas.mctcommon.events.EventListenerRegistry;
import com.minecrafttas.mctcommon.file.AbstractDataFile;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.PacketHandlerRegistry;
import com.minecrafttas.mctcommon.networking.Server;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.commands.client.CommandFolder;
import com.minecrafttas.tasmod.gui.InfoHud;
import com.minecrafttas.tasmod.handlers.LoadingScreenHandler;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.playback.filecommands.builtin.DesyncMonitorFileCommandExtension;
import com.minecrafttas.tasmod.playback.filecommands.builtin.LabelFileCommandExtension;
import com.minecrafttas.tasmod.playback.filecommands.builtin.OptionsFileCommandExtension;
import com.minecrafttas.tasmod.playback.metadata.builtin.CreditsMetadataExtension;
import com.minecrafttas.tasmod.playback.metadata.builtin.StartpositionMetadataExtension;
import com.minecrafttas.tasmod.playback.tasfile.flavor.builtin.AlphaFlavor;
import com.minecrafttas.tasmod.playback.tasfile.flavor.builtin.Beta1Flavor;
import com.minecrafttas.tasmod.registries.TASmodAPIRegistry;
import com.minecrafttas.tasmod.registries.TASmodConfig;
import com.minecrafttas.tasmod.registries.TASmodKeybinds;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.savestates.SavestateHandlerClient;
import com.minecrafttas.tasmod.savestates.handlers.SavestateGuiHandlerClient;
import com.minecrafttas.tasmod.savestates.handlers.SavestatePlayerHandlerClient;
import com.minecrafttas.tasmod.tickratechanger.TickrateChangerClient;
import com.minecrafttas.tasmod.ticksync.TickSyncClient;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import com.minecrafttas.tasmod.util.Scheduler;
import com.minecrafttas.tasmod.util.ShieldDownloader;
import com.minecrafttas.tasmod.virtual.VirtualInput;
import com.minecrafttas.tasmod.virtual.VirtualKeybindings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.TimeoutException;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1600;
import net.minecraft.class_347;
import net.minecraft.class_362;
import net.minecraft.class_388;
import net.minecraft.class_485;
import net.minecraft.class_518;
import net.minecraft.class_624;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public class TASmodClient
implements ClientModInitializer,
EventClient.EventClientInit,
EventClient.EventPlayerJoinedClientSide,
EventClient.EventOpenGui,
EventClient.EventOptionsInit {
    public static VirtualInput virtual;
    public static TickSyncClient ticksyncClient;
    public static final Path tasfiledirectory;
    public static final Path savestatedirectory;
    public static InfoHud hud;
    public static ShieldDownloader shieldDownloader;
    public static TickrateChangerClient tickratechanger;
    public static Scheduler gameLoopSchedulerClient;
    public static Scheduler tickSchedulerClient;
    public static Scheduler openMainMenuScheduler;
    public static Configuration config;
    public static LoadingScreenHandler loadingScreenHandler;
    public static KeybindManager keybindManager;
    public static SavestateHandlerClient savestateHandlerClient;
    public static Client client;
    public static CreditsMetadataExtension creditsMetadataExtension;
    public static StartpositionMetadataExtension startpositionMetadataExtension;
    public static PlaybackControllerClient controller;
    boolean waszero;
    boolean isLoading;
    public static Beta1Flavor betaFlavor;
    public static AlphaFlavor alphaFlavor;
    public static DesyncMonitorFileCommandExtension desyncMonitorFileCommandExtension;
    public static OptionsFileCommandExtension optionsFileCommandExtension;
    public static LabelFileCommandExtension labelFileCommandExtension;
    private static final ConfigurationRegistry CONFIG_REGISTRY;

    public static void createTASfileDir() {
        try {
            AbstractDataFile.createDirectory(tasfiledirectory);
        }
        catch (IOException e) {
            TASmod.LOGGER.catching((Throwable)e);
        }
    }

    public static void createSavestatesDir() {
        try {
            AbstractDataFile.createDirectory(savestatedirectory);
        }
        catch (IOException e) {
            TASmod.LOGGER.catching((Throwable)e);
        }
    }

    public void onInitializeClient() {
        LanguageManager.registerMod("tasmod");
        this.createFolders();
        this.registerConfigValues();
        class_1600 mc = class_1600.method_2965();
        this.loadConfig(mc);
        virtual = new VirtualInput(TASmod.LOGGER);
        hud = new InfoHud();
        shieldDownloader = new ShieldDownloader();
        loadingScreenHandler = new LoadingScreenHandler();
        ticksyncClient = new TickSyncClient();
        keybindManager = new KeybindManager(VirtualKeybindings::isKeyDownExceptTextfield);
        desyncMonitorFileCommandExtension = new DesyncMonitorFileCommandExtension();
        optionsFileCommandExtension = new OptionsFileCommandExtension();
        labelFileCommandExtension = new LabelFileCommandExtension();
        TASmodAPIRegistry.CLIENT_COMMANDS.register(new CommandFolder());
        this.registerEventListeners();
        this.registerNetworkPacketHandlers();
        try {
            TASmod.server = new Server(8998, TASmodPackets.values());
        }
        catch (Exception e) {
            TASmod.LOGGER.error("Unable to launch TASmod server: {}", (Object)e.getMessage());
        }
    }

    private void createFolders() {
        TASmodClient.createTASfileDir();
        TASmodClient.createSavestatesDir();
    }

    private void registerNetworkPacketHandlers() {
        TASmod.LOGGER.info(LoggerMarkers.Networking, "Registering network handlers on client");
        PacketHandlerRegistry.register(controller);
        PacketHandlerRegistry.register(ticksyncClient);
        PacketHandlerRegistry.register(tickratechanger);
        PacketHandlerRegistry.register(savestateHandlerClient);
        PacketHandlerRegistry.register(new SavestatePlayerHandlerClient());
        PacketHandlerRegistry.register(new SavestateGuiHandlerClient());
    }

    private void registerEventListeners() {
        EventListenerRegistry.register((EventListenerRegistry.EventBase)this);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)hud);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)shieldDownloader);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)loadingScreenHandler);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)ticksyncClient);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)keybindManager);
        EventListenerRegistry.register(gui -> {
            if (gui instanceof class_624) {
                openMainMenuScheduler.runAllTasks();
            }
            return gui;
        });
        EventListenerRegistry.register((EventListenerRegistry.EventBase)controller);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)creditsMetadataExtension);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)startpositionMetadataExtension);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)desyncMonitorFileCommandExtension);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)TASmodAPIRegistry.PLAYBACK_METADATA);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)TASmodAPIRegistry.PLAYBACK_FILE_COMMAND);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)new LoggerMarkers());
        EventListenerRegistry.register((EventListenerRegistry.EventBase)savestateHandlerClient);
        EventListenerRegistry.register((EventListenerRegistry.EventBase)TASmodClient.virtual.interpolationHandler);
    }

    @Override
    public void onClientInit(class_1600 mc) {
        this.registerPlaybackMetadata(mc);
        this.registerSerialiserFlavors(mc);
        this.registerFileCommands();
    }

    @Override
    public void onPlayerJoinedClientSide(class_518 player) {
        boolean local;
        int port;
        class_1600 mc = class_1600.method_2965();
        class_485 data = mc.method_6625();
        MinecraftServer server = TASmod.getServerInstance();
        String ip = null;
        if (server != null) {
            ip = "localhost";
            port = 8998;
            local = true;
        } else {
            ip = data.field_1687.split(":")[0];
            port = 8999;
            local = false;
        }
        String connectedIP = null;
        try {
            connectedIP = client.getRemote();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!(ip + ":" + port).equals(connectedIP)) {
            try {
                TASmod.LOGGER.info("Closing client connection: {}", (Object)client.getRemote());
                client.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String IP = ip;
            int PORT = port;
            gameLoopSchedulerClient.add(() -> {
                try {
                    client = new Client(IP, PORT, TASmodPackets.values(), mc.method_5568().method_5583(), local);
                }
                catch (TimeoutException e) {
                    mc.method_2960().method_6841().method_7394(null);
                }
                catch (Exception e) {
                    TASmod.LOGGER.error("Unable to connect TASmod client: {}", (Object)e.getMessage());
                    e.printStackTrace();
                }
            });
        }
    }

    @Override
    public class_388 onOpenGui(class_388 gui) {
        if (gui instanceof class_624) {
            this.initializeCustomPacketHandler();
        } else if (gui instanceof class_362) {
            controller.setTASState(PlaybackControllerClient.TASstate.NONE);
            if (TASmodClient.tickratechanger.ticksPerSecond == 0.0f) {
                tickratechanger.pauseClientGame(false);
                this.waszero = true;
            }
        } else if (!(gui instanceof class_362) && this.waszero) {
            this.waszero = false;
            tickratechanger.pauseClientGame(true);
        }
        return gui;
    }

    private void initializeCustomPacketHandler() {
        if (client == null) {
            class_1600 mc = class_1600.method_2965();
            String IP = "localhost";
            int PORT = 8998;
            String configAddress = config.get(TASmodConfig.ServerConnection);
            if (configAddress != null && !configAddress.isEmpty()) {
                String[] ipSplit = configAddress.split(":");
                IP = ipSplit[0];
                try {
                    PORT = Integer.parseInt(ipSplit[1]);
                }
                catch (Exception e) {
                    TASmod.LOGGER.catching(Level.ERROR, (Throwable)e);
                    IP = "localhost";
                    PORT = 8998;
                }
            }
            try {
                client = new Client(IP, PORT, TASmodPackets.values(), mc.method_5568().method_5583(), true);
            }
            catch (Exception e) {
                TASmod.LOGGER.error("Unable to connect TASmod client: {}", (Throwable)e);
            }
        }
    }

    @Override
    public void onOptionsInit(class_347 options) {
        keybindManager.registerKeybinds(options, TASmodKeybinds.class);
        Arrays.stream(TASmodKeybinds.valuesVanillaKeybind()).forEach(VirtualKeybindings::registerBlockedKeyBinding);
    }

    private void registerPlaybackMetadata(class_1600 mc) {
        TASmodAPIRegistry.PLAYBACK_METADATA.register(creditsMetadataExtension);
        TASmodAPIRegistry.PLAYBACK_METADATA.register(startpositionMetadataExtension);
    }

    private void registerSerialiserFlavors(class_1600 mc) {
        TASmodAPIRegistry.SERIALISER_FLAVOR.register(betaFlavor);
        TASmodAPIRegistry.SERIALISER_FLAVOR.register(alphaFlavor);
    }

    private void registerFileCommands() {
        TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.register(desyncMonitorFileCommandExtension);
        TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.register(optionsFileCommandExtension);
        TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.register(labelFileCommandExtension);
        TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.setConfig(config);
    }

    private void registerConfigValues() {
        CONFIG_REGISTRY.register(TASmodConfig.values());
    }

    private void loadConfig(class_1600 mc) {
        Path configDir = mc.field_3762.toPath().resolve("config");
        if (!Files.exists(configDir, new LinkOption[0])) {
            try {
                Files.createDirectory(configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                TASmod.LOGGER.catching((Throwable)e);
            }
        }
        config = new Configuration("TASmod configuration", configDir.resolve("tasmod.cfg"), CONFIG_REGISTRY);
        config.load();
        config.save();
    }

    static {
        tasfiledirectory = class_1600.method_2965().field_3762.toPath().resolve("saves").resolve("tasfiles");
        savestatedirectory = class_1600.method_2965().field_3762.toPath().resolve("saves").resolve("savestates");
        tickratechanger = new TickrateChangerClient();
        gameLoopSchedulerClient = new Scheduler();
        tickSchedulerClient = new Scheduler();
        openMainMenuScheduler = new Scheduler();
        savestateHandlerClient = new SavestateHandlerClient();
        creditsMetadataExtension = new CreditsMetadataExtension();
        startpositionMetadataExtension = new StartpositionMetadataExtension();
        controller = new PlaybackControllerClient();
        betaFlavor = new Beta1Flavor();
        alphaFlavor = new AlphaFlavor();
        CONFIG_REGISTRY = new ConfigurationRegistry();
    }
}

