/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.commands;

import com.minecrafttas.mctcommon.networking.ByteBufferBuilder;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.ClientPacketHandler;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.playback.filecommands.PlaybackFileCommand;
import com.minecrafttas.tasmod.registries.TASmodAPIRegistry;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1061;
import net.minecraft.class_113;
import net.minecraft.class_1442;
import net.minecraft.class_1600;
import net.minecraft.class_1982;
import net.minecraft.class_1989;
import net.minecraft.class_2552;
import net.minecraft.class_3324;
import net.minecraft.class_55;
import net.minecraft.class_955;
import net.minecraft.class_988;
import net.minecraft.server.MinecraftServer;

public class CommandFileCommand
extends class_955
implements ClientPacketHandler,
ServerPacketHandler {
    CompletableFuture<List<String>> fileCommandList = null;

    public String method_3277() {
        return "filecommand";
    }

    public String method_3275(class_1061 iCommandSender) {
        return "/filecommand <filecommandname>";
    }

    public void method_3279(MinecraftServer server, class_1061 sender, String[] args) throws class_55 {
        if (sender instanceof class_988) {
            if (sender.method_3333(2, "fileCommand")) {
                Map<String, Boolean> fileCommandNames;
                String senderName = null;
                try {
                    senderName = CommandFileCommand.method_4638((class_1061)sender).method_2518();
                    fileCommandNames = this.getExtensions(senderName);
                }
                catch (InterruptedException | ExecutionException | TimeoutException | class_113 e) {
                    sender.method_5505((class_1982)new class_1989(e.getMessage()));
                    return;
                }
                if (args.length == 0) {
                    sender.method_5505((class_1982)new class_1989(String.join((CharSequence)" ", this.getColoredNames(fileCommandNames))));
                } else if (args.length == 1) {
                    String name = args[0];
                    Boolean enable = fileCommandNames.get(name);
                    if (enable == null) {
                        throw new class_55("The file command was not found: %s", new Object[]{name});
                    }
                    try {
                        TASmod.server.sendTo(senderName, new TASmodBufferBuilder(TASmodPackets.PLAYBACK_FILECOMMAND_ENABLE).writeString(name).writeBoolean(enable == false));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                sender.method_5505((class_1982)new class_1989(class_1442.field_5495 + "You have no permission to use this command"));
            }
        }
    }

    public List<String> method_10738(MinecraftServer minecraftServer, class_1061 iCommandSender, String[] args, class_2552 blockPos) {
        if (args.length == 1) {
            ArrayList<String> names = null;
            try {
                names = new ArrayList<String>(this.getExtensions(CommandFileCommand.method_4638((class_1061)iCommandSender).method_2518()).keySet());
            }
            catch (InterruptedException | ExecutionException | TimeoutException | class_113 e) {
                e.printStackTrace();
                return super.method_10738(minecraftServer, iCommandSender, args, blockPos);
            }
            return CommandFileCommand.method_10708((String[])args, names);
        }
        return super.method_10738(minecraftServer, iCommandSender, args, blockPos);
    }

    private Map<String, Boolean> getExtensions(String playername) throws InterruptedException, ExecutionException, TimeoutException {
        LinkedHashMap<String, Boolean> out = new LinkedHashMap<String, Boolean>();
        this.fileCommandList = new CompletableFuture();
        try {
            TASmod.server.sendTo(playername, (ByteBufferBuilder)new TASmodBufferBuilder(TASmodPackets.COMMAND_FILECOMMANDLIST));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<String> commands = this.fileCommandList.get(2L, TimeUnit.SECONDS);
        commands.forEach(element -> {
            Pattern pattern = Pattern.compile("^E_");
            Matcher matcher = pattern.matcher((CharSequence)element);
            if (matcher.find()) {
                element = matcher.replaceFirst("");
                out.put((String)element, true);
                return;
            }
            pattern = Pattern.compile("^D_");
            matcher = pattern.matcher((CharSequence)element);
            if (matcher.find()) {
                element = matcher.replaceFirst("");
                out.put((String)element, false);
                return;
            }
        });
        return out;
    }

    private List<String> getColoredNames(Map<String, Boolean> list) {
        ArrayList<String> out = new ArrayList<String>();
        list.forEach((name, enabled) -> out.add(String.format("%s%s%s", enabled != false ? class_1442.field_5493 : class_1442.field_5495, name, class_1442.field_5504)));
        return out;
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new PacketID[]{TASmodPackets.COMMAND_FILECOMMANDLIST, TASmodPackets.PLAYBACK_FILECOMMAND_ENABLE};
    }

    @Override
    public void onServerPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case COMMAND_FILECOMMANDLIST: {
                String filecommandnames = TASmodBufferBuilder.readString(buf);
                this.fileCommandList.complete(Arrays.asList(filecommandnames.split("\\|")));
                break;
            }
            default: {
                throw new WrongSideException(packet, Client.Side.SERVER);
            }
        }
    }

    @Override
    public void onClientPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case COMMAND_FILECOMMANDLIST: {
                String filecommandnames = String.join((CharSequence)"|", this.getFileCommandNames(TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.getAll()));
                TASmodClient.client.send(new TASmodBufferBuilder(TASmodPackets.COMMAND_FILECOMMANDLIST).writeString(filecommandnames));
                break;
            }
            case PLAYBACK_FILECOMMAND_ENABLE: {
                String filecommand = TASmodBufferBuilder.readString(buf);
                boolean enable = TASmodBufferBuilder.readBoolean(buf);
                boolean success = TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.setEnabled(filecommand, enable);
                String msg = success ? String.format("%s%s file command: %s", class_1442.field_5493, enable ? "Enabled" : "Disabled", filecommand) : String.format("%sFailed to %s file command: %s", class_1442.field_5495, enable ? "enable" : "disable", filecommand);
                class_1600.method_2965().field_3820.method_14471(class_3324.field_16256, (class_1982)new class_1989(msg));
                break;
            }
        }
    }

    private List<String> getFileCommandNames(List<PlaybackFileCommand.PlaybackFileCommandExtension> fileCommands) {
        ArrayList<String> out = new ArrayList<String>();
        fileCommands.forEach(element -> out.add(String.format("%s_%s", element.isEnabled() ? "E" : "D", element.toString())));
        return out;
    }
}

