/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.commands;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.savestates.SavestateHandlerServer;
import com.minecrafttas.tasmod.savestates.SavestateIndexer;
import com.minecrafttas.tasmod.savestates.exceptions.LoadstateException;
import com.minecrafttas.tasmod.savestates.exceptions.SavestateDeleteException;
import com.minecrafttas.tasmod.savestates.exceptions.SavestateException;
import com.minecrafttas.tasmod.util.Component;
import com.minecrafttas.tasmod.util.I18n;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import net.minecraft.class_1061;
import net.minecraft.class_1442;
import net.minecraft.class_1600;
import net.minecraft.class_165;
import net.minecraft.class_1980;
import net.minecraft.class_1982;
import net.minecraft.class_1984;
import net.minecraft.class_1989;
import net.minecraft.class_2552;
import net.minecraft.class_55;
import net.minecraft.class_798;
import net.minecraft.class_955;
import net.minecraft.server.MinecraftServer;

public class CommandSavestate
extends class_955 {
    public static boolean once = true;

    public String method_3277() {
        return "savestate";
    }

    public String method_3275(class_1061 sender) {
        return "/savestate save|load|delete|reload|rename|info";
    }

    public int method_4634() {
        return 2;
    }

    public void method_3279(MinecraftServer server, class_1061 sender, String[] args) throws class_55 {
        int length = args.length;
        if (length == 0) {
            this.info(sender);
            return;
        }
        String first = args[0];
        if (this.isNumeric(first)) {
            int index = this.processIndex(first);
            if (length == 1) {
                this.infoIndex(sender, index);
                return;
            }
            String second = args[1];
            int amount = CommandSavestate.method_10701((String)second);
            this.infoIndexAmount(sender, index, amount);
            return;
        }
        if ("save".equals(first)) {
            if (length == 1) {
                this.saveNew(sender);
                return;
            }
            String second = args[1];
            if (this.isNumeric(second)) {
                int index = this.processIndex(second);
                if (length == 2) {
                    this.saveIndex(sender, index);
                    return;
                }
                String third = this.getRestArgsAsString(2, args);
                this.saveIndexName(sender, index, third);
                return;
            }
            second = this.getRestArgsAsString(1, args);
            this.saveName(sender, second);
            return;
        }
        if ("load".equals(first)) {
            if (length == 1) {
                this.loadRecent(sender);
                return;
            }
            String second = args[1];
            int index = this.processIndex(second);
            this.loadIndex(sender, index);
            return;
        }
        if ("delete".equals(first)) {
            if (length == 1) {
                throw new class_165("/savestate delete <indexFrom> [indexTo]", new Object[0]);
            }
            String second = args[1];
            int indexFrom = this.processIndex(second);
            if (length == 2) {
                this.delete(sender, indexFrom);
                return;
            }
            String third = args[2];
            int indexTo = this.processIndex(third);
            if (length == 3) {
                this.deleteMore(sender, indexFrom, indexTo);
                return;
            }
            String fourth = args[3];
            if ("force".equals(fourth)) {
                this.deleteDis(sender, indexFrom, indexTo);
                return;
            }
        } else {
            if ("reload".equals(first)) {
                this.reload(sender);
                return;
            }
            if ("rename".equals(first)) {
                int index = this.processIndex(args[1]);
                String name = this.getRestArgsAsString(2, args);
                this.rename(sender, index, name);
                return;
            }
            if ("info".equals(first)) {
                if (length == 1) {
                    this.info(sender);
                    return;
                }
                String second = args[1];
                if (this.isNumeric(second)) {
                    int index = this.processIndex(second);
                    if (length == 2) {
                        this.infoIndex(sender, index);
                        return;
                    }
                    String third = args[2];
                    int amount = CommandSavestate.method_10701((String)third);
                    this.infoIndexAmount(sender, index, amount);
                    return;
                }
                if ("all".equals(second)) {
                    this.infoAll(sender);
                    return;
                }
            }
        }
        throw new class_165(this.method_3275(sender), new Object[0]);
    }

    public List<String> method_10738(MinecraftServer minecraftServer, class_1061 iCommandSender, String[] args, class_2552 blockPos) {
        int length = args.length;
        if (length == 1) {
            return CommandSavestate.method_2894((String[])args, (String[])new String[]{"save", "load", "delete", "reload", "rename", "info", "import"});
        }
        String first = args[0];
        if ("save".equals(first)) {
            if (length == 2) {
                return this.getIndexes(args);
            }
            String second = args[1];
            if (this.isNumeric(second)) {
                iCommandSender.method_5505((class_1982)new class_1989("Type the name of the savestate"));
                return new ArrayList<String>();
            }
        } else if ("load".equals(first)) {
            if (length == 2) {
                return this.getIndexes(args);
            }
        } else if ("delete".equals(first)) {
            if (length <= 3) {
                return this.getIndexes(args);
            }
        } else if ("rename".equals(first)) {
            if (length == 2) {
                return this.getIndexes(args);
            }
            if (length == 3) {
                iCommandSender.method_5505((class_1982)new class_1989("Type the new name of the savestate"));
                return new ArrayList<String>();
            }
        } else if ("info".equals(first) && length == 2) {
            String second = args[1];
            if (this.isNumeric(second)) {
                return this.getIndexes(args);
            }
            return CommandSavestate.method_2894((String[])args, (String[])new String[]{"all"});
        }
        return new ArrayList<String>();
    }

    private void info(class_1061 sender) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command Info");
        this.infoIndexAmount(sender, null, null);
    }

    private void infoIndex(class_1061 sender, Integer index) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command InfoIndex {}", (Object)index);
        this.infoIndexAmount(sender, index, null);
    }

    private void infoIndexAmount(class_1061 sender, Integer indexToDisplay, Integer amount) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command InfoIndexAmount {}|{}", (Object)indexToDisplay, (Object)amount);
        int currentIndex = TASmod.savestateHandlerServer.getCurrentIndex();
        int size = TASmod.savestateHandlerServer.size();
        if (size == 0) {
            this.sendHelp(sender);
        }
        if (indexToDisplay == null) {
            indexToDisplay = currentIndex;
        }
        if (amount == null) {
            amount = 10;
        }
        sender.method_5505(Component.literal("").build());
        String format = "MM/dd/yyyy hh:mm:ss a";
        if (!sender.method_12833().method_2983()) {
            format = I18n.format("msg.tasmod.savestate.dateformat", new Object[0]);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        List<SavestateIndexer.Savestate> savestateList = TASmod.savestateHandlerServer.getSavestateInfo(indexToDisplay, amount);
        if (savestateList.size() < size && once) {
            sender.method_5505(Component.translatable("msg.tasmod.savestate.omitted", "/savestate info all").withStyle(class_1442.field_5495, class_1442.field_5503).build());
            once = false;
        }
        for (SavestateIndexer.Savestate savestate : savestateList) {
            String index = savestate.getIndex() == null ? "" : Integer.toString(savestate.getIndex());
            boolean isCurrentIndex = savestate.getIndex() == currentIndex;
            String name = savestate.getName() == null ? "" : savestate.getName();
            String date = savestate.getDate() == null ? "" : dateFormat.format(savestate.getDate());
            class_1442 indexColor = isCurrentIndex ? class_1442.field_5494 : class_1442.field_5492;
            class_1442 nameColor = isCurrentIndex ? class_1442.field_5498 : class_1442.field_5490;
            class_1442 dateColor = isCurrentIndex ? class_1442.field_5494 : class_1442.field_5486;
            class_1442 saveColor = isCurrentIndex ? class_1442.field_5496 : class_1442.field_5488;
            class_1442 deleteColor = isCurrentIndex ? class_1442.field_5495 : class_1442.field_5487;
            class_1442 renameColor = isCurrentIndex ? class_1442.field_5497 : class_1442.field_5489;
            class_1442 loadColor = isCurrentIndex ? class_1442.field_5493 : class_1442.field_5485;
            UnaryOperator hover = t -> t.method_7488(Component.CHoverEvent.create(class_1984.class_1985.field_8488, Component.literal(date).withStyle(dateColor)));
            Component msg = null;
            if (savestate instanceof SavestateIndexer.FailedSavestate) {
                SavestateIndexer.FailedSavestate failedSavestate = (SavestateIndexer.FailedSavestate)savestate;
                msg = Component.translatable("%s: %s%s", Component.literal(index).withStyle(indexColor), Component.literal(name).withStyle(nameColor), Component.translatable("msg.tasmod.savestate.info.error", failedSavestate.getError().getMessage()).withStyle(class_1442.field_5495)).withStyle(t -> t.method_7488(Component.CHoverEvent.create(class_1984.class_1985.field_8488, Component.literal(date).withStyle(class_1442.field_5489))));
            } else {
                Component saveComponent = Component.translatable("msg.tasmod.savestate.save.clickable").withStyle(saveColor).withStyle(t -> t.method_7488(Component.CHoverEvent.create(class_1984.class_1985.field_8488, Component.translatable("msg.tasmod.savestate.save.hover", name).withStyle(saveColor)))).withStyle(t -> t.method_7487(Component.CClickEvent.create(class_1980.class_1981.field_8480, String.format("/savestate save %s", index))));
                Component deleteComponent = Component.translatable("msg.tasmod.savestate.delete.clickable").withStyle(deleteColor).withStyle(t -> t.method_7487(Component.CClickEvent.create(class_1980.class_1981.field_8480, String.format("/savestate delete %s", index)))).withStyle(t -> t.method_7488(Component.CHoverEvent.create(class_1984.class_1985.field_8488, Component.translatable("msg.tasmod.savestate.delete.hover", name).withStyle(deleteColor))));
                Component renameComponent = Component.translatable("msg.tasmod.savestate.rename.clickable").withStyle(renameColor).withStyle(t -> t.method_7487(Component.CClickEvent.create(class_1980.class_1981.field_8480, String.format("/savestate rename %s", index)))).withStyle(t -> t.method_7488(Component.CHoverEvent.create(class_1984.class_1985.field_8488, Component.translatable("msg.tasmod.savestate.rename.hover", name).withStyle(renameColor))));
                Component loadComponent = Component.translatable("msg.tasmod.savestate.load.clickable").withStyle(loadColor).withStyle(t -> t.method_7487(Component.CClickEvent.create(class_1980.class_1981.field_8480, String.format("/savestate load %s", index)))).withStyle(t -> t.method_7488(Component.CHoverEvent.create(class_1984.class_1985.field_8488, Component.translatable("msg.tasmod.savestate.load.hover", name).withStyle(loadColor))));
                msg = Component.translatable("%s: %s     %s %s %s %s", Component.literal(index).withStyle(indexColor), Component.literal(name).withStyle(nameColor), Component.wrap(saveComponent, nameColor), Component.wrap(deleteComponent, nameColor), Component.wrap(renameComponent, nameColor), Component.wrap(loadComponent, nameColor)).withStyle(hover);
            }
            sender.method_5505(msg.build());
        }
    }

    private void sendHelp(class_1061 sender) {
        UnaryOperator hover = t -> t.method_7488(Component.CHoverEvent.create(class_1984.class_1985.field_8488, Component.translatable("Click me!").withStyle(class_1442.field_5494)));
        sender.method_5505(Component.translatable("You currently do not have any savestates!").withStyle(class_1442.field_5495).build());
        sender.method_5505(Component.literal("").build());
        UnaryOperator click = t -> t.method_7487(Component.CClickEvent.create(class_1980.class_1981.field_8480, "/savestate save My first savestate!"));
        sender.method_5505(Component.translatable("Use %s to create one", Component.literal("/savestate save [name]").withStyle(hover).withStyle(click).withStyle(class_1442.field_5494, class_1442.field_5500)).withStyle(class_1442.field_5497).build());
        click = t -> t.method_7487(Component.CClickEvent.create(class_1980.class_1981.field_8480, "/savestate load"));
        sender.method_5505(Component.translatable("then use %s to load it.", Component.literal("/savestate load").withStyle(hover).withStyle(click).withStyle(class_1442.field_5494, class_1442.field_5500)).withStyle(class_1442.field_5497).build());
        sender.method_5505(Component.translatable("This can also be done with the hotkeys J and K respectively.").withStyle(class_1442.field_5497).build());
        click = t -> t.method_7487(Component.CClickEvent.create(class_1980.class_1981.field_8480, "/savestate"));
        sender.method_5505(Component.translatable("Running %s will display all savestates", Component.literal("/savestate").withStyle(hover).withStyle(click).withStyle(class_1442.field_5494, class_1442.field_5500)).withStyle(class_1442.field_5497).build());
        sender.method_5505(Component.translatable("(You can click on the %s!)", Component.translatable("commands").withStyle(class_1442.field_5494)).withStyle(class_1442.field_5493).build());
    }

    private void infoAll(class_1061 sender) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command InfoAll");
        this.infoIndexAmount(sender, -1, 0);
    }

    private void saveNew(class_1061 sender) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command SaveNew");
        SavestateHandlerServer.SavestateCallback cb = CommandSavestate.createChatMessageCallback(sender, "msg.tasmod.savestate.save.end");
        TASmod.gameLoopSchedulerServer.add(() -> {
            try {
                TASmod.savestateHandlerServer.saveState(cb, new SavestateHandlerServer.SavestateFlags[0]);
            }
            catch (SavestateException e) {
                CommandSavestate.onFailure(sender, e);
                try {
                    TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_0_WARN));
                }
                catch (Exception e1) {
                    TASmod.LOGGER.catching((Throwable)e);
                }
            }
        });
    }

    private void saveIndex(class_1061 sender, int index) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command SaveIndex {}", (Object)index);
        SavestateHandlerServer.SavestateCallback cb = CommandSavestate.createChatMessageCallback(sender, "msg.tasmod.savestate.save.end");
        if (index == 0) {
            CommandSavestate.onFailure(sender, new SavestateException("msg.tasmod.savestate.save.error.zero"));
            return;
        }
        if (index < 0) {
            sender.method_5505(Component.translatable("msg.tasmod.savestate.save.negative").withStyle(class_1442.field_5497).build());
        }
        TASmod.gameLoopSchedulerServer.add(() -> {
            try {
                TASmod.savestateHandlerServer.saveState(index, cb, new SavestateHandlerServer.SavestateFlags[0]);
            }
            catch (SavestateException e) {
                CommandSavestate.onFailure(sender, e);
                try {
                    TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_0_WARN));
                }
                catch (Exception e1) {
                    TASmod.LOGGER.catching((Throwable)e);
                }
            }
        });
    }

    private void saveIndexName(class_1061 sender, int index, String name) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command SaveNameIndex {}|{}", (Object)index, (Object)name);
        if (index == 0) {
            CommandSavestate.onFailure(sender, new SavestateException("msg.tasmod.savestate.save.error.zero"));
            return;
        }
        if (index < 0) {
            sender.method_5505(Component.translatable("msg.tasmod.savestate.save.negative").withStyle(class_1442.field_5497).build());
        }
        SavestateHandlerServer.SavestateCallback cb = CommandSavestate.createChatMessageCallback(sender, "msg.tasmod.savestate.save.end");
        TASmod.gameLoopSchedulerServer.add(() -> {
            try {
                TASmod.savestateHandlerServer.saveState(index, name, cb, new SavestateHandlerServer.SavestateFlags[0]);
            }
            catch (SavestateException e) {
                CommandSavestate.onFailure(sender, e);
                try {
                    TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_0_WARN));
                }
                catch (Exception e1) {
                    TASmod.LOGGER.catching((Throwable)e);
                }
            }
        });
    }

    private void saveName(class_1061 sender, String name) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command SaveName {}", (Object)name);
        SavestateHandlerServer.SavestateCallback cb = CommandSavestate.createChatMessageCallback(sender, "msg.tasmod.savestate.save.end");
        TASmod.gameLoopSchedulerServer.add(() -> {
            try {
                TASmod.savestateHandlerServer.saveState(name, cb, new SavestateHandlerServer.SavestateFlags[0]);
            }
            catch (SavestateException e) {
                CommandSavestate.onFailure(sender, e);
                try {
                    TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_0_WARN));
                }
                catch (Exception e1) {
                    TASmod.LOGGER.catching((Throwable)e);
                }
            }
        });
    }

    private void loadRecent(class_1061 sender) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command LoadRecent");
        SavestateHandlerServer.SavestateCallback cb = CommandSavestate.createChatMessageCallback(sender, "msg.tasmod.savestate.load.end");
        TASmod.gameLoopSchedulerServer.add(() -> {
            try {
                TASmod.savestateHandlerServer.loadState(cb, new SavestateHandlerServer.SavestateFlags[0]);
            }
            catch (LoadstateException e) {
                CommandSavestate.onFailure(sender, e);
                try {
                    TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_0_WARN));
                }
                catch (Exception e1) {
                    TASmod.LOGGER.catching((Throwable)e);
                }
            }
        });
    }

    private void loadIndex(class_1061 sender, int index) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command LoadIndex {}", (Object)index);
        if (index < 0) {
            sender.method_5505(Component.translatable("msg.tasmod.savestate.load.negative").withStyle(class_1442.field_5497).build());
        }
        SavestateHandlerServer.SavestateCallback cb = CommandSavestate.createChatMessageCallback(sender, "msg.tasmod.savestate.load.end");
        TASmod.gameLoopSchedulerServer.add(() -> {
            try {
                TASmod.savestateHandlerServer.loadState(index, cb, new SavestateHandlerServer.SavestateFlags[0]);
            }
            catch (LoadstateException e) {
                CommandSavestate.onFailure(sender, e);
                try {
                    TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_0_WARN));
                }
                catch (Exception e1) {
                    TASmod.LOGGER.catching((Throwable)e);
                }
            }
        });
    }

    private void delete(class_1061 sender, int index) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command Delete {}", (Object)index);
        SavestateHandlerServer.SavestateCallback cb = paths -> sender.method_12833().method_3004().method_6061(Component.translatable("msg.tasmod.savestate.delete", Component.literal(Integer.toString(paths.getSavestate().getIndex())).withStyle(class_1442.field_5494)).withStyle(class_1442.field_5493).build());
        try {
            TASmod.savestateHandlerServer.deleteSavestate(index, cb);
        }
        catch (SavestateDeleteException e) {
            CommandSavestate.onFailure(sender, e);
        }
    }

    private void deleteMore(class_1061 sender, int indexFrom, int indexTo) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command DeleteMore {}|{}", (Object)indexFrom, (Object)indexTo);
        int count = indexTo + 1 - indexFrom;
        if (count < 0) {
            CommandSavestate.onFailure(sender, new SavestateDeleteException("msg.tasmod.savestate.deleteMore.error.negative", count));
            return;
        }
        String translationKey = "msg.tasmod.savestate.deleteMore" + (count == 1 ? ".singular" : ".plural");
        Component countComponent = Component.literal(Integer.toString(count)).withStyle(class_1442.field_5495);
        Component confirmationComponent = Component.wrap(Component.translatable("msg.tasmod.savestate.deleteMore.clickable", true).withStyle(style -> style.method_7487(Component.CClickEvent.create(class_1980.class_1981.field_8478, String.format("/savestate delete %s %s force", indexFrom, indexTo))).method_7488(Component.CHoverEvent.create(class_1984.class_1985.field_8488, Component.translatable("msg.tasmod.savestate.deleteMore.hover").withStyle(class_1442.field_5487))))).withStyle(class_1442.field_5493);
        sender.method_5505(Component.translatable(translationKey, countComponent, confirmationComponent).withStyle(class_1442.field_5497).build());
    }

    private void deleteDis(class_1061 sender, int indexFrom, int indexTo) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command DeleteDis {}|{}", (Object)indexFrom, (Object)indexTo);
        SavestateHandlerServer.SavestateCallback cb = paths -> sender.method_12833().method_3004().method_6061(Component.translatable("msg.tasmod.savestate.delete", paths.getSavestate().getIndex()).withStyle(class_1442.field_5493).build());
        SavestateIndexer.ErrorRunnable onErr = exception -> CommandSavestate.onFailure(sender, exception);
        try {
            TASmod.savestateHandlerServer.deleteSavestate(indexFrom, indexTo, cb, onErr);
        }
        catch (SavestateDeleteException e) {
            CommandSavestate.onFailure(sender, e);
        }
    }

    private void reload(class_1061 sender) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command Reload");
        sender.method_12833().method_3004().method_6061(Component.translatable("msg.tasmod.savestate.reload").withStyle(class_1442.field_5493).build());
        TASmod.savestateHandlerServer.reload();
    }

    private void rename(class_1061 sender, int index, String name) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Command Rename {}|{}", (Object)index, (Object)name);
        SavestateHandlerServer.SavestateCallback cb = paths -> sender.method_12833().method_3004().method_6061(Component.translatable("msg.tasmod.savestate.rename", Component.literal(Integer.toString(paths.getSavestate().getIndex())).withStyle(class_1442.field_5494), Component.literal(paths.getSavestate().getName()).withStyle(class_1442.field_5497)).withStyle(class_1442.field_5493).build());
        TASmod.savestateHandlerServer.rename(index, name, cb);
    }

    private int processIndex(String arg) throws class_55 {
        if ("~".equals(arg)) {
            return TASmod.savestateHandlerServer.getCurrentIndex();
        }
        if (arg.matches("~-?\\d+")) {
            arg = arg.replace("~", "");
            int i = CommandSavestate.method_10701((String)arg);
            return TASmod.savestateHandlerServer.getCurrentIndex() + i;
        }
        int i = 0;
        i = CommandSavestate.method_10701((String)arg);
        return i;
    }

    private boolean isNumeric(String string) {
        return Pattern.matches("~|(~?-?\\d+)", string);
    }

    private String getRestArgsAsString(int start, String[] args) {
        return String.join((CharSequence)" ", Arrays.copyOfRange(args, start, args.length));
    }

    private List<String> getIndexes(String[] args) {
        List<SavestateIndexer.Savestate> info = TASmod.savestateHandlerServer.getSavestateInfo();
        ArrayList out = new ArrayList();
        info.forEach(save -> out.add(Integer.toString(save.getIndex())));
        return CommandSavestate.method_10708((String[])args, out);
    }

    private static void onFailure(class_1061 sender, Throwable e) {
        class_1600 mc = class_1600.method_2965();
        mc.method_6635(() -> mc.method_2928(null));
        sender.method_12833().method_3004().method_6061(Component.translatable(e.getMessage()).withStyle(class_1442.field_5495).build());
        TASmod.LOGGER.catching(e);
        TASmod.savestateHandlerServer.resetState();
    }

    public static SavestateHandlerServer.SavestateCallback createChatMessageCallback(class_1061 sender, String translationKey) {
        return paths -> {
            CommandSavestate.createClearScreenCallback(sender).invoke(paths);
            sender.method_12833().method_3004().method_6061(Component.translatable(translationKey, Component.literal(paths.getSavestate().getName()).withStyle(class_1442.field_5497), Component.literal(Integer.toString(paths.getSavestate().getIndex())).withStyle(class_1442.field_5494)).withStyle(class_1442.field_5493).build());
        };
    }

    public static SavestateHandlerServer.SavestateCallback createClearScreenCallback(class_1061 sender) {
        return paths -> {
            if (sender instanceof class_798) {
                try {
                    TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_CLEAR_SCREEN));
                }
                catch (Exception e) {
                    CommandSavestate.onFailure(sender, e);
                }
            }
        };
    }
}

