/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.gui;

import com.minecrafttas.mctcommon.events.EventClient;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.events.EventClient;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.playback.filecommands.builtin.DesyncMonitorFileCommandExtension;
import com.minecrafttas.tasmod.virtual.VirtualInput;
import com.minecrafttas.tasmod.virtual.VirtualInterpolationHandler;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import net.minecraft.class_1442;
import net.minecraft.class_1600;
import net.minecraft.class_388;
import net.minecraft.class_389;
import net.minecraft.class_837;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class InfoHud
extends class_388
implements EventClient.EventClientTick,
EventClient.EventDrawHotbar {
    private int currentlyDraggedIndex = -1;
    private int xOffset;
    private int yOffset;
    private int gridSizeX = 14;
    private int gridSizeY = 14;
    public Properties configuration;
    private boolean resetLayout;
    public static List<InfoLabel> lists = new ArrayList<InfoLabel>();

    private void setDefaults(String string, int y) {
        this.setDefaults(string, y, false);
    }

    private void setDefaults(String string, int y, boolean enabled) {
        this.configuration.setProperty(string + "_x", "0");
        this.configuration.setProperty(string + "_y", y + "");
        this.configuration.setProperty(string + "_visible", enabled ? "true" : "false");
        this.configuration.setProperty(string + "_rect", "false");
        this.saveConfig();
    }

    public void identify(int mouseX, int mouseY) {
        int index = 0;
        for (InfoLabel label : lists) {
            int x = 0;
            int y = 0;
            try {
                x = Integer.parseInt(this.configuration.getProperty(label.displayName + "_x"));
                y = Integer.parseInt(this.configuration.getProperty(label.displayName + "_y"));
                Pair<Integer, Integer> newPos = this.getScreenOffset(x, y, label);
                x = (Integer)newPos.getLeft();
                y = (Integer)newPos.getRight();
            }
            catch (NumberFormatException e) {
                this.configuration.setProperty(label.displayName + "_x", "0");
                this.configuration.setProperty(label.displayName + "_y", "0");
                this.saveConfig();
            }
            int w = x + class_1600.method_2965().field_3814.method_954(label.renderText);
            int h = y + 15;
            if (mouseX >= x && mouseX <= w && mouseY >= y && mouseY <= h) {
                this.currentlyDraggedIndex = index;
                this.xOffset = mouseX - x;
                this.yOffset = mouseY - y;
                return;
            }
            ++index;
        }
        this.currentlyDraggedIndex = -1;
        this.xOffset = -1;
        this.yOffset = -1;
    }

    protected void method_1026(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 2) {
            this.identify(mouseX, mouseY);
            if (this.currentlyDraggedIndex != -1) {
                String id = InfoHud.lists.get((int)this.currentlyDraggedIndex).displayName;
                InfoHud.lists.get((int)this.currentlyDraggedIndex).renderRect = !InfoHud.lists.get((int)this.currentlyDraggedIndex).renderRect;
                this.configuration.setProperty(id + "_rect", this.configuration.getProperty(id + "_rect").equalsIgnoreCase("true") ? "false" : "true");
                this.saveConfig();
                this.currentlyDraggedIndex = -1;
            }
            return;
        }
        if (mouseButton == 1) {
            this.identify(mouseX, mouseY);
            if (this.currentlyDraggedIndex != -1) {
                String id = InfoHud.lists.get((int)this.currentlyDraggedIndex).displayName;
                InfoHud.lists.get((int)this.currentlyDraggedIndex).visible = !InfoHud.lists.get((int)this.currentlyDraggedIndex).visible;
                this.configuration.setProperty(id + "_visible", this.configuration.getProperty(id + "_visible").equalsIgnoreCase("true") ? "false" : "true");
                this.saveConfig();
                this.currentlyDraggedIndex = -1;
            }
            return;
        }
        this.identify(mouseX, mouseY);
        super.method_1026(mouseX, mouseY, mouseButton);
    }

    protected void method_1032(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_) {
        this.currentlyDraggedIndex = -1;
        this.saveConfig();
        super.method_1032(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_);
    }

    protected void method_4259(int mouseX, int mouseY, int k, long millis) {
        if (this.currentlyDraggedIndex != -1) {
            String dragging = InfoHud.lists.get((int)this.currentlyDraggedIndex).displayName;
            int mousePosX = mouseX - this.xOffset;
            int mousePosY = mouseY - this.yOffset;
            if (TASmodClient.virtual.isKeyDown(42)) {
                mousePosX = this.snapToGridX(mousePosX);
                mousePosY = this.snapToGridY(mousePosY);
            }
            InfoHud.lists.get((int)this.currentlyDraggedIndex).x = mousePosX;
            InfoHud.lists.get((int)this.currentlyDraggedIndex).y = mousePosY;
            this.configuration.setProperty(dragging + "_x", InfoHud.lists.get((int)this.currentlyDraggedIndex).x + "");
            this.configuration.setProperty(dragging + "_y", InfoHud.lists.get((int)this.currentlyDraggedIndex).y + "");
        }
        super.method_4259(mouseX, mouseY, k, millis);
    }

    private int snapToGridX(int x) {
        return Math.round(x / this.gridSizeX) * this.gridSizeX;
    }

    private int snapToGridY(int y) {
        return Math.round(y / this.gridSizeY) * this.gridSizeY;
    }

    private void saveConfig() {
        if (!(class_1600.method_2965().field_3816 instanceof InfoHud) || this.configuration == null) {
            return;
        }
        try {
            File tasmodDir = new File(class_1600.method_2965().field_3762, "tasmod");
            tasmodDir.mkdir();
            File configFile = new File(tasmodDir, "infogui2.cfg");
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            this.configuration.store(new FileOutputStream(configFile, false), "DO NOT EDIT MANUALLY");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onClientTick(class_1600 mc) {
        if (mc.field_10310 != null && this.checkInit()) {
            return;
        }
    }

    public boolean checkInit() {
        if (this.configuration != null) {
            return false;
        }
        try {
            this.configuration = new Properties();
            if (!this.resetLayout) {
                File tasmodDir = new File(class_1600.method_2965().field_3762, "tasmod");
                tasmodDir.mkdir();
                File configFile = new File(tasmodDir, "infogui2.cfg");
                if (!configFile.exists()) {
                    configFile.createNewFile();
                }
                this.configuration.load(new FileReader(configFile));
            } else {
                this.resetLayout = false;
            }
            lists = new ArrayList<InfoLabel>();
            String title = "tickrate";
            int y = 0;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "Tickrate";
                }
                return String.format("Tickrate: %s", Float.valueOf(TASmodClient.tickratechanger.ticksPerSecond));
            }));
            title = "position";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "XYZ";
                }
                return String.format("%.2f %.2f %.2f", class_1600.method_2965().field_10310.field_3252, class_1600.method_2965().field_10310.field_3253, class_1600.method_2965().field_10310.field_3254);
            }));
            title = "position2";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "Precise XYZ";
                }
                return String.format("%s %s %s", class_1600.method_2965().field_10310.field_3252, class_1600.method_2965().field_10310.field_3253, class_1600.method_2965().field_10310.field_3254);
            }));
            title = "chunkpos";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "Chunk Position";
                }
                return String.format("%d %d", class_1600.method_2965().field_10310.field_3227, class_1600.method_2965().field_10310.field_3229);
            }));
            title = "worldseed";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "Worldseed";
                }
                return "World Seed: " + class_1600.method_2965().field_3803.method_3588().method_210();
            }));
            y += 14;
            title = "facing";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "Facing";
                }
                if (TASmodClient.virtual.CAMERA_ANGLE.getCurrentYaw() != null) {
                    return String.format("%.2f %.2f", Float.valueOf(class_837.method_2353((float)TASmodClient.virtual.CAMERA_ANGLE.getCurrentYaw().floatValue())), Float.valueOf(class_837.method_2353((float)TASmodClient.virtual.CAMERA_ANGLE.getCurrentPitch().floatValue())));
                }
                return "null";
            }));
            title = "camera";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "Camera";
                }
                if (TASmodClient.virtual.CAMERA_ANGLE.getNextYaw() != null) {
                    return String.format("%.2f %.2f", Float.valueOf(class_837.method_2353((float)TASmodClient.virtual.CAMERA_ANGLE.getNextYaw().floatValue())), Float.valueOf(class_837.method_2353((float)TASmodClient.virtual.CAMERA_ANGLE.getNextPitch().floatValue())));
                }
                return "null";
            }));
            title = "cticks";
            y += 14;
            title = "sticks";
            y += 14;
            title = "nextxyz";
            y += 14;
            title = "state";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "State";
                }
                PlaybackControllerClient.TASstate state = TASmodClient.controller.getState();
                ChatFormatting format = ChatFormatting.WHITE;
                String out = "";
                if (state == PlaybackControllerClient.TASstate.PLAYBACK) {
                    out = "Playback";
                    format = ChatFormatting.GREEN;
                } else if (state == PlaybackControllerClient.TASstate.RECORDING) {
                    out = "Recording";
                    format = ChatFormatting.RED;
                } else if (state == PlaybackControllerClient.TASstate.PAUSED) {
                    out = "Paused";
                    format = ChatFormatting.YELLOW;
                } else if (state == PlaybackControllerClient.TASstate.NONE) {
                    out = "";
                }
                return String.format("%s%s", format, out);
            }));
            title = "cursor";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "Mouse Position";
                }
                VirtualInterpolationHandler.MouseInterpolation mouseInterpolation = TASmodClient.virtual.interpolationHandler.getInterpolatedMouseCursor(0.0f, false);
                Integer xCursor = mouseInterpolation.getX();
                Integer yCursor = mouseInterpolation.getY();
                if (class_1600.method_2965().field_3816 != null) {
                    return String.format("Mouse Cursor: %s %s", xCursor == null ? "null" : xCursor, yCursor == null ? "null" : yCursor);
                }
                return "Mouse Cursor: 0 0";
            }));
            title = "velocity";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "Velocity";
                }
                return class_1600.method_2965().field_10310.field_3255 + " " + class_1600.method_2965().field_10310.field_3256 + " " + class_1600.method_2965().field_10310.field_3257;
            }));
            title = "desyncstatus";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "Desync";
                }
                DesyncMonitorFileCommandExtension dMonitor = TASmodClient.desyncMonitorFileCommandExtension;
                return dMonitor.getStatus(class_1600.method_2965().field_10310);
            }));
            title = "desyncstatusMotion";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "Desync Motion";
                }
                DesyncMonitorFileCommandExtension dMonitor = TASmodClient.desyncMonitorFileCommandExtension;
                return dMonitor.getMotion();
            }));
            title = "desyncstatusPos";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "Desync Position";
                }
                DesyncMonitorFileCommandExtension dMonitor = TASmodClient.desyncMonitorFileCommandExtension;
                return dMonitor.getPos();
            }));
            y = this.field_1231 - 28;
            title = "playback_index";
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y, true);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "PlaybackIndex";
                }
                return String.format("%s/%s", TASmodClient.controller.index(), Math.max((long)(TASmodClient.controller.size() - 1), 0L));
            }));
            y = this.field_1231 - 14;
            title = "keystrokes";
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y, true);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (class_1600.method_2965().field_3816 == this) {
                    return "Keystrokes";
                }
                return this.keystrokes();
            }));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void onDrawHotbar() {
        String text = TASmodClient.labelFileCommandExtension.getLabelText();
        if (!text.isEmpty() && TASmodClient.controller.isPlayingback()) {
            this.drawRectWithText(text, 10, 10, true);
        }
        if (!TASmodClient.optionsFileCommandExtension.shouldRenderHud() && TASmodClient.controller.isPlayingback()) {
            return;
        }
        int xpos = 40;
        int ypos = 190;
        for (InfoLabel label : lists) {
            label.tick();
            int lx = label.x;
            int ly = label.y;
            Pair<Integer, Integer> newPos = this.getScreenOffset(lx, ly, label);
            lx = (Integer)newPos.getLeft();
            ly = (Integer)newPos.getRight();
            if (label.visible) {
                this.drawRectWithText(label.renderText, lx, ly, label.renderRect);
            } else if (class_1600.method_2965().field_3816 != null && class_1600.method_2965().field_3816.getClass().getSimpleName().contains("InfoHud")) {
                class_1600.method_2965().field_3814.method_956(label.renderText, (float)(label.x + 2), (float)(label.y + 3), 0x60FFFFFF);
            }
            if (!(class_1600.method_2965().field_3816 instanceof InfoHud)) continue;
            class_1600.method_2965().field_3814.method_956("Leftclick to move", (float)(this.field_1230 - ypos), (float)(xpos - 30), 0x60FF00);
            class_1600.method_2965().field_3814.method_956("Rightclick to enable", (float)(this.field_1230 - ypos), (float)(xpos - 20), 0x60FF00);
            class_1600.method_2965().field_3814.method_956("Middleclick to add black background", (float)(this.field_1230 - ypos), (float)(xpos - 10), 0x60FF00);
            class_1600.method_2965().field_3814.method_956("Hold Shift to snap to grid", (float)(this.field_1230 - ypos), (float)xpos, 0x60FF00);
            class_1600.method_2965().field_3814.method_956("CTRL+Shift+R to reset the layout", (float)(this.field_1230 - ypos), (float)(xpos + 10), 15630592);
            if (!InfoHud.method_1041() || !InfoHud.method_1042() || !TASmodClient.virtual.isKeyDown(19)) continue;
            this.resetLayout = true;
            this.configuration = null;
        }
        class_389 scaled = new class_389(class_1600.method_2965());
        this.method_993(class_1600.method_2965().field_3814, TASmod.version, scaled.method_1045() - class_1600.method_2965().field_3814.method_954(TASmod.version) - 2, scaled.method_1046() - 10, 0xFFFFFF);
    }

    private void drawRectWithText(String text, int x, int y, boolean rect) {
        if (rect) {
            InfoHud.method_988((int)x, (int)y, (int)(x + class_1600.method_2965().field_3814.method_954(text) + 4), (int)(y + 14), (int)0x60000000);
        }
        class_1600.method_2965().field_3814.method_956(text, (float)(x + 2), (float)(y + 3), 0xFFFFFF);
        GL11.glEnable((int)3042);
    }

    private String keystrokes() {
        boolean isPlayingBack = TASmodClient.controller.isPlayingback();
        VirtualInput virtual = TASmodClient.virtual;
        PlaybackControllerClient controller = TASmodClient.controller;
        String currentMousePresses = String.join((CharSequence)" ", virtual.getCurrentMousePresses());
        String nextMousePresses = "";
        if (Display.isActive() || isPlayingBack) {
            List<String> mousePresses = isPlayingBack ? controller.getNextMousePresses() : virtual.getNextMousePresses();
            nextMousePresses = String.join((CharSequence)" ", mousePresses);
        }
        String currentKeyboardPresses = String.join((CharSequence)" ", TASmodClient.virtual.getCurrentKeyboardPresses());
        String nextKeyboardPresses = "";
        if (Display.isActive() || isPlayingBack) {
            List<String> keyboardPresses = isPlayingBack ? controller.getNextKeyboardPresses() : virtual.getNextKeyboardPresses();
            nextKeyboardPresses = String.join((CharSequence)" ", keyboardPresses);
        }
        return String.format("%s%s %s%s %s%s %s%s", class_1442.field_5498, currentMousePresses, class_1442.field_5493, nextMousePresses, class_1442.field_5498, currentKeyboardPresses, class_1442.field_5493, nextKeyboardPresses);
    }

    private Pair<Integer, Integer> getScreenOffset(int x, int y, InfoLabel label) {
        int offset;
        class_389 scaled = new class_389(class_1600.method_2965());
        int marginX = 5;
        int marginY = 5;
        if (this.getBBRight(x, label.renderText) > scaled.method_1045()) {
            offset = this.getBBRight(x, label.renderText);
            x = x - (offset - scaled.method_1045()) - marginX;
        }
        if (this.getBBDown(y) > scaled.method_1046()) {
            offset = this.getBBDown(y);
            y = y - (offset - scaled.method_1046()) - marginY;
        }
        return Pair.of((Object)x, (Object)y);
    }

    private int getBBRight(int x, String text) {
        return x + class_1600.method_2965().field_3814.method_954(text);
    }

    private int getBBDown(int y) {
        return y + 14;
    }

    public static class InfoLabel {
        public String displayName;
        public int x;
        public int y;
        public boolean visible;
        public boolean renderRect;
        public String renderText;
        private Callable<String> text;

        public InfoLabel(String displayName, int x, int y, boolean visible, boolean renderRect, Callable<String> text) {
            this.displayName = displayName;
            this.visible = visible;
            this.x = x;
            this.y = y;
            this.renderRect = renderRect;
            this.text = text;
        }

        public void tick() {
            try {
                this.renderText = this.text.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

