/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.handlers;

import com.minecrafttas.mctcommon.networking.ByteBufferBuilder;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.ClientPacketHandler;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.events.EventPlaybackClient;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import java.nio.ByteBuffer;

public class PlayUntilHandler
implements ClientPacketHandler,
ServerPacketHandler,
EventPlaybackClient.EventPlaybackTickPre {
    private Integer playUntil = null;

    @Override
    public void onPlaybackTickPre(long index) {
        if (this.playUntil != null && (long)this.playUntil.intValue() == index) {
            TASmodClient.tickratechanger.pauseGame(true);
            PlaybackControllerClient controller = TASmodClient.controller;
            controller.setTASState(PlaybackControllerClient.TASstate.RECORDING);
            controller.setIndex(controller.index() - 1L);
            for (long i = (long)(controller.size() - 1); i >= index; --i) {
                controller.remove(i);
            }
            this.playUntil = null;
        }
    }

    public boolean isActive() {
        return this.playUntil != null;
    }

    public void setPlayUntil(int until) {
        this.playUntil = until;
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new TASmodPackets[]{TASmodPackets.PLAYBACK_PLAYUNTIL};
    }

    @Override
    public void onClientPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case PLAYBACK_PLAYUNTIL: {
                int until = ByteBufferBuilder.readInt(buf);
                this.setPlayUntil(until);
                break;
            }
            default: {
                throw new PacketNotImplementedException(packet, this.getClass(), Client.Side.SERVER);
            }
        }
    }

    @Override
    public void onServerPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case PLAYBACK_PLAYUNTIL: {
                TASmod.server.sendToAll(new TASmodBufferBuilder(buf));
                break;
            }
            default: {
                throw new PacketNotImplementedException(packet, this.getClass(), Client.Side.SERVER);
            }
        }
    }
}

