/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.ktrng;

import com.minecrafttas.mctcommon.events.EventClient;
import com.minecrafttas.mctcommon.events.EventServer;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.ClientPacketHandler;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_518;
import net.minecraft.server.MinecraftServer;

@Deprecated
public class KillTheRNGHandler
implements EventServer.EventServerTick,
EventClient.EventPlayerJoinedClientSide,
ClientPacketHandler,
ServerPacketHandler {
    private boolean isLoaded;

    public KillTheRNGHandler(boolean isLoaded) {
        this.isLoaded = isLoaded;
        if (!isLoaded) {
            TASmod.LOGGER.info("KillTheRNG doesn't appear to be loaded");
        }
    }

    public long advanceGlobalSeedServer() {
        return 0L;
    }

    public long getGlobalSeedServer() {
        return 0L;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Environment(value=EnvType.CLIENT)
    public long getGlobalSeedClient() {
        return 0L;
    }

    @Environment(value=EnvType.CLIENT)
    public void setGlobalSeedClient(long seedIn) {
        if (this.isLoaded()) {
            // empty if block
        }
    }

    public void setGlobalSeedServer(long seedIn) {
        if (this.isLoaded()) {
            // empty if block
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void sendGlobalSeedToServer(long seedIn) {
        if (this.isLoaded()) {
            if (TASmodClient.client != null) {
                try {
                    TASmodClient.client.send(new TASmodBufferBuilder(TASmodPackets.KILLTHERNG_SEED).writeLong(seedIn));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.setGlobalSeedClient(seedIn);
            }
        }
    }

    @Override
    public void onServerTick(MinecraftServer server) {
        if (this.isLoaded() && TASmod.playbackControllerServer.getState() != PlaybackControllerClient.TASstate.PAUSED) {
            try {
                TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.KILLTHERNG_SEED).writeLong(this.advanceGlobalSeedServer()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void broadcastStartSeed() {
        if (this.isLoaded()) {
            long seed = this.getGlobalSeedServer();
            try {
                TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.KILLTHERNG_SEED).writeLong(seed));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void setInitialSeed(long initialSeed) {
        if (TASmodClient.client != null) {
            TASmod.LOGGER.info("Sending initial client seed: {}", (Object)initialSeed);
            try {
                TASmodClient.client.send(new TASmodBufferBuilder(TASmodPackets.KILLTHERNG_STARTSEED).writeLong(initialSeed));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onPlayerJoinedClientSide(class_518 player) {
        this.setInitialSeed(this.getGlobalSeedClient());
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new TASmodPackets[]{TASmodPackets.KILLTHERNG_SEED, TASmodPackets.KILLTHERNG_STARTSEED};
    }

    @Override
    public void onServerPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        long seed = TASmodBufferBuilder.readLong(buf);
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case KILLTHERNG_SEED: {
                this.setGlobalSeedServer(seed);
                break;
            }
            case KILLTHERNG_STARTSEED: {
                TASmod.tickSchedulerServer.add(() -> {});
                break;
            }
            default: {
                throw new PacketNotImplementedException(packet, this.getClass(), Client.Side.SERVER);
            }
        }
    }

    @Override
    public void onClientPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        long seed = TASmodBufferBuilder.readLong(buf);
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case KILLTHERNG_SEED: {
                this.setGlobalSeedClient(seed);
                break;
            }
            case KILLTHERNG_STARTSEED: {
                break;
            }
            default: {
                throw new PacketNotImplementedException(packet, this.getClass(), Client.Side.CLIENT);
            }
        }
    }
}

