/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback;

import com.dselent.bigarraylist.BigArrayList;
import com.minecrafttas.mctcommon.ConfigurationRegistry;
import com.minecrafttas.mctcommon.events.EventClient;
import com.minecrafttas.mctcommon.events.EventListenerRegistry;
import com.minecrafttas.mctcommon.networking.ByteBufferBuilder;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.ClientPacketHandler;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.events.EventClient;
import com.minecrafttas.tasmod.events.EventPlaybackClient;
import com.minecrafttas.tasmod.events.EventVirtualInput;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.playback.tasfile.PlaybackSerialiser;
import com.minecrafttas.tasmod.playback.tasfile.exception.PlaybackLoadException;
import com.minecrafttas.tasmod.playback.tasfile.exception.PlaybackSaveException;
import com.minecrafttas.tasmod.registries.TASmodConfig;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.util.Ducks;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import com.minecrafttas.tasmod.util.Scheduler;
import com.minecrafttas.tasmod.virtual.VirtualCameraAngle;
import com.minecrafttas.tasmod.virtual.VirtualInput;
import com.minecrafttas.tasmod.virtual.VirtualKeyboard;
import com.minecrafttas.tasmod.virtual.VirtualMouse;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.class_1442;
import net.minecraft.class_1600;
import net.minecraft.class_1980;
import net.minecraft.class_1982;
import net.minecraft.class_1989;
import net.minecraft.class_388;
import net.minecraft.class_478;
import net.minecraft.class_518;
import net.minecraft.class_624;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class PlaybackControllerClient
implements ClientPacketHandler,
EventClient.EventClientInit,
EventClient.EventClientTickPost,
EventClient.EventDrawScreen,
EventVirtualInput.EventVirtualKeyboardTick,
EventVirtualInput.EventVirtualMouseTick,
EventVirtualInput.EventVirtualCameraAngleTick {
    private Logger logger = TASmod.LOGGER;
    private TASstate state = TASstate.NONE;
    private TASstate stateAfterPause = TASstate.NONE;
    private long index;
    private VirtualKeyboard currentPlaybackKeyboard = new VirtualKeyboard();
    private VirtualMouse currentPlaybackMouse = new VirtualMouse();
    private VirtualCameraAngle currentPlaybackCameraAngle = new VirtualCameraAngle();
    private VirtualKeyboard nextPlaybackKeyboard = new VirtualKeyboard();
    private VirtualMouse nextPlaybackMouse = new VirtualMouse();
    private VirtualCameraAngle nextPlaybackCameraAngle = new VirtualCameraAngle();
    public final Path tasFileDirectory;
    public final Path fileEnding = Paths.get(".mctas", new String[0]);
    private BigArrayList<InputContainer> inputs;

    public PlaybackControllerClient() {
        this.tasFileDirectory = TASmodClient.tasfiledirectory;
        this.inputs = new BigArrayList(this.tasFileDirectory.resolve("temp").toAbsolutePath().toString());
    }

    public void setTASState(TASstate stateIn) {
        try {
            TASmodClient.client.send(new TASmodBufferBuilder(TASmodPackets.PLAYBACK_STATE).writeEnum(stateIn));
        }
        catch (Exception e) {
            this.logger.catching((Throwable)e);
        }
    }

    public String setTASStateClient(TASstate stateIn) {
        return this.setTASStateClient(stateIn, true);
    }

    public String setTASStateClient(TASstate stateIn, boolean verbose) {
        EventListenerRegistry.fireEvent(EventPlaybackClient.EventControllerStateChange.class, new Object[]{stateIn, this.state});
        if (this.state == stateIn) {
            switch (stateIn.ordinal()) {
                case 1: {
                    return verbose ? class_1442.field_5495 + "A playback is already running" : "";
                }
                case 2: {
                    return verbose ? class_1442.field_5495 + "A recording is already running" : "";
                }
                case 3: {
                    return verbose ? class_1442.field_5495 + "The game is already paused" : "";
                }
                case 0: {
                    return verbose ? class_1442.field_5495 + "Nothing is running" : "";
                }
            }
        } else if (this.state == TASstate.NONE) {
            switch (stateIn.ordinal()) {
                case 1: {
                    this.startPlayback();
                    this.state = TASstate.PLAYBACK;
                    return verbose ? class_1442.field_5493 + "Starting playback" : "";
                }
                case 2: {
                    this.startRecording();
                    this.state = TASstate.RECORDING;
                    return verbose ? class_1442.field_5493 + "Starting a recording" : "";
                }
                case 3: {
                    return verbose ? class_1442.field_5495 + "Can't pause anything because nothing is running" : "";
                }
                case 0: {
                    return class_1442.field_5495 + "Please report this message to the mod author, because you should never be able to see this (Error: None)";
                }
            }
        } else if (this.state == TASstate.RECORDING) {
            switch (stateIn.ordinal()) {
                case 1: {
                    return verbose ? class_1442.field_5495 + "A recording is currently running. Please stop the recording first before starting a playback" : "";
                }
                case 2: {
                    return class_1442.field_5495 + "Please report this message to the mod author, because you should never be able to see this (Error: Recording)";
                }
                case 3: {
                    TASmod.LOGGER.debug(LoggerMarkers.Playback, "Pausing a recording");
                    this.state = TASstate.PAUSED;
                    this.stateAfterPause = TASstate.RECORDING;
                    return verbose ? class_1442.field_5493 + "Pausing a recording" : "";
                }
                case 0: {
                    this.stopRecording();
                    this.state = TASstate.NONE;
                    return verbose ? class_1442.field_5493 + "Stopping the recording" : "";
                }
            }
        } else if (this.state == TASstate.PLAYBACK) {
            switch (stateIn.ordinal()) {
                case 1: {
                    return class_1442.field_5495 + "Please report this message to the mod author, because you should never be able to see this (Error: Playback)";
                }
                case 2: {
                    this.stopPlayback(false);
                    this.startRecording();
                    this.state = TASstate.RECORDING;
                    return verbose ? class_1442.field_5493 + "Switching from playback to recording" : "";
                }
                case 3: {
                    TASmod.LOGGER.debug(LoggerMarkers.Playback, "Pausing a playback");
                    this.state = TASstate.PAUSED;
                    this.stateAfterPause = TASstate.PLAYBACK;
                    TASmodClient.virtual.clearNext();
                    return verbose ? class_1442.field_5493 + "Pausing a playback" : "";
                }
                case 0: {
                    this.stopPlayback(true);
                    this.state = TASstate.NONE;
                    return verbose ? class_1442.field_5493 + "Stopping the playback" : "";
                }
            }
        } else if (this.state == TASstate.PAUSED) {
            switch (stateIn.ordinal()) {
                case 1: {
                    TASmod.LOGGER.debug(LoggerMarkers.Playback, "Resuming a playback");
                    this.state = TASstate.PLAYBACK;
                    this.stateAfterPause = TASstate.NONE;
                    return verbose ? class_1442.field_5493 + "Resuming a playback" : "";
                }
                case 2: {
                    TASmod.LOGGER.debug(LoggerMarkers.Playback, "Resuming a recording");
                    this.state = TASstate.RECORDING;
                    this.stateAfterPause = TASstate.NONE;
                    return verbose ? class_1442.field_5493 + "Resuming a recording" : "";
                }
                case 3: {
                    return class_1442.field_5495 + "Please report this message to the mod author, because you should never be able to see this (Error: Paused)";
                }
                case 0: {
                    TASmod.LOGGER.debug(LoggerMarkers.Playback, "Aborting pausing");
                    this.state = TASstate.NONE;
                    TASstate statey = this.stateAfterPause;
                    this.stateAfterPause = TASstate.NONE;
                    return class_1442.field_5493 + "Aborting a " + statey.toString().toLowerCase() + " that was paused";
                }
            }
        }
        return "Something went wrong ._.";
    }

    private void startRecording() {
        TASmod.LOGGER.debug(LoggerMarkers.Playback, "Starting recording");
        if (this.inputs.isEmpty()) {
            VirtualInput.VirtualCameraAngleInput CAMERA_ANGLE = TASmodClient.virtual.CAMERA_ANGLE;
            Float pitch = CAMERA_ANGLE.getCurrentPitch();
            Float yaw = CAMERA_ANGLE.getCurrentYaw();
            this.currentPlaybackCameraAngle.set(pitch.floatValue(), yaw.floatValue());
            this.inputs.add(new InputContainer());
        }
    }

    private void stopRecording() {
        TASmod.LOGGER.debug(LoggerMarkers.Playback, "Stopping a recording");
        TASmodClient.virtual.clearNext();
    }

    private void startPlayback() {
        TASmod.LOGGER.debug(LoggerMarkers.Playback, "Starting playback");
        class_1600.method_2965().field_3823.field_985 = false;
        this.index = 0L;
    }

    private void stopPlayback(boolean clearInputs) {
        TASmod.LOGGER.debug(LoggerMarkers.Playback, "Stopping a playback");
        class_1600.method_2965().field_3823.field_985 = true;
        if (clearInputs) {
            TASmodClient.virtual.clearNext();
        }
    }

    public TASstate togglePause() {
        if (this.state != TASstate.PAUSED) {
            this.setTASStateClient(TASstate.PAUSED);
        } else {
            this.setTASStateClient(this.stateAfterPause);
        }
        return this.state;
    }

    public void pause(boolean pause) {
        TASmod.LOGGER.trace(LoggerMarkers.Playback, "Pausing {}", (Object)pause);
        if (pause) {
            if (this.state != TASstate.NONE) {
                this.setTASStateClient(TASstate.PAUSED, false);
            }
        } else if (this.state == TASstate.PAUSED) {
            this.setTASStateClient(this.stateAfterPause, false);
        }
    }

    public boolean isPlayingback() {
        return this.state == TASstate.PLAYBACK;
    }

    public boolean isRecording() {
        return this.state == TASstate.RECORDING;
    }

    public boolean isPaused() {
        return this.state == TASstate.PAUSED;
    }

    public boolean isNothingPlaying() {
        return this.state == TASstate.NONE;
    }

    public TASstate getState() {
        return this.state;
    }

    public TASstate getStateAfterPause() {
        return this.stateAfterPause;
    }

    @Override
    public VirtualKeyboard onVirtualKeyboardTick(VirtualKeyboard vkeyboard) {
        if (this.state == TASstate.RECORDING) {
            this.currentPlaybackKeyboard.deepCopyFrom(vkeyboard);
        } else if (this.state == TASstate.PLAYBACK) {
            vkeyboard.deepCopyFrom(this.currentPlaybackKeyboard);
        }
        return vkeyboard.clone();
    }

    @Override
    public VirtualMouse onVirtualMouseTick(VirtualMouse vmouse) {
        if (this.state == TASstate.RECORDING) {
            this.currentPlaybackMouse.deepCopyFrom(vmouse);
        } else if (this.state == TASstate.PLAYBACK) {
            vmouse.deepCopyFrom(this.currentPlaybackMouse);
        }
        return vmouse.clone();
    }

    @Override
    public VirtualCameraAngle onVirtualCameraTick(VirtualCameraAngle vcamera) {
        if (this.state == TASstate.RECORDING) {
            this.currentPlaybackCameraAngle.deepCopyFrom(vcamera);
        } else if (this.state == TASstate.PLAYBACK) {
            vcamera.deepCopyFrom(this.currentPlaybackCameraAngle);
        }
        return vcamera.clone();
    }

    @Override
    public void onDrawScreen(class_388 screen, int x, int y) {
        if (!this.isPlayingback()) {
            return;
        }
        class_1600 mc = class_1600.method_2965();
        if (!mc.field_3823.field_5052 && !Display.isActive()) {
            return;
        }
        Ducks.GuiScreenDuck duckedScreen = (Ducks.GuiScreenDuck)screen;
        Mouse.setCursorPosition((int)duckedScreen.rescaleX(x), (int)duckedScreen.rescaleY(y));
    }

    @Override
    public void onClientTickPost(class_1600 mc) {
        class_518 player = mc.field_10310;
        if (player != null && player.field_3226 && this.isPaused() && this.stateAfterPause != TASstate.NONE) {
            this.setTASState(this.stateAfterPause);
            this.pause(false);
            EventListenerRegistry.fireEvent(EventPlaybackClient.EventPlaybackJoinedWorld.class, new Object[]{this.state});
        }
        if (this.state == TASstate.RECORDING) {
            this.recordNextTick();
        } else if (this.state == TASstate.PLAYBACK) {
            this.playbackNextTick();
        }
    }

    private void recordNextTick() {
        ++this.index;
        InputContainer container = new InputContainer(this.currentPlaybackKeyboard.clone(), this.currentPlaybackMouse.clone(), this.currentPlaybackCameraAngle.clone());
        if (this.inputs.size() <= this.index) {
            if (this.inputs.size() < this.index) {
                TASmod.LOGGER.warn("Index is {} inputs bigger than the container!", (Object)(this.index - this.inputs.size()));
            }
            this.inputs.add(container);
        } else {
            this.inputs.set(this.index, container);
        }
        EventListenerRegistry.fireEvent(EventPlaybackClient.EventRecordTick.class, this.index, container);
    }

    private void playbackNextTick() {
        class_1600 mc = class_1600.method_2965();
        if (!Display.isActive() && mc.field_3823.field_5052) {
            TASmod.LOGGER.info(LoggerMarkers.Playback, "Stopping a {} since the user tabbed out of the game", (Object)this.state);
            this.setTASState(TASstate.NONE);
        }
        ++this.index;
        EventListenerRegistry.fireEvent(EventPlaybackClient.EventPlaybackTickPre.class, this.index);
        if (this.index == this.inputs.size() || this.inputs.isEmpty()) {
            --this.index;
            this.unpressContainer();
            this.setTASState(TASstate.NONE);
        } else {
            InputContainer container = null;
            if (this.index + 1L < this.inputs.size()) {
                container = this.inputs.get(this.index + 1L);
                this.currentPlaybackKeyboard = this.nextPlaybackKeyboard.clone();
                this.currentPlaybackMouse = this.nextPlaybackMouse.clone();
                this.currentPlaybackCameraAngle = this.nextPlaybackCameraAngle.clone();
                this.nextPlaybackKeyboard = container.getKeyboard().clone();
                this.nextPlaybackMouse = container.getMouse().clone();
                this.nextPlaybackCameraAngle = container.getCameraAngle().clone();
            } else {
                container = this.inputs.get(this.index);
                this.currentPlaybackKeyboard = container.getKeyboard().clone();
                this.currentPlaybackMouse = container.getMouse().clone();
                this.currentPlaybackCameraAngle = container.getCameraAngle().clone();
            }
            EventListenerRegistry.fireEvent(EventPlaybackClient.EventPlaybackTick.class, this.index, container);
        }
    }

    public int size() {
        return (int)this.inputs.size();
    }

    public boolean isEmpty() {
        return this.inputs.isEmpty();
    }

    public long index() {
        return this.index;
    }

    public void remove(long index) {
        this.inputs.remove(index);
        EventListenerRegistry.fireEvent(EventPlaybackClient.EventInputDelete.class, index);
    }

    public BigArrayList<InputContainer> getInputs() {
        return this.inputs;
    }

    public void setInputs(BigArrayList<InputContainer> inputs) {
        this.setInputs(inputs, 0L);
    }

    public void setInputs(BigArrayList<InputContainer> inputs, long index) {
        this.clearInputList();
        this.inputs.addAll(inputs);
        this.setIndex(index);
    }

    public void setIndex(long index) throws IndexOutOfBoundsException {
        if (index <= (long)this.size()) {
            this.index = index;
            if (this.state == TASstate.PLAYBACK) {
                InputContainer inputcontainer = this.inputs.get(index);
                this.currentPlaybackKeyboard = inputcontainer.getKeyboard();
                this.currentPlaybackMouse = inputcontainer.getMouse();
                this.currentPlaybackCameraAngle = inputcontainer.getCameraAngle();
            }
        } else {
            throw new IndexOutOfBoundsException("Index is bigger than the container");
        }
    }

    public InputContainer get(long index) {
        InputContainer inputcontainer = null;
        try {
            inputcontainer = this.inputs.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return inputcontainer;
    }

    public InputContainer get() {
        return this.get(this.index);
    }

    public void clear() {
        TASmod.LOGGER.info(LoggerMarkers.Playback, "Clearing playback controller");
        this.clearInputList();
        EventListenerRegistry.fireEvent(EventPlaybackClient.EventRecordClear.class);
        this.index = 0L;
    }

    private void clearInputList() {
        this.inputs.clear();
    }

    public VirtualKeyboard getNextPlaybackKeyboard() {
        return this.nextPlaybackKeyboard;
    }

    public VirtualMouse getNextPlaybackMouse() {
        return this.nextPlaybackMouse;
    }

    public VirtualCameraAngle getNextPlaybackCameraAngle() {
        return this.nextPlaybackCameraAngle;
    }

    public List<String> getNextKeyboardPresses() {
        return this.nextPlaybackKeyboard.getCurrentPresses();
    }

    public List<String> getNextMousePresses() {
        return this.nextPlaybackMouse.getCurrentPresses();
    }

    public VirtualMouse getNextMouse() {
        return this.nextPlaybackMouse;
    }

    public String toString() {
        if (this.inputs.isEmpty()) {
            return "null";
        }
        LinkedList<String> out = new LinkedList<String>();
        int i = 0;
        while ((long)i < this.inputs.size()) {
            InputContainer input = this.inputs.get(i);
            out.add(input.toString(i));
            ++i;
        }
        return String.join((CharSequence)"\n", out);
    }

    public void unpressContainer() {
        TASmod.LOGGER.trace(LoggerMarkers.Playback, "Unpressing container");
        this.currentPlaybackKeyboard.clear();
        this.currentPlaybackMouse.clear();
    }

    public void setStateWhenOpened(TASstate state) {
        TASmodClient.openMainMenuScheduler.add(() -> this.setTASState(state));
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new TASmodPackets[]{TASmodPackets.PLAYBACK_SAVE, TASmodPackets.PLAYBACK_LOAD, TASmodPackets.PLAYBACK_FULLPLAY, TASmodPackets.PLAYBACK_FULLRECORD, TASmodPackets.PLAYBACK_RESTARTANDPLAY, TASmodPackets.PLAYBACK_CLEAR_INPUTS, TASmodPackets.PLAYBACK_STATE};
    }

    @Override
    public void onClientPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        String name = null;
        String flavor = null;
        class_1600 mc = class_1600.method_2965();
        switch (packet) {
            case PLAYBACK_SAVE: {
                name = TASmodBufferBuilder.readString(buf);
                flavor = TASmodBufferBuilder.readString(buf);
                try {
                    PlaybackSerialiser.saveToFile(this.tasFileDirectory.resolve(name + this.fileEnding), this, flavor);
                }
                catch (PlaybackSaveException e) {
                    if (mc.field_3803 != null) {
                        mc.field_3820.method_983().method_6690((class_1982)new class_1989(class_1442.field_5495 + e.getMessage()));
                    }
                    TASmod.LOGGER.catching((Throwable)e);
                    return;
                }
                catch (Exception e) {
                    if (mc.field_3803 != null) {
                        mc.field_3820.method_983().method_6690((class_1982)new class_1989(class_1442.field_5495 + "Saving failed, something went very wrong"));
                    }
                    TASmod.LOGGER.catching((Throwable)e);
                    return;
                }
                if (mc.field_3803 != null) {
                    class_1989 confirm = new class_1989(class_1442.field_5493 + "Saved inputs to " + name + ".mctas" + class_1442.field_5504 + " [" + class_1442.field_5497 + "Open folder" + class_1442.field_5504 + "]");
                    confirm.method_7470().method_7487(new class_1980(class_1980.class_1981.field_8478, "/folder tasfiles"));
                    mc.field_3820.method_983().method_6690((class_1982)confirm);
                    break;
                }
                TASmod.LOGGER.debug(LoggerMarkers.Playback, "Saved inputs to " + name + ".mctas");
                break;
            }
            case PLAYBACK_LOAD: {
                name = TASmodBufferBuilder.readString(buf);
                flavor = TASmodBufferBuilder.readString(buf);
                try {
                    TASmodClient.controller.setInputs(PlaybackSerialiser.loadFromFile(this.tasFileDirectory.resolve(name + this.fileEnding), flavor));
                }
                catch (PlaybackLoadException e) {
                    if (mc.field_3803 != null) {
                        class_1989 textComponent = new class_1989(e.getMessage());
                        mc.field_3820.method_983().method_6690((class_1982)textComponent);
                    }
                    TASmod.LOGGER.catching((Throwable)e);
                    return;
                }
                catch (Exception e) {
                    if (mc.field_3803 != null) {
                        mc.field_3820.method_983().method_6690((class_1982)new class_1989(class_1442.field_5495 + "Loading failed, something went very wrong"));
                    }
                    TASmod.LOGGER.catching((Throwable)e);
                    return;
                }
                if (mc.field_3803 != null) {
                    mc.field_3820.method_983().method_6690((class_1982)new class_1989(class_1442.field_5493 + "Loaded inputs from " + name + ".mctas"));
                    break;
                }
                TASmod.LOGGER.debug(LoggerMarkers.Playback, "Loaded inputs from " + name + ".mctas");
                break;
            }
            case PLAYBACK_FULLPLAY: {
                this.setStateWhenOpened(TASstate.PLAYBACK);
                TASmodClient.tickSchedulerClient.add(() -> {
                    if (mc.field_3803 != null) {
                        mc.field_3803.method_3577();
                        mc.method_2929((class_478)null);
                    }
                    mc.method_2928((class_388)new class_624());
                });
                break;
            }
            case PLAYBACK_FULLRECORD: {
                this.setStateWhenOpened(TASstate.RECORDING);
                TASmodClient.controller.clear();
                TASmodClient.tickSchedulerClient.add(() -> {
                    TASmodClient.startpositionMetadataExtension.updateStartPosition();
                    if (mc.field_3803 != null) {
                        mc.field_3803.method_3577();
                        mc.method_2929((class_478)null);
                    }
                    mc.method_2928((class_388)new class_624());
                });
                break;
            }
            case PLAYBACK_RESTARTANDPLAY: {
                String tasFilename = ByteBufferBuilder.readString(buf);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                class_1600.method_2965().method_6635(() -> {
                    TASmodClient.config.set((ConfigurationRegistry.ConfigOptions)TASmodConfig.FileToOpen, tasFilename);
                    System.exit(0);
                });
                break;
            }
            case PLAYBACK_CLEAR_INPUTS: {
                TASmodClient.controller.clear();
                break;
            }
            case PLAYBACK_TELEPORT: {
                throw new WrongSideException(packet, Client.Side.CLIENT);
            }
            case PLAYBACK_STATE: {
                TASstate networkState = TASmodBufferBuilder.readEnum(TASstate.class, buf);
                boolean verbose = TASmodBufferBuilder.readBoolean(buf);
                Scheduler.Task task = () -> {
                    String message;
                    PlaybackControllerClient container = TASmodClient.controller;
                    if (networkState != container.getState() && !(message = container.setTASStateClient(networkState, verbose)).isEmpty()) {
                        if (class_1600.method_2965().field_3803 != null) {
                            class_1600.method_2965().field_3820.method_983().method_6690((class_1982)new class_1989(message));
                        } else {
                            TASmod.LOGGER.debug(LoggerMarkers.Playback, message);
                        }
                    }
                };
                if ((networkState == TASstate.RECORDING || networkState == TASstate.PLAYBACK) && TASmodClient.tickratechanger.ticksPerSecond != 0.0f) {
                    TASmodClient.tickSchedulerClient.add(task);
                    break;
                }
                TASmodClient.gameLoopSchedulerClient.add(task);
                break;
            }
            default: {
                throw new PacketNotImplementedException(packet, this.getClass(), Client.Side.CLIENT);
            }
        }
    }

    @Override
    public void onClientInit(class_1600 mc) {
        String fileOnStart = TASmodClient.config.get(TASmodConfig.FileToOpen);
        if (fileOnStart.isEmpty()) {
            return;
        }
        TASmodClient.config.reset(TASmodConfig.FileToOpen);
        try {
            TASmodClient.controller.setInputs(PlaybackSerialiser.loadFromFile(this.tasFileDirectory.resolve(fileOnStart + this.fileEnding)));
        }
        catch (PlaybackLoadException | IOException e) {
            this.logger.catching((Throwable)e);
        }
        this.setTASState(TASstate.PLAYBACK);
    }

    public static enum TASstate {
        NONE,
        PLAYBACK,
        RECORDING,
        PAUSED;

    }

    public static class InputContainer
    implements Serializable {
        private VirtualKeyboard keyboard;
        private VirtualMouse mouse;
        private VirtualCameraAngle cameraAngle;
        private CommentContainer comments;

        public InputContainer(VirtualKeyboard keyboard, VirtualMouse mouse, VirtualCameraAngle subticks) {
            this(keyboard, mouse, subticks, new CommentContainer());
        }

        public InputContainer(VirtualKeyboard keyboard, VirtualMouse mouse, VirtualCameraAngle camera, CommentContainer comments) {
            this.keyboard = keyboard;
            this.mouse = mouse;
            this.cameraAngle = camera;
            this.comments = comments;
        }

        public InputContainer() {
            this(new VirtualKeyboard(), new VirtualMouse(), new VirtualCameraAngle());
        }

        public String toString() {
            return this.toString(-1);
        }

        public String toString(int tick) {
            LinkedList<String> out = new LinkedList<String>();
            out.addAll(this.comments.inlineComments);
            LinkedBlockingQueue<String> keyboardQueue = new LinkedBlockingQueue<String>(Arrays.asList(this.keyboard.toString().split("\n")));
            LinkedBlockingQueue<String> mouseQueue = new LinkedBlockingQueue<String>(Arrays.asList(this.mouse.toString().split("\n")));
            LinkedBlockingQueue<String> cameraAngleQueue = new LinkedBlockingQueue<String>(Arrays.asList(this.cameraAngle.toString().split("\n")));
            LinkedBlockingQueue endlineCommentQueue = new LinkedBlockingQueue(this.comments.endlineComments);
            String kb = this.getOrEmpty((String)keyboardQueue.poll());
            String ms = this.getOrEmpty((String)mouseQueue.poll());
            String ca = this.getOrEmpty((String)cameraAngleQueue.poll());
            String elc = this.getOrEmpty((String)endlineCommentQueue.poll());
            if (!elc.isEmpty()) {
                elc = "\t\t" + elc;
            }
            out.add(String.format("%s|%s|%s|%s%s", tick == -1 ? "undefined" : Integer.valueOf(tick), kb, ms, ca, elc));
            int currentSubtick = 0;
            while (!(keyboardQueue.isEmpty() && mouseQueue.isEmpty() && cameraAngleQueue.isEmpty())) {
                ++currentSubtick;
                kb = this.getOrEmpty((String)keyboardQueue.poll());
                ms = this.getOrEmpty((String)mouseQueue.poll());
                ca = this.getOrEmpty((String)cameraAngleQueue.poll());
                elc = this.getOrEmpty((String)endlineCommentQueue.poll());
                if (!elc.isEmpty()) {
                    elc = "\t\t" + elc;
                }
                out.add(String.format("\t%s|%s|%s|%s%s", currentSubtick, kb, ms, ca, elc));
            }
            return String.join((CharSequence)"\n", out);
        }

        private String getOrEmpty(String string) {
            return string != null ? string : "";
        }

        public VirtualKeyboard getKeyboard() {
            return this.keyboard;
        }

        public VirtualMouse getMouse() {
            return this.mouse;
        }

        public VirtualCameraAngle getCameraAngle() {
            return this.cameraAngle;
        }

        public CommentContainer getComments() {
            if (this.comments == null) {
                return new CommentContainer();
            }
            return this.comments;
        }

        public InputContainer clone() {
            return new InputContainer(this.keyboard, this.mouse, this.cameraAngle);
        }

        public boolean equals(Object other) {
            if (other instanceof InputContainer) {
                InputContainer container = (InputContainer)other;
                return this.keyboard.equals(container.keyboard) && this.mouse.equals(container.mouse) && this.cameraAngle.equals(container.cameraAngle) && this.comments.equals(container.comments);
            }
            return super.equals(other);
        }
    }

    public static class CommentContainer
    implements Serializable {
        private List<String> inlineComments;
        private List<String> endlineComments;

        public CommentContainer() {
            this(new ArrayList<String>(), new ArrayList<String>());
        }

        public CommentContainer(List<String> inlineComments, List<String> endlineComments) {
            this.inlineComments = inlineComments;
            this.endlineComments = endlineComments;
        }

        public void addInlineComment(String inlineComment) {
            this.inlineComments.add(inlineComment);
        }

        public void addEndlineComment(String endlineComment) {
            this.endlineComments.add(endlineComment);
        }

        public List<String> getInlineComments() {
            return this.inlineComments;
        }

        public List<String> getEndlineComments() {
            return this.endlineComments;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CommentContainer) {
                CommentContainer other = (CommentContainer)obj;
                return this.inlineComments.equals(other.inlineComments) && this.endlineComments.equals(other.endlineComments);
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.inlineComments.toString() + "\n\n" + this.endlineComments.toString();
        }
    }
}

