/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback;

import com.minecrafttas.mctcommon.events.EventListenerRegistry;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.events.EventPlaybackServer;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.savestates.SavestateHandlerServer;
import com.minecrafttas.tasmod.savestates.exceptions.LoadstateException;
import com.minecrafttas.tasmod.savestates.exceptions.SavestateException;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import java.nio.ByteBuffer;

public class PlaybackControllerServer
implements ServerPacketHandler {
    private PlaybackControllerClient.TASstate state = PlaybackControllerClient.TASstate.NONE;

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new TASmodPackets[]{TASmodPackets.PLAYBACK_STATE, TASmodPackets.PLAYBACK_CLEAR_INPUTS, TASmodPackets.PLAYBACK_FULLPLAY, TASmodPackets.PLAYBACK_FULLRECORD, TASmodPackets.PLAYBACK_RESTARTANDPLAY, TASmodPackets.PLAYBACK_SAVE, TASmodPackets.PLAYBACK_LOAD};
    }

    @Override
    public void onServerPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case PLAYBACK_STATE: {
                PlaybackControllerClient.TASstate networkState = TASmodBufferBuilder.readEnum(PlaybackControllerClient.TASstate.class, buf);
                this.setTASState(networkState);
                break;
            }
            case PLAYBACK_CLEAR_INPUTS: {
                this.clearInputs();
                break;
            }
            case PLAYBACK_FULLRECORD: {
                this.fullRecord();
                break;
            }
            case PLAYBACK_FULLPLAY: {
                this.fullPlay();
                break;
            }
            case PLAYBACK_RESTARTANDPLAY: {
                String tasFileName = TASmodBufferBuilder.readString(buf);
                this.restartAndPlay(tasFileName);
                break;
            }
            case PLAYBACK_SAVE: 
            case PLAYBACK_LOAD: {
                TASmod.server.sendToAll(new TASmodBufferBuilder(buf));
                break;
            }
            default: {
                throw new PacketNotImplementedException(packet, this.getClass(), Client.Side.SERVER);
            }
        }
    }

    public void setTASState(PlaybackControllerClient.TASstate stateIn) {
        this.setTASStateServer(stateIn);
        try {
            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.PLAYBACK_STATE).writeEnum(this.state).writeBoolean(true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTASStateServer(PlaybackControllerClient.TASstate stateIn) {
        if (this.state != stateIn) {
            if (this.state == PlaybackControllerClient.TASstate.RECORDING && stateIn == PlaybackControllerClient.TASstate.PLAYBACK) {
                return;
            }
            if (this.state == PlaybackControllerClient.TASstate.NONE && this.state == PlaybackControllerClient.TASstate.PAUSED) {
                return;
            }
            EventListenerRegistry.fireEvent(EventPlaybackServer.EventControllerStateChange.class, new Object[]{stateIn, this.state});
            this.state = stateIn;
            TASmod.LOGGER.info(LoggerMarkers.Playback, "Set the server state to {}", (Object)stateIn.toString());
        }
    }

    public void toggleRecording() {
        this.setTASState(this.state == PlaybackControllerClient.TASstate.RECORDING ? PlaybackControllerClient.TASstate.NONE : PlaybackControllerClient.TASstate.RECORDING);
    }

    public void togglePlayback() {
        this.setTASState(this.state == PlaybackControllerClient.TASstate.PLAYBACK ? PlaybackControllerClient.TASstate.NONE : PlaybackControllerClient.TASstate.PLAYBACK);
    }

    public void clearInputs() {
        EventListenerRegistry.fireEvent(EventPlaybackServer.EventRecordClear.class);
        try {
            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.PLAYBACK_CLEAR_INPUTS));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PlaybackControllerClient.TASstate getState() {
        return this.state;
    }

    public void fullRecord() {
        SavestateHandlerServer.SavestateCallback cb = paths -> {
            try {
                TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_CLEAR_SCREEN));
            }
            catch (Exception e) {
                TASmod.LOGGER.catching((Throwable)e);
            }
        };
        TASmod.tickSchedulerServer.add(() -> {
            try {
                TASmod.savestateHandlerServer.saveState(0, cb, SavestateHandlerServer.SavestateFlags.BLOCK_PAUSE_TICKRATE);
            }
            catch (SavestateException e) {
                TASmod.LOGGER.catching((Throwable)e);
                return;
            }
            finally {
                TASmod.savestateHandlerServer.resetState();
            }
            this.setTASStateServer(PlaybackControllerClient.TASstate.RECORDING);
            try {
                TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.PLAYBACK_FULLRECORD));
            }
            catch (Exception e) {
                TASmod.LOGGER.catching((Throwable)e);
            }
        });
    }

    public void fullPlay() {
        SavestateHandlerServer.SavestateCallback cb = paths -> {
            try {
                TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_CLEAR_SCREEN));
            }
            catch (Exception e) {
                TASmod.LOGGER.catching((Throwable)e);
            }
        };
        TASmod.tickSchedulerServer.add(() -> {
            try {
                TASmod.savestateHandlerServer.loadState(0, cb, SavestateHandlerServer.SavestateFlags.BLOCK_CHANGE_INDEX, SavestateHandlerServer.SavestateFlags.BLOCK_PAUSE_TICKRATE);
            }
            catch (LoadstateException e) {
                TASmod.LOGGER.catching((Throwable)e);
                return;
            }
            finally {
                TASmod.savestateHandlerServer.resetState();
            }
            this.setTASStateServer(PlaybackControllerClient.TASstate.PLAYBACK);
            try {
                TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.PLAYBACK_FULLPLAY));
            }
            catch (Exception e) {
                TASmod.LOGGER.catching((Throwable)e);
            }
        });
    }

    public void restartAndPlay(String tasFileName) {
        TASmod.savestateHandlerServer.getSavestateTemporaryHandler().setNoSave(true);
        TASmod.playbackControllerServer.setTASStateServer(PlaybackControllerClient.TASstate.PLAYBACK);
        TASmod.tickSchedulerServer.add(() -> {
            try {
                TASmod.savestateHandlerServer.loadState(0, null, SavestateHandlerServer.SavestateFlags.BLOCK_PAUSE_TICKRATE);
            }
            catch (LoadstateException e) {
                TASmod.LOGGER.catching((Throwable)e);
                TASmod.savestateHandlerServer.resetState();
                TASmod.tickratechanger.pauseGame(false);
                return;
            }
            try {
                TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.PLAYBACK_RESTARTANDPLAY).writeString(tasFileName));
            }
            catch (Exception e) {
                TASmod.LOGGER.catching((Throwable)e);
            }
        });
    }
}

