/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback.filecommands;

import com.dselent.bigarraylist.BigArrayList;
import com.minecrafttas.mctcommon.file.AbstractDataFile;
import com.minecrafttas.mctcommon.registry.Registerable;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class PlaybackFileCommand {
    private String name;
    private String[] args;

    public PlaybackFileCommand(String name) {
        this(name, null);
    }

    public PlaybackFileCommand(String name, String ... args) {
        if (args == null) {
            args = new String[]{};
        }
        this.name = name;
        this.args = args;
    }

    public String getName() {
        return this.name;
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PlaybackFileCommand) {
            PlaybackFileCommand other = (PlaybackFileCommand)obj;
            return this.name.equals(other.name) && Arrays.equals(this.args, other.args);
        }
        return super.equals(obj);
    }

    public String toString() {
        return String.format("$%s(%s);", this.name, String.join((CharSequence)", ", this.args));
    }

    public static class SortedFileCommandContainer
    extends LinkedHashMap<String, FileCommandsInTickList> {
        public void add(String key, PlaybackFileCommand fileCommand) {
            FileCommandsInTickList toAdd = this.getOrDefault(key, new FileCommandsInTickList());
            if (toAdd.isEmpty()) {
                this.put(key, toAdd);
            }
            toAdd.add(fileCommand);
        }

        public SortedFileCommandContainer split(String ... keys) {
            return this.split(Arrays.asList(keys));
        }

        public SortedFileCommandContainer split(Iterable<String> keys) {
            SortedFileCommandContainer out = new SortedFileCommandContainer();
            for (String key : keys) {
                if (!this.containsKey(key)) continue;
                out.put(key, (FileCommandsInTickList)this.get(key));
            }
            return out;
        }

        public UnsortedFileCommandContainer unsort() {
            UnsortedFileCommandContainer out = new UnsortedFileCommandContainer();
            int biggestSize = 0;
            for (FileCommandsInTickList list : this.values()) {
                if (list.size() <= biggestSize) continue;
                biggestSize = list.size();
            }
            for (int i = 0; i < biggestSize; ++i) {
                FileCommandsInCommentList unsortedFileCommandsList = new FileCommandsInCommentList();
                for (FileCommandsInTickList list : this.values()) {
                    if (i < list.size()) {
                        PlaybackFileCommand fileCommand = (PlaybackFileCommand)list.get(i);
                        unsortedFileCommandsList.add(fileCommand);
                        continue;
                    }
                    unsortedFileCommandsList.add(null);
                }
                out.add(unsortedFileCommandsList);
            }
            return out;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof SortedFileCommandContainer) {
                SortedFileCommandContainer other = (SortedFileCommandContainer)o;
                if (this.size() != other.size()) {
                    return false;
                }
                for (Map.Entry entry : other.entrySet()) {
                    String key = (String)entry.getKey();
                    FileCommandsInTickList val = (FileCommandsInTickList)entry.getValue();
                    if (this.containsKey(key) || ((FileCommandsInTickList)this.get(key)).equals(val)) continue;
                    return false;
                }
                return true;
            }
            return super.equals(o);
        }
    }

    public static class FileCommandsInTickList
    extends ArrayList<PlaybackFileCommand> {
    }

    public static class UnsortedFileCommandContainer
    extends ArrayList<FileCommandsInCommentList> {
        public SortedFileCommandContainer sort() {
            SortedFileCommandContainer out = new SortedFileCommandContainer();
            for (FileCommandsInCommentList unsortedFileCommandsList : this) {
                if (unsortedFileCommandsList == null) continue;
                for (PlaybackFileCommand playbackFileCommand : unsortedFileCommandsList) {
                    out.put(playbackFileCommand.getName(), new FileCommandsInTickList());
                }
            }
            for (FileCommandsInCommentList unsortedFileCommandsList : this) {
                for (Map.Entry entry : out.entrySet()) {
                    String sortedKey = (String)entry.getKey();
                    FileCommandsInTickList sortedFileCommandsList = (FileCommandsInTickList)entry.getValue();
                    boolean valuePresent = false;
                    if (unsortedFileCommandsList != null) {
                        for (PlaybackFileCommand command : unsortedFileCommandsList) {
                            if (!sortedKey.equals(command.getName())) continue;
                            valuePresent = true;
                            sortedFileCommandsList.add(command);
                        }
                    }
                    if (valuePresent) continue;
                    sortedFileCommandsList.add(null);
                }
            }
            return out;
        }
    }

    public static class FileCommandsInCommentList
    extends ArrayList<PlaybackFileCommand> {
    }

    public static abstract class PlaybackFileCommandExtension
    implements Registerable {
        protected final Path tempDir;
        protected BigArrayList<SortedFileCommandContainer> inlineFileCommandStorage;
        protected BigArrayList<SortedFileCommandContainer> endlineFileCommandStorage;
        protected boolean enabled = false;

        public PlaybackFileCommandExtension() {
            this((Path)null);
        }

        public PlaybackFileCommandExtension(String tempFolderName) {
            this(TASmodClient.tasfiledirectory.resolve("temp").resolve(tempFolderName));
        }

        public PlaybackFileCommandExtension(Path tempDirectory) {
            if (tempDirectory == null) {
                this.tempDir = null;
                this.inlineFileCommandStorage = new BigArrayList();
                this.endlineFileCommandStorage = new BigArrayList();
                return;
            }
            this.tempDir = tempDirectory;
            try {
                AbstractDataFile.createDirectory(tempDirectory);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.inlineFileCommandStorage = new BigArrayList(this.tempDir.toString());
            this.endlineFileCommandStorage = new BigArrayList(this.tempDir.toString());
        }

        public abstract String[] getFileCommandNames();

        public void onEnable() {
        }

        public void onDisable() {
        }

        public void onClear() {
            this.inlineFileCommandStorage.clear();
            this.endlineFileCommandStorage.clear();
        }

        public void onRecord(long tick, PlaybackControllerClient.InputContainer inputContainer) {
        }

        public void onPlayback(long tick, PlaybackControllerClient.InputContainer inputContainer) {
        }

        public SortedFileCommandContainer onSerialiseInlineComment(long tick, PlaybackControllerClient.InputContainer inputContainer) {
            SortedFileCommandContainer out = new SortedFileCommandContainer();
            if (tick >= this.inlineFileCommandStorage.size()) {
                return out;
            }
            SortedFileCommandContainer currentTick = this.inlineFileCommandStorage.get(tick);
            if (currentTick == null) {
                return out;
            }
            for (String name : this.getFileCommandNames()) {
                if (currentTick.get(name) == null) continue;
                out.putAll(currentTick.split(name));
            }
            return out;
        }

        public SortedFileCommandContainer onSerialiseEndlineComment(long tick, PlaybackControllerClient.InputContainer inputContainer) {
            SortedFileCommandContainer out = new SortedFileCommandContainer();
            if (tick >= this.endlineFileCommandStorage.size()) {
                return out;
            }
            SortedFileCommandContainer currentTick = this.endlineFileCommandStorage.get(tick);
            if (currentTick == null) {
                return out;
            }
            for (String name : this.getFileCommandNames()) {
                if (currentTick.get(name) == null) continue;
                out.putAll(currentTick.split(name));
            }
            return out;
        }

        public void onDeserialiseInlineComment(long tick, PlaybackControllerClient.InputContainer inputContainer, SortedFileCommandContainer fileCommandContainer) {
            if (fileCommandContainer == null) {
                return;
            }
            this.inlineFileCommandStorage.add(fileCommandContainer);
        }

        public void onDeserialiseEndlineComment(long tick, PlaybackControllerClient.InputContainer inputContainer, SortedFileCommandContainer fileCommandContainer) {
            if (fileCommandContainer == null) {
                return;
            }
            this.endlineFileCommandStorage.add(fileCommandContainer);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            if (enabled) {
                this.onEnable();
            } else {
                this.onDisable();
            }
            this.enabled = enabled;
        }

        public String toString() {
            return this.getExtensionName();
        }
    }
}

