/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback.filecommands;

import com.minecrafttas.mctcommon.Configuration;
import com.minecrafttas.mctcommon.ConfigurationRegistry;
import com.minecrafttas.mctcommon.registry.AbstractRegistry;
import com.minecrafttas.tasmod.events.EventPlaybackClient;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.playback.filecommands.PlaybackFileCommand;
import com.minecrafttas.tasmod.registries.TASmodConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

public class PlaybackFileCommandsRegistry
extends AbstractRegistry<PlaybackFileCommand.PlaybackFileCommandExtension>
implements EventPlaybackClient.EventRecordTick,
EventPlaybackClient.EventPlaybackTick,
EventPlaybackClient.EventRecordClear {
    private List<PlaybackFileCommand.PlaybackFileCommandExtension> enabledExtensions = new ArrayList<PlaybackFileCommand.PlaybackFileCommandExtension>();
    private Configuration config = null;

    public PlaybackFileCommandsRegistry() {
        super("FILECOMMAND_REGISTRY", new LinkedHashMap());
    }

    @Override
    public void register(PlaybackFileCommand.PlaybackFileCommandExtension extension) {
        super.register(extension);
        this.enabledExtensions = this.getEnabled();
    }

    @Override
    public void unregister(PlaybackFileCommand.PlaybackFileCommandExtension extension) {
        super.unregister(extension);
        this.enabledExtensions = this.getEnabled();
    }

    public boolean setEnabled(String extensionName, boolean enabled) {
        return this.setEnabled(extensionName, enabled, true);
    }

    public boolean setEnabled(String extensionName, boolean enabled, boolean saveToConfig) {
        PlaybackFileCommand.PlaybackFileCommandExtension extension = (PlaybackFileCommand.PlaybackFileCommandExtension)this.REGISTRY.get(extensionName);
        if (extension == null) {
            return false;
        }
        extension.setEnabled(enabled);
        this.enabledExtensions = this.getEnabled();
        if (saveToConfig) {
            this.saveConfig();
        }
        return true;
    }

    private void disableAll() {
        this.REGISTRY.forEach((name, value) -> value.setEnabled(false));
    }

    public void setEnabled(String ... extensionNames) {
        this.setEnabled(Arrays.asList(extensionNames));
    }

    public void setEnabled(List<String> extensionNames) {
        this.setEnabled(extensionNames, false);
    }

    public void setEnabled(List<String> extensionNames, boolean saveToConfig) {
        this.disableAll();
        for (String name : extensionNames) {
            this.setEnabled(name, true, false);
        }
        if (saveToConfig) {
            this.saveConfig();
        }
    }

    public List<PlaybackFileCommand.PlaybackFileCommandExtension> getEnabled() {
        ArrayList<PlaybackFileCommand.PlaybackFileCommandExtension> out = new ArrayList<PlaybackFileCommand.PlaybackFileCommandExtension>();
        for (PlaybackFileCommand.PlaybackFileCommandExtension element : this.REGISTRY.values()) {
            if (!element.isEnabled()) continue;
            out.add(element);
        }
        return out;
    }

    public List<PlaybackFileCommand.PlaybackFileCommandExtension> getAll() {
        return new ArrayList<PlaybackFileCommand.PlaybackFileCommandExtension>(this.REGISTRY.values());
    }

    @Override
    public void onRecordTick(long index, PlaybackControllerClient.InputContainer container) {
        this.enabledExtensions.forEach(extension -> {
            if (extension.isEnabled()) {
                extension.onRecord(index, container);
            }
        });
    }

    @Override
    public void onPlaybackTick(long index, PlaybackControllerClient.InputContainer container) {
        this.enabledExtensions.forEach(extension -> {
            if (extension.isEnabled()) {
                extension.onPlayback(index, container);
            }
        });
    }

    public PlaybackFileCommand.UnsortedFileCommandContainer handleOnSerialiseInline(long currentTick, PlaybackControllerClient.InputContainer container) {
        PlaybackFileCommand.SortedFileCommandContainer out = new PlaybackFileCommand.SortedFileCommandContainer();
        for (PlaybackFileCommand.PlaybackFileCommandExtension extension : this.enabledExtensions) {
            PlaybackFileCommand.SortedFileCommandContainer extensionContainer = extension.onSerialiseInlineComment(currentTick, container);
            if (extensionContainer == null) continue;
            out.putAll(extensionContainer);
        }
        return out.unsort();
    }

    public PlaybackFileCommand.UnsortedFileCommandContainer handleOnSerialiseEndline(long currentTick, PlaybackControllerClient.InputContainer container) {
        PlaybackFileCommand.SortedFileCommandContainer out = new PlaybackFileCommand.SortedFileCommandContainer();
        for (PlaybackFileCommand.PlaybackFileCommandExtension extension : this.enabledExtensions) {
            PlaybackFileCommand.SortedFileCommandContainer extensionContainer = extension.onSerialiseEndlineComment(currentTick, container);
            if (extensionContainer == null) continue;
            out.putAll(extensionContainer);
        }
        return out.unsort();
    }

    public void handleOnDeserialiseInline(long currentTick, PlaybackControllerClient.InputContainer deserialisedContainer, PlaybackFileCommand.UnsortedFileCommandContainer unsortedInlineFileCommands) {
        PlaybackFileCommand.SortedFileCommandContainer fileCommandContainer = unsortedInlineFileCommands.sort();
        for (PlaybackFileCommand.PlaybackFileCommandExtension extension : this.enabledExtensions) {
            String[] fileCommandNames = extension.getFileCommandNames();
            extension.onDeserialiseInlineComment(currentTick, deserialisedContainer, fileCommandContainer.split(fileCommandNames));
        }
    }

    public void handleOnDeserialiseEndline(long currentTick, PlaybackControllerClient.InputContainer deserialisedContainer, PlaybackFileCommand.UnsortedFileCommandContainer unsortedEndlineFileCommands) {
        PlaybackFileCommand.SortedFileCommandContainer sortedEndlineFileCommands = unsortedEndlineFileCommands.sort();
        for (PlaybackFileCommand.PlaybackFileCommandExtension extension : this.enabledExtensions) {
            String[] fileCommandNames = extension.getFileCommandNames();
            extension.onDeserialiseEndlineComment(currentTick, deserialisedContainer, sortedEndlineFileCommands.split(fileCommandNames));
        }
    }

    @Override
    public void onRecordingClear() {
        this.onClear();
    }

    public void onClear() {
        this.REGISTRY.values().forEach(fileCommandExtension -> fileCommandExtension.onClear());
    }

    public void setConfig(Configuration config) {
        this.config = config;
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.config == null) {
            return;
        }
        String enabled = this.config.get(TASmodConfig.EnabledFileCommands);
        this.setEnabled(Arrays.asList(enabled.split(", ")));
    }

    private void saveConfig() {
        if (this.config == null) {
            return;
        }
        ArrayList nameList = new ArrayList();
        this.enabledExtensions.forEach(element -> nameList.add(element.getExtensionName()));
        this.config.set((ConfigurationRegistry.ConfigOptions)TASmodConfig.EnabledFileCommands, String.join((CharSequence)", ", nameList));
        this.config.save();
    }
}

