/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback.filecommands.builtin;

import com.dselent.bigarraylist.BigArrayList;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.events.EventPlaybackClient;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.playback.filecommands.PlaybackFileCommand;
import com.minecrafttas.tasmod.playback.tasfile.exception.PlaybackLoadException;
import java.io.Serializable;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1442;
import net.minecraft.class_1600;
import net.minecraft.class_518;

public class DesyncMonitorFileCommandExtension
extends PlaybackFileCommand.PlaybackFileCommandExtension
implements EventPlaybackClient.EventControllerStateChange,
EventPlaybackClient.EventInputDelete {
    private BigArrayList<MonitorContainer> monitorContainer;
    private MonitorContainer currentValues;
    private String lastStatus = class_1442.field_5490 + "Empty";
    private String lastPos = "";
    private String lastMotion = "";

    public DesyncMonitorFileCommandExtension() {
        this("monitoring");
    }

    public DesyncMonitorFileCommandExtension(String tempDirName) {
        super(tempDirName);
        this.monitorContainer = new BigArrayList(this.tempDir.toString());
        this.enabled = true;
    }

    public DesyncMonitorFileCommandExtension(Path tempDir) {
        super(tempDir);
        this.monitorContainer = new BigArrayList(tempDir.toString());
        this.enabled = true;
    }

    @Override
    public String getExtensionName() {
        return "tasmod_desyncMonitor@v1";
    }

    @Override
    public String[] getFileCommandNames() {
        return new String[]{"desyncMonitor"};
    }

    @Override
    public void onControllerStateChange(PlaybackControllerClient.TASstate newstate, PlaybackControllerClient.TASstate oldstate) {
        if (newstate == PlaybackControllerClient.TASstate.RECORDING && this.monitorContainer.isEmpty()) {
            this.recordNull(0L);
        }
        this.currentValues = null;
    }

    @Override
    public void onRecord(long tick, PlaybackControllerClient.InputContainer inputContainer) {
        class_518 player = class_1600.method_2965().field_10310;
        MonitorContainer values = null;
        values = player != null ? new MonitorContainer(tick, player.field_3252, player.field_3253, player.field_3254, player.field_3255, player.field_3256, player.field_3257) : new MonitorContainer(tick);
        if (this.monitorContainer.size() <= tick) {
            this.monitorContainer.add(values);
        } else {
            this.monitorContainer.set(tick, values);
        }
    }

    @Override
    public void onDisable() {
        this.onClear();
    }

    @Override
    public PlaybackFileCommand.SortedFileCommandContainer onSerialiseEndlineComment(long currentTick, PlaybackControllerClient.InputContainer inputContainer) {
        PlaybackFileCommand.SortedFileCommandContainer out = new PlaybackFileCommand.SortedFileCommandContainer();
        MonitorContainer monitoredValues = this.monitorContainer.get(currentTick);
        PlaybackFileCommand command = new PlaybackFileCommand("desyncMonitor", monitoredValues.toStringArray());
        out.add("desyncMonitor", command);
        return out;
    }

    @Override
    public void onDeserialiseEndlineComment(long tick, PlaybackControllerClient.InputContainer container, PlaybackFileCommand.SortedFileCommandContainer fileCommandContainer) {
        List commandsEndline = (List)fileCommandContainer.get("desyncMonitor");
        if (commandsEndline == null || commandsEndline.isEmpty()) {
            this.recordNull(tick);
            return;
        }
        PlaybackFileCommand command = (PlaybackFileCommand)commandsEndline.get(0);
        this.monitorContainer.add(this.loadFromFile(tick, command.getArgs()));
    }

    public void recordNull(long tick) {
        if (this.monitorContainer.size() <= tick) {
            this.monitorContainer.add(new MonitorContainer(tick));
        } else {
            this.monitorContainer.set(tick, new MonitorContainer(tick));
        }
    }

    @Override
    public void onPlayback(long tick, PlaybackControllerClient.InputContainer inputContainer) {
        this.currentValues = this.get(tick - 1L);
    }

    private MonitorContainer loadFromFile(long tick, String[] args) throws PlaybackLoadException {
        if (args.length != 6) {
            throw new PlaybackLoadException("Could not load desyncMonitor file command in tick %s. The amount of arguments doesn't match: %s", tick, args.length);
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double mx = 0.0;
        double my = 0.0;
        double mz = 0.0;
        try {
            x = this.parseDouble(args[0]);
            y = this.parseDouble(args[1]);
            z = this.parseDouble(args[2]);
            mx = this.parseDouble(args[3]);
            my = this.parseDouble(args[4]);
            mz = this.parseDouble(args[5]);
        }
        catch (ParseException e) {
            throw new PlaybackLoadException(e);
        }
        return new MonitorContainer(tick, x, y, z, mx, my, mz);
    }

    public MonitorContainer get(long l) {
        try {
            return this.monitorContainer.get(l);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public String getStatus(class_518 player) {
        if (!TASmodClient.controller.isNothingPlaying()) {
            if (this.currentValues != null) {
                double[] playervalues = new double[]{player.field_3252, player.field_3253, player.field_3254, player.field_3255, player.field_3256, player.field_3257};
                DesyncStatus status = this.currentValues.getSeverity(playervalues);
                this.lastStatus = status.getFormat() + status.getText();
            } else {
                this.lastStatus = class_1442.field_5490 + "Empty";
            }
        }
        return this.lastStatus;
    }

    public String getPos() {
        if (this.currentValues != null && TASmodClient.controller.isPlayingback()) {
            class_518 player = class_1600.method_2965().field_10310;
            CharSequence[] values = new String[]{this.getFormattedString(player.field_3252 - this.currentValues.values[0]), this.getFormattedString(player.field_3253 - this.currentValues.values[1]), this.getFormattedString(player.field_3254 - this.currentValues.values[2])};
            this.lastPos = String.join((CharSequence)" ", values);
        }
        return this.lastPos;
    }

    public String getMotion() {
        if (this.currentValues != null && TASmodClient.controller.isPlayingback()) {
            class_518 player = class_1600.method_2965().field_10310;
            CharSequence[] values = new String[]{this.getFormattedString(player.field_3255 - this.currentValues.values[3]), this.getFormattedString(player.field_3256 - this.currentValues.values[4]), this.getFormattedString(player.field_3257 - this.currentValues.values[5])};
            this.lastMotion = String.join((CharSequence)" ", values);
        }
        return this.lastMotion;
    }

    private String getFormattedString(double delta) {
        String out = "";
        if (delta != 0.0) {
            DesyncStatus status = DesyncStatus.fromDelta(delta);
            if (status == DesyncStatus.EQUAL) {
                return "";
            }
            out = status.getFormat() + Double.toString(delta);
        }
        return out;
    }

    private double parseDouble(String doublestring) throws ParseException {
        NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
        Number number = format.parse(doublestring);
        return number.doubleValue();
    }

    @Override
    public void onClear() {
        this.currentValues = null;
        this.monitorContainer.clear();
        this.lastStatus = class_1442.field_5490 + "Empty";
        this.lastPos = "";
        this.lastMotion = "";
    }

    @Override
    public void onInputDelete(long index) {
        this.monitorContainer.remove(index);
    }

    public class MonitorContainer
    implements Serializable {
        private static final long serialVersionUID = -3138791930493647885L;
        long index;
        double[] values = new double[6];

        public MonitorContainer(long index, double posx, double posy, double posz, double velx, double vely, double velz) {
            this.index = index;
            this.values[0] = posx;
            this.values[1] = posy;
            this.values[2] = posz;
            this.values[3] = velx;
            this.values[4] = vely;
            this.values[5] = velz;
        }

        public MonitorContainer(long index) {
            this(index, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }

        public String[] toStringArray() {
            String[] out = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                out[i] = String.format(Locale.ENGLISH, "%s", this.values[i]);
            }
            return out;
        }

        public String toString() {
            return String.format(Locale.ENGLISH, "%d, %d, %d, %d, %d, %d", this.values[0], this.values[1], this.values[2], this.values[3], this.values[4], this.values[5]);
        }

        public DesyncStatus getSeverity(double[] playerValues) {
            DesyncStatus out = null;
            for (int i = 0; i < this.values.length; ++i) {
                double delta = 0.0;
                try {
                    delta = playerValues[i] - this.values[i];
                }
                catch (Exception e) {
                    return DesyncStatus.ERROR;
                }
                DesyncStatus status = DesyncStatus.fromDelta(delta);
                if (out != null && status.getSeverity() <= out.getSeverity()) continue;
                out = status;
            }
            return out;
        }
    }

    public static enum DesyncStatus {
        EQUAL(0, class_1442.field_5493, "In sync", 0.0),
        WARNING(1, class_1442.field_5497, "Slight desync", 1.0E-5),
        MODERATE(2, class_1442.field_5495, "Moderate desync", 0.01),
        TOTAL(3, class_1442.field_5487, "Total desync"),
        ERROR(3, class_1442.field_5488, "ERROR");

        private Double tolerance;
        private int severity;
        private String text;
        private class_1442 format;

        private DesyncStatus(int severity, class_1442 color, String text) {
            this.severity = severity;
            this.format = color;
            this.text = text;
            this.tolerance = null;
        }

        private DesyncStatus(int severity, class_1442 color, String text, double tolerance) {
            this(severity, color, text);
            this.tolerance = tolerance;
        }

        public static DesyncStatus fromDelta(double delta) {
            DesyncStatus out = TOTAL;
            for (DesyncStatus status : DesyncStatus.values()) {
                if (status.tolerance == null) {
                    return status;
                }
                if (Math.abs(delta) < status.tolerance) break;
                if (!(Math.abs(delta) >= status.tolerance)) continue;
                out = status;
            }
            return out;
        }

        public class_1442 getFormat() {
            return this.format;
        }

        public int getSeverity() {
            return this.severity;
        }

        public String getText() {
            return this.text;
        }
    }
}

