/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback.filecommands.builtin;

import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.playback.filecommands.PlaybackFileCommand;
import java.nio.file.Path;

public class LabelFileCommandExtension
extends PlaybackFileCommand.PlaybackFileCommandExtension {
    private String labelText = "";

    public LabelFileCommandExtension() {
        this("label");
    }

    public LabelFileCommandExtension(String tempDirName) {
        super(tempDirName);
        this.enabled = true;
    }

    public LabelFileCommandExtension(Path tempDir) {
        super(tempDir);
        this.enabled = true;
    }

    @Override
    public String getExtensionName() {
        return "tasmod_label@v1";
    }

    @Override
    public String[] getFileCommandNames() {
        return new String[]{"label"};
    }

    @Override
    public void onPlayback(long tick, PlaybackControllerClient.InputContainer inputContainer) {
        if (this.inlineFileCommandStorage.size() <= tick) {
            return;
        }
        PlaybackFileCommand.SortedFileCommandContainer containerInTick = (PlaybackFileCommand.SortedFileCommandContainer)this.inlineFileCommandStorage.get(tick);
        if (containerInTick == null) {
            return;
        }
        PlaybackFileCommand.FileCommandsInTickList line = (PlaybackFileCommand.FileCommandsInTickList)containerInTick.get("label");
        if (line == null) {
            return;
        }
        for (PlaybackFileCommand command : line) {
            if (command == null) continue;
            this.labelText = String.join((CharSequence)", ", command.getArgs());
        }
    }

    @Override
    public void onClear() {
        super.onClear();
        this.labelText = "";
    }

    public String getLabelText() {
        return this.labelText;
    }
}

